/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.convert;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.aoju.bus.core.codec.Base64;
import org.aoju.bus.core.convert.AbstractConverter;
import org.aoju.bus.core.convert.Convert;
import org.aoju.bus.core.toolkit.ArrayKit;
import org.aoju.bus.core.toolkit.ByteKit;
import org.aoju.bus.core.toolkit.CollKit;
import org.aoju.bus.core.toolkit.ObjectKit;
import org.aoju.bus.core.toolkit.StringKit;

public class ArrayConverter
extends AbstractConverter {
    private static final long serialVersionUID = 1L;
    public static final ArrayConverter INSTANCE = new ArrayConverter();
    private boolean ignoreElementError;

    public ArrayConverter() {
        this(false);
    }

    public ArrayConverter(boolean ignoreElementError) {
        this.ignoreElementError = ignoreElementError;
    }

    @Override
    protected Object convertInternal(Class<?> targetClass, Object value) {
        Class<?> targetComponentType = targetClass.isArray() ? targetClass.getComponentType() : targetClass;
        return value.getClass().isArray() ? this.convertArrayToArray(targetComponentType, value) : this.convertObjectToArray(targetComponentType, value);
    }

    public void setIgnoreElementError(boolean ignoreElementError) {
        this.ignoreElementError = ignoreElementError;
    }

    private Object convertArrayToArray(Class<?> targetComponentType, Object array) {
        Class<?> valueComponentType = ArrayKit.getComponentType(array);
        if (valueComponentType == targetComponentType) {
            return array;
        }
        int len = ArrayKit.length(array);
        Object result = Array.newInstance(targetComponentType, len);
        for (int i = 0; i < len; ++i) {
            Array.set(result, i, this.convertComponentType(targetComponentType, Array.get(array, i)));
        }
        return result;
    }

    private Object convertObjectToArray(Class<?> targetComponentType, Object value) {
        Object result;
        if (value instanceof CharSequence) {
            if (targetComponentType == Character.TYPE || targetComponentType == Character.class) {
                return this.convertArrayToArray(targetComponentType, value.toString().toCharArray());
            }
            if (targetComponentType == Byte.TYPE) {
                String str = value.toString();
                if (Base64.isBase64(str)) {
                    return Base64.decode(value.toString());
                }
                return str.getBytes();
            }
            String[] strings = StringKit.splitToArray((CharSequence)value.toString(), ",");
            return this.convertArrayToArray(targetComponentType, strings);
        }
        if (value instanceof List) {
            List list = (List)value;
            result = Array.newInstance(targetComponentType, list.size());
            for (int i = 0; i < list.size(); ++i) {
                Array.set(result, i, this.convertComponentType(targetComponentType, list.get(i)));
            }
        } else if (value instanceof Collection) {
            Collection collection = (Collection)value;
            result = Array.newInstance(targetComponentType, collection.size());
            int i = 0;
            for (Object element : collection) {
                Array.set(result, i, this.convertComponentType(targetComponentType, element));
                ++i;
            }
        } else if (value instanceof Iterable) {
            List<Iterable> list = CollKit.of((Iterable)value);
            result = Array.newInstance(targetComponentType, list.size());
            for (int i = 0; i < list.size(); ++i) {
                Array.set(result, i, this.convertComponentType(targetComponentType, list.get(i)));
            }
        } else if (value instanceof Iterator) {
            List<Iterator> list = CollKit.of((Iterator)value);
            result = Array.newInstance(targetComponentType, list.size());
            for (int i = 0; i < list.size(); ++i) {
                Array.set(result, i, this.convertComponentType(targetComponentType, list.get(i)));
            }
        } else {
            result = value instanceof Number && Byte.TYPE == targetComponentType ? (Object)ByteKit.getBytes((Number)value) : (value instanceof Serializable && Byte.TYPE == targetComponentType ? (Object)ObjectKit.serialize(value) : this.convertToSingleElementArray(targetComponentType, value));
        }
        return result;
    }

    private Object[] convertToSingleElementArray(Class<?> targetComponentType, Object value) {
        Object[] singleElementArray = ArrayKit.newArray(targetComponentType, 1);
        singleElementArray[0] = this.convertComponentType(targetComponentType, value);
        return singleElementArray;
    }

    private Object convertComponentType(Class<?> targetComponentType, Object value) {
        return Convert.convertWithCheck(targetComponentType, value, null, this.ignoreElementError);
    }
}

