/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.convert;

import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import org.aoju.bus.core.convert.ArrayConverter;
import org.aoju.bus.core.convert.BeanConverter;
import org.aoju.bus.core.convert.CollectionConverter;
import org.aoju.bus.core.convert.Converter;
import org.aoju.bus.core.convert.EnumConverter;
import org.aoju.bus.core.convert.MapConverter;
import org.aoju.bus.core.convert.NumberConverter;
import org.aoju.bus.core.convert.PrimitiveConverter;
import org.aoju.bus.core.convert.RegistryConverter;
import org.aoju.bus.core.exception.ConvertException;
import org.aoju.bus.core.lang.Types;
import org.aoju.bus.core.toolkit.BeanKit;
import org.aoju.bus.core.toolkit.ObjectKit;
import org.aoju.bus.core.toolkit.TypeKit;

public class CompositeConverter
extends RegistryConverter {
    private static final long serialVersionUID = 1L;

    public static CompositeConverter getInstance() {
        return SingletonHolder.INSTANCE;
    }

    @Override
    public Object convert(Type type, Object value) throws ConvertException {
        return this.convert(type, value, null);
    }

    @Override
    public <T> T convert(Type type, Object value, T defaultValue) throws ConvertException {
        return this.convert(type, value, defaultValue, true);
    }

    public <T> T convert(Type type, Object value, T defaultValue, boolean isCustomFirst) throws ConvertException {
        Object result;
        Converter converter;
        if (ObjectKit.isNull(value)) {
            return defaultValue;
        }
        if (TypeKit.isUnknown(type)) {
            if (null == defaultValue) {
                return (T)value;
            }
            type = defaultValue.getClass();
        }
        if (value instanceof Converter) {
            return ((Converter)value).convert(type, value, defaultValue);
        }
        if (type instanceof Types) {
            type = ((Types)type).getType();
        }
        if (null != (converter = this.getConverter(type, isCustomFirst))) {
            return converter.convert(type, value, defaultValue);
        }
        Class<?> rowType = TypeKit.getClass(type);
        if (null == rowType) {
            if (null != defaultValue) {
                rowType = defaultValue.getClass();
            } else {
                throw new ConvertException("Can not get class from type: {}", type);
            }
        }
        if (null != (result = this.convertSpecial(type, rowType, value, defaultValue))) {
            return (T)result;
        }
        if (BeanKit.isBean(rowType)) {
            return (T)BeanConverter.INSTANCE.convert(type, value);
        }
        throw new ConvertException("Can not convert from {}: [{}] to [{}]", value.getClass().getName(), value, type.getTypeName());
    }

    private <T> T convertSpecial(Type type, Class<T> rowType, Object value, T defaultValue) {
        if (null == rowType) {
            return null;
        }
        if (Collection.class.isAssignableFrom(rowType)) {
            return (T)CollectionConverter.INSTANCE.convert(type, value, (Collection)defaultValue);
        }
        if (Map.class.isAssignableFrom(rowType)) {
            return (T)MapConverter.INSTANCE.convert(type, value, (Map)defaultValue);
        }
        if (rowType.isInstance(value)) {
            return (T)value;
        }
        if (rowType.isPrimitive()) {
            return PrimitiveConverter.INSTANCE.convert(type, value, defaultValue);
        }
        if (Number.class.isAssignableFrom(rowType)) {
            return NumberConverter.INSTANCE.convert(type, value, defaultValue);
        }
        if (rowType.isEnum()) {
            return EnumConverter.INSTANCE.convert(type, value, defaultValue);
        }
        if (rowType.isArray()) {
            return ArrayConverter.INSTANCE.convert(type, value, defaultValue);
        }
        return null;
    }

    private static class SingletonHolder {
        private static final CompositeConverter INSTANCE = new CompositeConverter();

        private SingletonHolder() {
        }
    }
}

