/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.convert;

import java.util.function.Function;
import org.aoju.bus.core.convert.AbstractConverter;
import org.aoju.bus.core.convert.Convert;
import org.aoju.bus.core.convert.NumberConverter;
import org.aoju.bus.core.exception.ConvertException;
import org.aoju.bus.core.toolkit.ObjectKit;
import org.aoju.bus.core.toolkit.StringKit;

public class PrimitiveConverter
extends AbstractConverter {
    private static final long serialVersionUID = 1L;
    public static final PrimitiveConverter INSTANCE = new PrimitiveConverter();

    protected static Object convert(Object value, Class<?> primitiveClass, Function<Object, String> func) {
        if (Byte.TYPE == primitiveClass) {
            return ObjectKit.defaultIfNull(NumberConverter.convert(value, Byte.class, func), 0);
        }
        if (Short.TYPE == primitiveClass) {
            return ObjectKit.defaultIfNull(NumberConverter.convert(value, Short.class, func), 0);
        }
        if (Integer.TYPE == primitiveClass) {
            return ObjectKit.defaultIfNull(NumberConverter.convert(value, Integer.class, func), 0);
        }
        if (Long.TYPE == primitiveClass) {
            return ObjectKit.defaultIfNull(NumberConverter.convert(value, Long.class, func), 0);
        }
        if (Float.TYPE == primitiveClass) {
            return ObjectKit.defaultIfNull(NumberConverter.convert(value, Float.class, func), 0);
        }
        if (Double.TYPE == primitiveClass) {
            return ObjectKit.defaultIfNull(NumberConverter.convert(value, Double.class, func), 0);
        }
        if (Character.TYPE == primitiveClass) {
            return Convert.convert(Character.class, value);
        }
        if (Boolean.TYPE == primitiveClass) {
            return Convert.convert(Boolean.class, value);
        }
        throw new ConvertException("Unsupported target type: {}", primitiveClass);
    }

    @Override
    protected Object convertInternal(Class<?> targetClass, Object value) {
        return PrimitiveConverter.convert(value, targetClass, this::convertToString);
    }

    @Override
    protected String convertToString(Object value) {
        return StringKit.trim(super.convertToString(value));
    }
}

