/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.lang;

import java.util.Collection;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.aoju.bus.core.lang.function.XSupplier;
import org.aoju.bus.core.toolkit.CollKit;
import org.aoju.bus.core.toolkit.StringKit;

public class Optional<T> {
    private static final Optional<?> EMPTY = new Optional<Object>(null);
    private final T value;
    private Exception exception;

    public Optional(T value) {
        this.value = value;
    }

    public static <T> Optional<T> empty() {
        Optional<?> t = EMPTY;
        return t;
    }

    public static <T> Optional<T> of(java.util.Optional<T> optional) {
        return Optional.ofNullable(optional.orElse(null));
    }

    public static <T> Optional<T> of(T value) {
        return new Optional<T>(Objects.requireNonNull(value));
    }

    public static <T> Optional<T> ofNullable(T value) {
        return value == null ? Optional.empty() : new Optional<T>(value);
    }

    public static <T extends CharSequence> Optional<T> ofBlankAble(T value) {
        return StringKit.isBlank(value) ? Optional.empty() : new Optional<T>(value);
    }

    public static <T, R extends Collection<T>> Optional<R> ofEmptyAble(R value) {
        return CollKit.isEmpty(value) || CollKit.getFirst(value) == null ? Optional.empty() : new Optional<R>(value);
    }

    public static <T> Optional<T> ofTry(XSupplier<T> supplier) {
        try {
            return Optional.ofNullable(supplier.getting());
        }
        catch (Exception e) {
            Optional<Object> empty = new Optional<Object>(null);
            empty.exception = e;
            return empty;
        }
    }

    public T get() {
        return this.value;
    }

    public boolean isEmpty() {
        return this.value == null;
    }

    public Exception getException() {
        return this.exception;
    }

    public boolean isFail() {
        return null != this.exception;
    }

    public boolean isPresent() {
        return this.value != null;
    }

    public Optional<T> ifPresent(Consumer<? super T> action) {
        if (this.isPresent()) {
            action.accept(this.value);
        }
        return this;
    }

    public Optional<T> filter(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate);
        if (this.isEmpty()) {
            return this;
        }
        return predicate.test(this.value) ? this : Optional.empty();
    }

    public <U> Optional<U> map(Function<? super T, ? extends U> mapper) {
        Objects.requireNonNull(mapper);
        if (this.isEmpty()) {
            return Optional.empty();
        }
        return Optional.ofNullable(mapper.apply(this.value));
    }

    public <U> Optional<U> flatMap(Function<? super T, ? extends Optional<? extends U>> mapper) {
        Objects.requireNonNull(mapper);
        if (this.isEmpty()) {
            return Optional.empty();
        }
        Optional<? extends U> r = mapper.apply(this.value);
        return Objects.requireNonNull(r);
    }

    public <U> Optional<U> flattedMap(Function<? super T, ? extends java.util.Optional<? extends U>> mapper) {
        Objects.requireNonNull(mapper);
        if (this.isEmpty()) {
            return Optional.empty();
        }
        return Optional.ofNullable(mapper.apply(this.value).orElse(null));
    }

    public Optional<T> peek(Consumer<T> action) throws NullPointerException {
        return this.ifPresent(action);
    }

    @SafeVarargs
    public final Optional<T> peeks(Consumer<T> ... actions) throws NullPointerException {
        return this.peek(Stream.of(actions).reduce(Consumer::andThen).orElseGet(() -> o -> {}));
    }

    public Optional<T> or(Supplier<? extends Optional<? extends T>> supplier) {
        Objects.requireNonNull(supplier);
        if (this.isPresent()) {
            return this;
        }
        Optional<? extends T> r = supplier.get();
        return Objects.requireNonNull(r);
    }

    public Stream<T> stream() {
        if (this.isEmpty()) {
            return Stream.empty();
        }
        return Stream.of(this.value);
    }

    public T orElse(T other) {
        return this.isPresent() ? this.value : other;
    }

    public T exceptionOrElse(T other) {
        return this.isFail() ? other : this.value;
    }

    public T orElseGet(Supplier<? extends T> supplier) {
        return this.isPresent() ? this.value : supplier.get();
    }

    public T orElseRun(Runnable action) {
        if (this.isPresent()) {
            return this.value;
        }
        action.run();
        return null;
    }

    public T orElseThrow() {
        return this.orElseThrow(() -> new NoSuchElementException("No value present"));
    }

    public <X extends Throwable> T orElseThrow(Supplier<? extends X> exceptionSupplier) throws X {
        if (this.isPresent()) {
            return this.value;
        }
        throw (Throwable)exceptionSupplier.get();
    }

    public java.util.Optional<T> toOptional() {
        return java.util.Optional.ofNullable(this.value);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Optional)) {
            return false;
        }
        Optional other = (Optional)object;
        return Objects.equals(this.value, other.value);
    }

    public int hashCode() {
        return Objects.hashCode(this.value);
    }

    public String toString() {
        return StringKit.toStringOrNull(this.value);
    }
}

