/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.lang.range;

import org.aoju.bus.core.lang.range.Bound;
import org.aoju.bus.core.lang.range.BoundType;
import org.aoju.bus.core.lang.range.BoundedRange;

class NoneUpperBound<T extends Comparable<? super T>>
implements Bound<T> {
    static final NoneUpperBound INSTANCE = new NoneUpperBound();

    NoneUpperBound() {
    }

    @Override
    public T getValue() {
        return null;
    }

    @Override
    public BoundType getType() {
        return BoundType.OPEN_UPPER_BOUND;
    }

    @Override
    public boolean test(T t) {
        return true;
    }

    @Override
    public int compareTo(Bound<T> bound) {
        return bound instanceof NoneUpperBound ? 0 : 1;
    }

    @Override
    public String descBound() {
        return "+\u221e" + this.getType().getSymbol();
    }

    @Override
    public String toString() {
        return "{x | x < +\u221e}";
    }

    @Override
    public Bound<T> negate() {
        return this;
    }

    @Override
    public BoundedRange<T> toRange() {
        return BoundedRange.all();
    }
}

