/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.text;

import java.io.IOException;
import java.io.Serializable;
import java.util.Iterator;
import java.util.function.Function;
import org.aoju.bus.core.collection.ArrayIterator;
import org.aoju.bus.core.exception.InternalException;
import org.aoju.bus.core.toolkit.ArrayKit;
import org.aoju.bus.core.toolkit.IterKit;
import org.aoju.bus.core.toolkit.ObjectKit;
import org.aoju.bus.core.toolkit.StringKit;

public class TextJoiner
implements Appendable,
Serializable {
    private static final long serialVersionUID = 1L;
    private Appendable appendable;
    private CharSequence delimiter;
    private CharSequence prefix;
    private CharSequence suffix;
    private boolean wrapElement;
    private NullMode nullMode = NullMode.NULL_STRING;
    private String emptyResult = "";
    private boolean hasContent;

    public TextJoiner(CharSequence delimiter) {
        this(null, delimiter);
    }

    public TextJoiner(Appendable appendable, CharSequence delimiter) {
        this(appendable, delimiter, null, null);
    }

    public TextJoiner(CharSequence delimiter, CharSequence prefix, CharSequence suffix) {
        this(null, delimiter, prefix, suffix);
    }

    public TextJoiner(Appendable appendable, CharSequence delimiter, CharSequence prefix, CharSequence suffix) {
        if (null != appendable) {
            this.appendable = appendable;
            this.checkHasContent(appendable);
        }
        this.delimiter = delimiter;
        this.prefix = prefix;
        this.suffix = suffix;
    }

    public static TextJoiner of(TextJoiner joiner) {
        TextJoiner joinerNew = new TextJoiner(joiner.delimiter, joiner.prefix, joiner.suffix);
        joinerNew.wrapElement = joiner.wrapElement;
        joinerNew.nullMode = joiner.nullMode;
        joinerNew.emptyResult = joiner.emptyResult;
        return joinerNew;
    }

    public static TextJoiner of(CharSequence delimiter) {
        return new TextJoiner(delimiter);
    }

    public static TextJoiner of(CharSequence delimiter, CharSequence prefix, CharSequence suffix) {
        return new TextJoiner(delimiter, prefix, suffix);
    }

    public TextJoiner setDelimiter(CharSequence delimiter) {
        this.delimiter = delimiter;
        return this;
    }

    public TextJoiner setPrefix(CharSequence prefix) {
        this.prefix = prefix;
        return this;
    }

    public TextJoiner setSuffix(CharSequence suffix) {
        this.suffix = suffix;
        return this;
    }

    public TextJoiner setWrapElement(boolean wrapElement) {
        this.wrapElement = wrapElement;
        return this;
    }

    public TextJoiner setNullMode(NullMode nullMode) {
        this.nullMode = nullMode;
        return this;
    }

    public TextJoiner setEmptyResult(String text) {
        this.emptyResult = text;
        return this;
    }

    public TextJoiner append(Object object) {
        if (null == object) {
            this.append((CharSequence)null);
        } else if (ArrayKit.isArray(object)) {
            this.append(new ArrayIterator(object));
        } else if (object instanceof Iterator) {
            this.append((Iterator)object);
        } else if (object instanceof Iterable) {
            this.append(((Iterable)object).iterator());
        } else {
            this.append(ObjectKit.toString(object));
        }
        return this;
    }

    public <T> TextJoiner append(T[] array) {
        if (null == array) {
            return this;
        }
        return this.append(new ArrayIterator<T>(array));
    }

    public <T> TextJoiner append(Iterator<T> iterator) {
        if (null != iterator) {
            while (iterator.hasNext()) {
                this.append(iterator.next());
            }
        }
        return this;
    }

    public <T> TextJoiner append(T[] array, Function<T, ? extends CharSequence> func) {
        return this.append(new ArrayIterator<T>(array), (Function<? super E, ? extends CharSequence>)func);
    }

    public <E> TextJoiner append(Iterable<E> iterable, Function<? super E, ? extends CharSequence> func) {
        return this.append(IterKit.get(iterable), func);
    }

    public <E> TextJoiner append(Iterator<E> iterator, Function<? super E, ? extends CharSequence> func) {
        if (null != iterator) {
            while (iterator.hasNext()) {
                this.append(func.apply(iterator.next()));
            }
        }
        return this;
    }

    @Override
    public TextJoiner append(CharSequence text) {
        return this.append(text, 0, StringKit.length(text));
    }

    @Override
    public TextJoiner append(CharSequence text, int startInclude, int endExclude) {
        if (null == text) {
            switch (this.nullMode) {
                case IGNORE: {
                    return this;
                }
                case TO_EMPTY: {
                    text = "";
                    break;
                }
                case NULL_STRING: {
                    text = "null";
                }
            }
        }
        try {
            Appendable appendable = this.prepare();
            if (this.wrapElement && StringKit.isNotEmpty(this.prefix)) {
                appendable.append(this.prefix);
            }
            appendable.append(text, startInclude, endExclude);
            if (this.wrapElement && StringKit.isNotEmpty(this.suffix)) {
                appendable.append(this.suffix);
            }
        }
        catch (IOException e) {
            throw new InternalException(e);
        }
        return this;
    }

    @Override
    public TextJoiner append(char c) {
        return this.append(String.valueOf(c));
    }

    public String toString() {
        if (null == this.appendable) {
            return this.emptyResult;
        }
        Object result = this.appendable.toString();
        if (!this.wrapElement && StringKit.isNotEmpty(this.suffix)) {
            result = (String)result + this.suffix;
        }
        return result;
    }

    public TextJoiner merge(TextJoiner joiner) {
        if (null != joiner && null != joiner.appendable) {
            String val = joiner.toString();
            if (joiner.wrapElement) {
                this.append(val);
            } else {
                this.append(val, this.prefix.length(), val.length());
            }
        }
        return this;
    }

    public int length() {
        return this.appendable != null ? this.appendable.toString().length() + this.suffix.length() : (null == this.emptyResult ? -1 : this.emptyResult.length());
    }

    private Appendable prepare() throws IOException {
        if (this.hasContent) {
            this.appendable.append(this.delimiter);
        } else {
            if (null == this.appendable) {
                this.appendable = new StringBuilder();
            }
            if (!this.wrapElement && StringKit.isNotEmpty(this.prefix)) {
                this.appendable.append(this.prefix);
            }
            this.hasContent = true;
        }
        return this.appendable;
    }

    private void checkHasContent(Appendable appendable) {
        if (appendable instanceof CharSequence) {
            CharSequence charSequence = (CharSequence)((Object)appendable);
            if (charSequence.length() > 0 && StringKit.endWith(charSequence, this.delimiter)) {
                this.hasContent = true;
            }
        } else {
            String initStr = appendable.toString();
            if (StringKit.isNotEmpty(initStr) && !StringKit.endWith((CharSequence)initStr, this.delimiter)) {
                this.hasContent = true;
            }
        }
    }

    public static enum NullMode {
        IGNORE,
        TO_EMPTY,
        NULL_STRING;

    }
}

