/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.thread;

import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.function.Consumer;

public class BlockPolicy
implements RejectedExecutionHandler {
    private final Consumer<Runnable> handler;

    public BlockPolicy(Consumer<Runnable> handler) {
        this.handler = handler;
    }

    public BlockPolicy() {
        this(null);
    }

    @Override
    public void rejectedExecution(Runnable r, ThreadPoolExecutor e) {
        if (!e.isShutdown()) {
            try {
                e.getQueue().put(r);
            }
            catch (InterruptedException ex) {
                throw new RejectedExecutionException("Task " + r + " rejected from " + e);
            }
        } else if (null != this.handler) {
            this.handler.accept(r);
        }
    }
}

