/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.toolkit;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.aoju.bus.core.convert.Convert;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.lang.Charset;
import org.aoju.bus.core.lang.RegEx;
import org.aoju.bus.core.lang.function.XFunction;
import org.aoju.bus.core.text.ASCIICache;
import org.aoju.bus.core.text.NamingCase;
import org.aoju.bus.core.text.TextFormatter;
import org.aoju.bus.core.text.TextSplitter;
import org.aoju.bus.core.text.finder.CharFinder;
import org.aoju.bus.core.text.finder.StringFinder;
import org.aoju.bus.core.toolkit.ArrayKit;
import org.aoju.bus.core.toolkit.MathKit;
import org.aoju.bus.core.toolkit.ObjectKit;
import org.aoju.bus.core.toolkit.PatternKit;

public class CharsKit {
    public static boolean isAscii(char args) {
        return args < '\u0080';
    }

    public static boolean isAsciiPrintable(char args) {
        return args >= ' ' && args < '\u007f';
    }

    public static boolean isAsciiControl(char args) {
        return args < ' ' || args == '\u007f';
    }

    public static boolean isLetter(char args) {
        return CharsKit.isLetterUpper(args) || CharsKit.isLetterLower(args);
    }

    public static boolean isLetterUpper(char args) {
        return args >= 'A' && args <= 'Z';
    }

    public static boolean isLetterLower(char args) {
        return args >= 'a' && args <= 'z';
    }

    public static boolean isNumber(char args) {
        return args >= '0' && args <= '9';
    }

    public static boolean isHexChar(char args) {
        return CharsKit.isNumber(args) || args >= 'a' && args <= 'f' || args >= 'A' && args <= 'F';
    }

    public static boolean isLetterOrNumber(char args) {
        return CharsKit.isLetter(args) || CharsKit.isNumber(args);
    }

    public static boolean isCharClass(Class<?> clazz) {
        return clazz == Character.class || clazz == Character.TYPE;
    }

    public static boolean isChar(Object args) {
        return args instanceof Character || args.getClass() == Character.TYPE;
    }

    public static boolean isBlankChar(char args) {
        return CharsKit.isBlankChar((int)args);
    }

    public static boolean isBlankChar(int args) {
        return Character.isWhitespace(args) || Character.isSpaceChar(args) || args == 65279 || args == 8234 || args == 0 || args == 12644 || args == 10240;
    }

    public static boolean isBlank(CharSequence text) {
        int length;
        if (text == null || (length = text.length()) == 0) {
            return true;
        }
        for (int i = 0; i < length; ++i) {
            if (CharsKit.isBlankChar(text.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotBlank(CharSequence text) {
        return false == CharsKit.isBlank(text);
    }

    public static boolean isNoneBlank(CharSequence ... args) {
        return !CharsKit.isAnyBlank(args);
    }

    public static boolean isAnyBlank(CharSequence ... args) {
        if (ArrayKit.isEmpty(args)) {
            return false;
        }
        for (CharSequence text : args) {
            if (!CharsKit.isBlank(text)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAllBlank(CharSequence ... args) {
        if (ArrayKit.isEmpty(args)) {
            return true;
        }
        for (CharSequence text : args) {
            if (!CharsKit.isNotBlank(text)) continue;
            return false;
        }
        return true;
    }

    public static boolean isEmpty(CharSequence text) {
        return text == null || text.length() == 0 || text.isEmpty();
    }

    public static boolean isNotEmpty(CharSequence text) {
        return false == CharsKit.isEmpty(text);
    }

    public static boolean isAllEmpty(CharSequence ... args) {
        if (ArrayKit.isEmpty(args)) {
            return true;
        }
        for (CharSequence text : args) {
            if (!CharsKit.isNotEmpty(text)) continue;
            return false;
        }
        return true;
    }

    public static boolean isAllNotEmpty(CharSequence ... text) {
        return false == CharsKit.hasEmpty(text);
    }

    public static boolean isAllNotBlank(CharSequence ... text) {
        return false == CharsKit.hasBlank(text);
    }

    public static boolean isNullOrUndefined(CharSequence text) {
        if (null == text) {
            return true;
        }
        return CharsKit.isNullOrUndefinedString(text);
    }

    public static boolean isEmptyOrUndefined(CharSequence text) {
        if (CharsKit.isEmpty(text)) {
            return true;
        }
        return CharsKit.isNullOrUndefinedString(text);
    }

    public static boolean isBlankOrUndefined(CharSequence text) {
        if (CharsKit.isBlank(text)) {
            return true;
        }
        return CharsKit.isNullOrUndefinedString(text);
    }

    private static boolean isNullOrUndefinedString(CharSequence text) {
        String strString = text.toString().trim();
        return "null".equals(strString) || "undefined".equals(strString);
    }

    private static boolean isNotNullAndNotUndefinedString(CharSequence text) {
        String strString = text.toString().trim();
        return !"null".equals(strString) && !"undefined".equals(strString);
    }

    public static boolean hasBlank(CharSequence ... args) {
        if (ArrayKit.isEmpty(args)) {
            return true;
        }
        for (CharSequence text : args) {
            if (!CharsKit.isBlank(text)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAllCharMatch(CharSequence value, org.aoju.bus.core.lang.Matcher<Character> matcher) {
        if (CharsKit.isBlank(value)) {
            return false;
        }
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            if (matcher.match(Character.valueOf(value.charAt(i)))) continue;
            return false;
        }
        return true;
    }

    public static String emptyIfNull(CharSequence text) {
        return ((CharSequence)ObjectKit.defaultIfNull(text, "")).toString();
    }

    public static String emptyToNull(CharSequence text) {
        return CharsKit.isEmpty(text) ? null : text.toString();
    }

    public static boolean hasEmpty(CharSequence ... args) {
        if (ArrayKit.isEmpty(args)) {
            return true;
        }
        for (CharSequence text : args) {
            if (!CharsKit.isEmpty(text)) continue;
            return true;
        }
        return false;
    }

    public static boolean isEmoji(char c) {
        return false == (c == '\u0000' || c == '\t' || c == '\n' || c == '\r' || c >= ' ' && c <= '\ud7ff' || c >= '\ue000' && c <= '\ufffd' || c >= '\u10000' && c <= '\u10ffff');
    }

    public static boolean equals(char c1, char c2, boolean ignoreCase) {
        if (ignoreCase) {
            return Character.toLowerCase(c1) == Character.toLowerCase(c2);
        }
        return c1 == c2;
    }

    public static int count(CharSequence content, CharSequence strForSearch) {
        if (CharsKit.hasEmpty(content, strForSearch) || strForSearch.length() > content.length()) {
            return 0;
        }
        int count = 0;
        int idx = 0;
        String content2 = content.toString();
        String strForSearch2 = strForSearch.toString();
        while ((idx = content2.indexOf(strForSearch2, idx)) > -1) {
            ++count;
            idx += strForSearch.length();
        }
        return count;
    }

    public static int count(CharSequence content, char charForSearch) {
        int count = 0;
        if (CharsKit.isEmpty(content)) {
            return 0;
        }
        int contentLength = content.length();
        for (int i = 0; i < contentLength; ++i) {
            if (charForSearch != content.charAt(i)) continue;
            ++count;
        }
        return count;
    }

    public static boolean isFileSeparator(char c) {
        return '/' == c || '\\' == c;
    }

    public static int compare(char x, char y) {
        return x - y;
    }

    public static char[] getChars(byte[] bytes) {
        ByteBuffer bb = ByteBuffer.allocate(bytes.length);
        bb.put(bytes).flip();
        CharBuffer cb = Charset.UTF_8.decode(bb);
        return cb.array();
    }

    public static char byteToChar(byte[] b) {
        int hi = (b[0] & 0xFF) << 8;
        int lo = b[1] & 0xFF;
        return (char)(hi | lo);
    }

    public static char toCloseChar(char c) {
        int result = c;
        if (c >= 49 && c <= 57) {
            result = 9312 + c - 49;
        } else if (c >= 65 && c <= 90) {
            result = 9398 + c - 65;
        } else if (c >= 97 && c <= 122) {
            result = 9424 + c - 97;
        }
        return (char)result;
    }

    public static char toCloseByNumber(int number) {
        if (number > 20) {
            throw new IllegalArgumentException("Number must be [1-20]");
        }
        return (char)(9312 + number - 1);
    }

    public static boolean startWithNumber(CharSequence text) {
        return CharsKit.isNotBlank(text) && RegEx.NUMBERS.matcher(text.subSequence(0, 1)).find();
    }

    public static boolean startWithGeneral(CharSequence text) {
        return CharsKit.isNotBlank(text) && RegEx.GENERAL.matcher(text.subSequence(0, 1)).find();
    }

    public static boolean startWithWord(CharSequence text) {
        return CharsKit.isNotBlank(text) && RegEx.WORD.matcher(text.subSequence(0, 1)).find();
    }

    public static boolean startWithChinese(CharSequence text) {
        return CharsKit.isNotBlank(text) && RegEx.CHINESES.matcher(text.subSequence(0, 1)).find();
    }

    public static boolean isCharEquals(CharSequence text) {
        Assert.notEmpty(text, "text to check must be not empty!", new Object[0]);
        return CharsKit.count(text, text.charAt(0)) == text.length();
    }

    public static String normalize(CharSequence text) {
        return Normalizer.normalize(text, Normalizer.Form.NFC);
    }

    public static String fixLength(CharSequence text, char fixedChar, int length) {
        int fixedLength = length - text.length();
        if (fixedLength <= 0) {
            return text.toString();
        }
        return text + CharsKit.repeat(fixedChar, fixedLength);
    }

    public static String trim(CharSequence text) {
        return null == text ? null : CharsKit.trim(text, 0);
    }

    public static String trim(CharSequence text, int mode) {
        int start;
        if (null == text) {
            return null;
        }
        int length = text.length();
        int end = length;
        if (mode <= 0) {
            for (start = 0; start < end && CharsKit.isBlankChar(text.charAt(start)); ++start) {
            }
        }
        if (mode >= 0) {
            while (start < end && CharsKit.isBlankChar(text.charAt(end - 1))) {
                --end;
            }
        }
        if (start > 0 || end < length) {
            return text.toString().substring(start, end);
        }
        return text.toString();
    }

    public static String trim(CharSequence text, int mode, Predicate<Character> predicate) {
        String result;
        if (text == null) {
            result = null;
        } else {
            int start;
            int length = text.length();
            int end = length;
            if (mode <= 0) {
                for (start = 0; start < end && predicate.test(Character.valueOf(text.charAt(start))); ++start) {
                }
            }
            if (mode >= 0) {
                while (start < end && predicate.test(Character.valueOf(text.charAt(end - 1)))) {
                    --end;
                }
            }
            result = start > 0 || end < length ? text.toString().substring(start, end) : text.toString();
        }
        return result;
    }

    public static String trimToNull(CharSequence text) {
        String trimStr = CharsKit.trim(text);
        return "".equals(trimStr) ? null : trimStr;
    }

    public static String removePreAndLowerFirst(CharSequence text, int preLength) {
        if (null == text) {
            return null;
        }
        if (text.length() > preLength) {
            char first = Character.toLowerCase(text.charAt(preLength));
            if (text.length() > preLength + 1) {
                return first + text.toString().substring(preLength + 1);
            }
            return String.valueOf(first);
        }
        return text.toString();
    }

    public static String removePreAndLowerFirst(CharSequence text, CharSequence prefix) {
        return CharsKit.lowerFirst(CharsKit.removePrefix(text, prefix));
    }

    public static String removePrefix(CharSequence text, CharSequence prefix) {
        if (CharsKit.isEmpty(text) || CharsKit.isEmpty(prefix)) {
            return CharsKit.toString(text);
        }
        String str2 = text.toString();
        if (str2.startsWith(prefix.toString())) {
            return CharsKit.subSuf(str2, prefix.length());
        }
        return str2;
    }

    public static String removePrefixIgnoreCase(CharSequence text, CharSequence prefix) {
        if (CharsKit.isEmpty(text) || CharsKit.isEmpty(prefix)) {
            return CharsKit.toString(text);
        }
        String str2 = text.toString();
        if (CharsKit.startWithIgnoreCase(text, prefix)) {
            return CharsKit.subSuf(str2, prefix.length());
        }
        return str2;
    }

    public static String removeSuffix(CharSequence text, CharSequence suffix) {
        if (CharsKit.isEmpty(text) || CharsKit.isEmpty(suffix)) {
            return CharsKit.toString(text);
        }
        String str2 = text.toString();
        if (str2.endsWith(suffix.toString())) {
            return CharsKit.subPre(str2, str2.length() - suffix.length());
        }
        return str2;
    }

    public static String removeSufAndLowerFirst(CharSequence text, CharSequence suffix) {
        return CharsKit.lowerFirst(CharsKit.removeSuffix(text, suffix));
    }

    public static String removeSuffixIgnoreCase(CharSequence text, CharSequence suffix) {
        if (CharsKit.isEmpty(text) || CharsKit.isEmpty(suffix)) {
            return CharsKit.toString(text);
        }
        String str2 = text.toString();
        if (CharsKit.endWithIgnoreCase(text, suffix)) {
            return CharsKit.subPre(str2, str2.length() - suffix.length());
        }
        return str2;
    }

    public static String upperFirstAndAddPre(CharSequence text, String preString) {
        if (null == text || null == preString) {
            return null;
        }
        return preString + CharsKit.upperFirst(text);
    }

    public static String upperFirst(CharSequence text) {
        char firstChar;
        if (null == text) {
            return null;
        }
        if (text.length() > 0 && Character.isLowerCase(firstChar = text.charAt(0))) {
            return Character.toUpperCase(firstChar) + CharsKit.subSuf(text, 1);
        }
        return text.toString();
    }

    public static String lowerFirst(CharSequence text) {
        char firstChar;
        if (null == text) {
            return null;
        }
        if (text.length() > 0 && Character.isUpperCase(firstChar = text.charAt(0))) {
            return Character.toLowerCase(firstChar) + CharsKit.subSuf(text, 1);
        }
        return text.toString();
    }

    public static String toUnderlineCase(CharSequence word) {
        return NamingCase.toUnderlineCase(word);
    }

    public static String toSymbolCase(CharSequence text, char symbol) {
        return NamingCase.toSymbolCase(text, symbol);
    }

    public static String toCamelCase(CharSequence text) {
        return NamingCase.toCamelCase(text);
    }

    public static String toCamelCase(CharSequence name, char symbol) {
        return NamingCase.toCamelCase(name, symbol);
    }

    public static String removeAll(CharSequence text, CharSequence word) {
        if (CharsKit.isEmpty(text) || CharsKit.isEmpty(word)) {
            return CharsKit.toString(text);
        }
        return text.toString().replace(word, "");
    }

    public static String removeAll(CharSequence text, char ... chars) {
        if (null == text || ArrayKit.isEmpty(chars)) {
            return CharsKit.toString(text);
        }
        int len = text.length();
        if (0 == len) {
            return CharsKit.toString(text);
        }
        StringBuilder builder = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char c = text.charAt(i);
            if (ArrayKit.contains(chars, c)) continue;
            builder.append(c);
        }
        return builder.toString();
    }

    public static String removeAny(CharSequence text, CharSequence ... word) {
        String result = CharsKit.toString(text);
        if (CharsKit.isNotEmpty(text)) {
            for (CharSequence x : word) {
                result = CharsKit.removeAll((CharSequence)result, x);
            }
        }
        return result;
    }

    public static String format(CharSequence template, Map<?, ?> args) {
        return CharsKit.format(template, args, true);
    }

    public static String format(CharSequence template, Object ... args) {
        if (null == template) {
            return "null";
        }
        if (ArrayKit.isEmpty(args) || CharsKit.isBlank(template)) {
            return template.toString();
        }
        return TextFormatter.format(template.toString(), args);
    }

    public static String format(CharSequence template, Map<?, ?> map, boolean ignoreNull) {
        return TextFormatter.format(template, map, ignoreNull);
    }

    public static boolean hasLetter(Object obj) {
        if (null == obj) {
            return false;
        }
        if (obj instanceof String) {
            char[] chars;
            for (char c : chars = ((String)obj).toCharArray()) {
                if (!CharsKit.isLetter(c)) continue;
                return true;
            }
        }
        return false;
    }

    public static String sub(CharSequence text, int fromIndex, int toIndex) {
        if (CharsKit.isEmpty(text)) {
            return CharsKit.toString(text);
        }
        int len = text.length();
        if (fromIndex < 0) {
            if ((fromIndex = len + fromIndex) < 0) {
                fromIndex = 0;
            }
        } else if (fromIndex > len) {
            fromIndex = len;
        }
        if (toIndex < 0) {
            if ((toIndex = len + toIndex) < 0) {
                toIndex = len;
            }
        } else if (toIndex > len) {
            toIndex = len;
        }
        if (toIndex < fromIndex) {
            int tmp = fromIndex;
            fromIndex = toIndex;
            toIndex = tmp;
        }
        if (fromIndex == toIndex) {
            return "";
        }
        return text.toString().substring(fromIndex, toIndex);
    }

    public static String subPre(CharSequence string, int toIndex) {
        return CharsKit.sub(string, 0, toIndex);
    }

    public static String subPreGbk(CharSequence text, int len, CharSequence suffix) {
        return CharsKit.subPreGbk(text, len, true) + suffix;
    }

    public static String subPreGbk(CharSequence text, int len, boolean word) {
        if (CharsKit.isEmpty(text)) {
            return CharsKit.toString(text);
        }
        int counterOfDoubleByte = 0;
        byte[] b = CharsKit.bytes(text, Charset.GBK);
        if (b.length <= len) {
            return text.toString();
        }
        for (int i = 0; i < len; ++i) {
            if (b[i] >= 0) continue;
            ++counterOfDoubleByte;
        }
        if (counterOfDoubleByte % 2 != 0) {
            len = word ? ++len : --len;
        }
        return new String(b, 0, len, Charset.GBK);
    }

    public static String subSuf(CharSequence string, int fromIndex) {
        if (CharsKit.isEmpty(string)) {
            return null;
        }
        return CharsKit.sub(string, fromIndex, string.length());
    }

    public static String subBefore(CharSequence string, CharSequence separator, boolean isLastSeparator) {
        int pos;
        if (CharsKit.isEmpty(string) || null == separator) {
            return null == string ? null : "";
        }
        String text = string.toString();
        String sep = separator.toString();
        if (sep.isEmpty()) {
            return "";
        }
        int n = pos = isLastSeparator ? text.lastIndexOf(sep) : text.indexOf(sep);
        if (-1 == pos) {
            return text;
        }
        if (0 == pos) {
            return "";
        }
        return text.substring(0, pos);
    }

    public static String subBefore(CharSequence string, char separator, boolean isLastSeparator) {
        int pos;
        if (CharsKit.isEmpty(string)) {
            return null == string ? null : "";
        }
        String text = string.toString();
        int n = pos = isLastSeparator ? text.lastIndexOf(separator) : text.indexOf(separator);
        if (-1 == pos) {
            return text;
        }
        if (0 == pos) {
            return "";
        }
        return text.substring(0, pos);
    }

    public static String subAfter(CharSequence string, CharSequence separator, boolean isLastSeparator) {
        int pos;
        if (CharsKit.isEmpty(string)) {
            return null == string ? null : "";
        }
        if (null == separator) {
            return "";
        }
        String text = string.toString();
        String sep = separator.toString();
        int n = pos = isLastSeparator ? text.lastIndexOf(sep) : text.indexOf(sep);
        if (-1 == pos || string.length() - 1 == pos) {
            return "";
        }
        return text.substring(pos + separator.length());
    }

    public static String subAfter(CharSequence string, char separator, boolean isLastSeparator) {
        int pos;
        if (CharsKit.isEmpty(string)) {
            return null == string ? null : "";
        }
        String text = string.toString();
        int n = pos = isLastSeparator ? text.lastIndexOf(separator) : text.indexOf(separator);
        if (-1 == pos) {
            return "";
        }
        return text.substring(pos + 1);
    }

    public static String subBetween(CharSequence text, CharSequence before, CharSequence after) {
        return CharsKit.subBetween(text.toString(), before.toString(), after.toString());
    }

    public static String subBetween(String text, String before, String after) {
        int end;
        if (null == text || null == before || null == after) {
            return null;
        }
        int start = text.indexOf(before);
        if (start != -1 && (end = text.indexOf(after, start + before.length())) != -1) {
            return text.substring(start + before.length(), end);
        }
        return null;
    }

    public static String subBetween(CharSequence text, CharSequence beforeAndAfter) {
        return CharsKit.subBetween(text, beforeAndAfter, beforeAndAfter);
    }

    public static String[] subBetweenAll(CharSequence text, CharSequence prefix, CharSequence suffix) {
        if (CharsKit.hasEmpty(text, prefix, suffix) || !CharsKit.contains(text, prefix)) {
            return new String[0];
        }
        LinkedList<String> result = new LinkedList<String>();
        String[] split = CharsKit.splitToArray(text, prefix);
        if (prefix.equals(suffix)) {
            int length = split.length - 1;
            for (int i = 1; i < length; i += 2) {
                result.add(split[i]);
            }
        } else {
            for (int i = 1; i < split.length; ++i) {
                String fragment = split[i];
                int suffixIndex = fragment.indexOf(suffix.toString());
                if (suffixIndex <= 0) continue;
                result.add(fragment.substring(0, suffixIndex));
            }
        }
        return result.toArray(new String[0]);
    }

    public static String[] subBetweenAll(CharSequence text, CharSequence prefixAndSuffix) {
        return CharsKit.subBetweenAll(text, prefixAndSuffix, prefixAndSuffix);
    }

    public static String subByLength(CharSequence text, int length) {
        if (CharsKit.isEmpty(text)) {
            return null;
        }
        if (length <= 0) {
            return "";
        }
        return CharsKit.sub(text, -length, text.length());
    }

    public static boolean equals(CharSequence x, CharSequence y) {
        return CharsKit.equals(x, y, false);
    }

    public static boolean equals(CharSequence x, CharSequence y, boolean ignoreCase) {
        if (null == x) {
            return null == y;
        }
        if (null == y) {
            return false;
        }
        if (ignoreCase) {
            return x.toString().equalsIgnoreCase(y.toString());
        }
        return x.equals(y);
    }

    public static boolean equalsIgnoreCase(CharSequence x, CharSequence y) {
        return CharsKit.equals(x, y, true);
    }

    public static boolean equalsAnyIgnoreCase(CharSequence x, CharSequence ... y) {
        return CharsKit.equalsAny(x, true, y);
    }

    public static boolean equalsAny(CharSequence text, CharSequence ... args) {
        return CharsKit.equalsAny(text, false, args);
    }

    public static boolean equalsAny(CharSequence text, boolean ignoreCase, CharSequence ... args) {
        if (ArrayKit.isEmpty(text)) {
            return false;
        }
        for (CharSequence t : args) {
            if (!CharsKit.equals(text, t, ignoreCase)) continue;
            return true;
        }
        return false;
    }

    public static int indexOf(CharSequence text, char word) {
        return CharsKit.indexOf(text, word, 0);
    }

    public static int indexOf(CharSequence text, char word, int start) {
        if (text instanceof String) {
            return ((String)text).indexOf(word, start);
        }
        return CharsKit.indexOf(text, word, start, -1);
    }

    public static int indexOf(CharSequence text, char word, int start, int end) {
        if (CharsKit.isEmpty(text)) {
            return -1;
        }
        return new CharFinder(word).setText(text).setEndIndex(end).start(start);
    }

    public static int indexOfIgnoreCase(CharSequence text, CharSequence word) {
        return CharsKit.indexOfIgnoreCase(text, word, 0);
    }

    public static int indexOfIgnoreCase(CharSequence text, CharSequence word, int from) {
        return CharsKit.indexOf(text, word, from, true);
    }

    public static int indexOf(CharSequence text, CharSequence word, int from, boolean ignoreCase) {
        if (CharsKit.isEmpty(text) || CharsKit.isEmpty(word)) {
            if (CharsKit.equals(text, word)) {
                return 0;
            }
            return -1;
        }
        return new StringFinder(word, ignoreCase).setText(text).start(from);
    }

    public static int lastIndexOfIgnoreCase(CharSequence text, CharSequence word) {
        return CharsKit.lastIndexOfIgnoreCase(text, word, text.length());
    }

    public static int lastIndexOfIgnoreCase(CharSequence text, CharSequence word, int from) {
        return CharsKit.lastIndexOf(text, word, from, true);
    }

    public static int lastIndexOf(CharSequence text, CharSequence word, int from, boolean ignoreCase) {
        if (CharsKit.isEmpty(text) || CharsKit.isEmpty(word)) {
            if (CharsKit.equals(text, word)) {
                return 0;
            }
            return -1;
        }
        return new StringFinder(word, ignoreCase).setText(text).setNegative(true).start(from);
    }

    public static long[] splitToLong(CharSequence text, char separator) {
        return Convert.convert(long[].class, CharsKit.splitTrim(text, separator));
    }

    public static long[] splitToLong(CharSequence text, CharSequence separator) {
        return Convert.convert(long[].class, CharsKit.splitTrim(text, separator));
    }

    public static int[] splitToInt(CharSequence text, char separator) {
        return Convert.convert(int[].class, CharsKit.splitTrim(text, separator));
    }

    public static int[] splitToInt(CharSequence text, CharSequence separator) {
        return Convert.convert(int[].class, CharsKit.splitTrim(text, separator));
    }

    public static String[] splitToArray(CharSequence text, CharSequence separator) {
        if (text == null) {
            return new String[0];
        }
        return TextSplitter.splitToArray((CharSequence)text.toString(), CharsKit.toString(separator), 0, false, false);
    }

    public static String[] splitToArray(CharSequence text, char separator) {
        return CharsKit.splitToArray(text, separator, 0);
    }

    public static String[] splitToArray(CharSequence text, char separator, int limit) {
        Assert.notNull(text, "Text must be not null!", new Object[0]);
        return TextSplitter.splitToArray((CharSequence)text.toString(), separator, limit, false, false);
    }

    public static List<String> split(CharSequence text, char separator) {
        return CharsKit.split(text, separator, 0);
    }

    public static List<String> splitTrim(CharSequence text, char separator) {
        return CharsKit.splitTrim(text, separator, -1);
    }

    public static List<String> splitTrim(CharSequence text, CharSequence separator) {
        return CharsKit.splitTrim(text, separator, -1);
    }

    public static List<String> splitTrim(CharSequence text, char separator, int limit) {
        return CharsKit.split(text, separator, limit, true, true);
    }

    public static List<String> splitTrim(CharSequence text, CharSequence separator, int limit) {
        return CharsKit.split(text, separator, limit, true, true);
    }

    public static String[] split(CharSequence text, int len) {
        if (null == text) {
            return new String[0];
        }
        return TextSplitter.splitByLength(text.toString(), len);
    }

    public static List<String> split(CharSequence text, CharSequence separator) {
        return CharsKit.split(text, separator, false, false);
    }

    public static List<String> split(CharSequence text, char separator, int limit) {
        return CharsKit.split(text, separator, limit, false, false);
    }

    public static List<String> split(CharSequence text, char separator, boolean isTrim, boolean ignoreEmpty) {
        return CharsKit.split(text, separator, 0, isTrim, ignoreEmpty);
    }

    public static List<String> split(CharSequence text, CharSequence separator, boolean isTrim, boolean ignoreEmpty) {
        return CharsKit.split(text, separator, 0, isTrim, ignoreEmpty);
    }

    public static List<String> split(CharSequence text, char separator, int limit, boolean isTrim, boolean ignoreEmpty) {
        return TextSplitter.split(text, separator, limit, isTrim, ignoreEmpty);
    }

    public static List<String> split(CharSequence text, CharSequence separator, int limit, boolean isTrim, boolean ignoreEmpty) {
        if (null == text) {
            return new ArrayList<String>(0);
        }
        String separatorStr = null == separator ? null : separator.toString();
        return TextSplitter.split((CharSequence)text.toString(), separatorStr, limit, isTrim, ignoreEmpty);
    }

    public static <R> List<R> split(CharSequence text, char separator, int limit, boolean ignoreEmpty, Function<String, R> mapping) {
        return TextSplitter.split((CharSequence)text.toString(), separator, limit, ignoreEmpty, mapping);
    }

    public static String subCodePoint(CharSequence text, int fromIndex, int toIndex) {
        if (CharsKit.isEmpty(text)) {
            return CharsKit.toString(text);
        }
        if (fromIndex < 0 || fromIndex > toIndex) {
            throw new IllegalArgumentException();
        }
        if (fromIndex == toIndex) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int subLen = toIndex - fromIndex;
        text.toString().codePoints().skip(fromIndex).limit(subLen).forEach(v -> sb.append(Character.toChars(v)));
        return sb.toString();
    }

    public static String nullToEmpty(CharSequence text) {
        return CharsKit.nullToDefault(text, "");
    }

    public static String nullToDefault(CharSequence text, String defaultStr) {
        return null == text ? defaultStr : text.toString();
    }

    public static String emptyToDefault(CharSequence text, String defaultStr) {
        return CharsKit.isEmpty(text) ? defaultStr : text.toString();
    }

    public static String blankToDefault(CharSequence text, String defaultStr) {
        return CharsKit.isBlank(text) ? defaultStr : text.toString();
    }

    public static boolean isSubEquals(CharSequence str1, int start1, CharSequence str2, boolean ignoreCase) {
        return CharsKit.isSubEquals(str1, start1, str2, 0, str2.length(), ignoreCase);
    }

    public static boolean isSubEquals(CharSequence str1, int start1, CharSequence str2, int start2, int length, boolean ignoreCase) {
        if (null == str1 || null == str2) {
            return false;
        }
        return str1.toString().regionMatches(ignoreCase, start1, str2.toString(), start2, length);
    }

    public static String repeat(char c, int count) {
        if (count <= 0) {
            return "";
        }
        char[] result = new char[count];
        for (int i = 0; i < count; ++i) {
            result[i] = c;
        }
        return new String(result);
    }

    public static String repeat(CharSequence text, int count) {
        int n;
        if (null == text) {
            return null;
        }
        if (count <= 0 || text.length() == 0) {
            return "";
        }
        if (count == 1) {
            return text.toString();
        }
        int len = text.length();
        long longSize = (long)len * (long)count;
        int size = (int)longSize;
        if ((long)size != longSize) {
            throw new ArrayIndexOutOfBoundsException("Required String length is too large: " + longSize);
        }
        char[] array = new char[size];
        text.toString().getChars(0, len, array, 0);
        for (n = len; n < size - n; n <<= 1) {
            System.arraycopy(array, 0, array, n, n);
        }
        System.arraycopy(array, 0, array, n, size - n);
        return new String(array);
    }

    public static String repeatByLength(CharSequence text, int padLen) {
        if (null == text) {
            return null;
        }
        if (padLen <= 0) {
            return "";
        }
        int strLen = text.length();
        if (strLen == padLen) {
            return text.toString();
        }
        if (strLen > padLen) {
            return CharsKit.subPre(text, padLen);
        }
        char[] padding = new char[padLen];
        for (int i = 0; i < padLen; ++i) {
            padding[i] = text.charAt(i % strLen);
        }
        return new String(padding);
    }

    public static String repeatAndJoin(CharSequence text, int count, CharSequence delimiter) {
        if (count <= 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder(text.length() * count);
        builder.append(text);
        boolean isAppendDelimiter = CharsKit.isNotEmpty(delimiter);
        while (true) {
            int n = --count;
            --count;
            if (n <= 0) break;
            if (isAppendDelimiter) {
                builder.append(delimiter);
            }
            builder.append(text);
        }
        return builder.toString();
    }

    public static String reverse(String text) {
        char[] chars = text.toCharArray();
        ArrayKit.reverse(chars);
        return new String(chars);
    }

    public static byte[] bytes(CharSequence text) {
        return CharsKit.bytes(text, java.nio.charset.Charset.defaultCharset());
    }

    public static byte[] bytes(CharSequence text, String charset) {
        return CharsKit.bytes(text, CharsKit.isBlank(charset) ? java.nio.charset.Charset.defaultCharset() : java.nio.charset.Charset.forName(charset));
    }

    public static byte[] bytes(CharSequence text, java.nio.charset.Charset charset) {
        if (null == text) {
            return null;
        }
        if (null == charset) {
            return text.toString().getBytes();
        }
        return text.toString().getBytes(charset);
    }

    public static String replaceIgnoreCase(CharSequence text, CharSequence word, CharSequence replacement) {
        return CharsKit.replace(text, 0, word, replacement, true);
    }

    public static String replace(CharSequence text) {
        String val = "";
        if (null != text) {
            Pattern p = Pattern.compile("\\s*|\t|\r|\n");
            Matcher m = p.matcher(text);
            val = m.replaceAll("");
        }
        return val;
    }

    public static String replace(CharSequence text, CharSequence word, CharSequence replacement) {
        return CharsKit.replace(text, 0, word, replacement, false);
    }

    public static String replace(CharSequence text, CharSequence word, CharSequence replacement, boolean ignoreCase) {
        return CharsKit.replace(text, 0, word, replacement, ignoreCase);
    }

    public static String replace(CharSequence text, int fromIndex, CharSequence word, CharSequence replacement, boolean ignoreCase) {
        int index;
        int wordLength;
        int textLength;
        if (CharsKit.isEmpty(text) || CharsKit.isEmpty(word)) {
            return CharsKit.toString(text);
        }
        if (null == replacement) {
            replacement = "";
        }
        if ((textLength = text.length()) < (wordLength = word.length())) {
            return CharsKit.toString(text);
        }
        if (fromIndex > textLength) {
            return CharsKit.toString(text);
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        StringBuilder result = new StringBuilder(textLength - wordLength + replacement.length());
        if (0 != fromIndex) {
            result.append(text.subSequence(0, fromIndex));
        }
        int preIndex = fromIndex;
        while ((index = CharsKit.indexOf(text, word, preIndex, ignoreCase)) > -1) {
            result.append(text.subSequence(preIndex, index));
            result.append(replacement);
            preIndex = index + wordLength;
        }
        if (preIndex < textLength) {
            result.append(text.subSequence(preIndex, textLength));
        }
        return result.toString();
    }

    public static String replace(CharSequence text, String regex, XFunction<Matcher, String> replaceFun) {
        return PatternKit.replaceAll(text, regex, replaceFun);
    }

    public static String replace(CharSequence text, int startInclude, int endExclude, CharSequence replacedChar) {
        int i;
        if (CharsKit.isEmpty(text)) {
            return CharsKit.toString(text);
        }
        String originalStr = CharsKit.toString(text);
        int[] strCodePoints = originalStr.codePoints().toArray();
        int strLength = strCodePoints.length;
        if (startInclude > strLength) {
            return originalStr;
        }
        if (endExclude > strLength) {
            endExclude = strLength;
        }
        if (startInclude > endExclude) {
            return originalStr;
        }
        StringBuilder stringBuilder = new StringBuilder(originalStr.length() - (endExclude - startInclude) + replacedChar.length());
        for (i = 0; i < startInclude; ++i) {
            stringBuilder.appendCodePoint(strCodePoints[i]);
        }
        stringBuilder.append(replacedChar);
        for (i = endExclude; i < strLength; ++i) {
            stringBuilder.appendCodePoint(strCodePoints[i]);
        }
        return stringBuilder.toString();
    }

    public static String replace(CharSequence text, Pattern pattern, XFunction<Matcher, String> replaceFun) {
        return PatternKit.replaceAll(text, pattern, replaceFun);
    }

    public static String replace(CharSequence text, int startInclude, int endExclude, char replacedChar) {
        if (CharsKit.isEmpty(text)) {
            return CharsKit.toString(text);
        }
        String original = CharsKit.toString(text);
        int[] strCodePoints = original.codePoints().toArray();
        int strLength = strCodePoints.length;
        if (startInclude > strLength) {
            return original;
        }
        if (endExclude > strLength) {
            endExclude = strLength;
        }
        if (startInclude > endExclude) {
            return original;
        }
        StringBuilder stringBuilder = new StringBuilder(original.length());
        for (int i = 0; i < strLength; ++i) {
            if (i >= startInclude && i < endExclude) {
                stringBuilder.append(replacedChar);
                continue;
            }
            stringBuilder.appendCodePoint(strCodePoints[i]);
        }
        return stringBuilder.toString();
    }

    public static String replaceLast(CharSequence text, CharSequence searchStr, CharSequence replacedChar) {
        return CharsKit.replaceLast(text, searchStr, replacedChar, false);
    }

    public static String replaceLast(CharSequence text, CharSequence searchStr, CharSequence replacedChar, boolean ignoreCase) {
        if (CharsKit.isEmpty(text)) {
            return CharsKit.toString(text);
        }
        int lastIndex = CharsKit.lastIndexOf(text, searchStr, text.length(), ignoreCase);
        if (-1 == lastIndex) {
            return CharsKit.toString(text);
        }
        return CharsKit.replace(text, lastIndex, searchStr, replacedChar, ignoreCase);
    }

    public static String replaceFirst(CharSequence str, CharSequence searchStr, CharSequence replacedStr) {
        return CharsKit.replaceFirst(str, searchStr, replacedStr, false);
    }

    public static String replaceFirst(CharSequence str, CharSequence searchStr, CharSequence replacedStr, boolean ignoreCase) {
        if (CharsKit.isEmpty(str)) {
            return CharsKit.toString(str);
        }
        int startInclude = CharsKit.indexOf(str, searchStr, 0, ignoreCase);
        if (-1 == startInclude) {
            return CharsKit.toString(str);
        }
        return CharsKit.replace(str, startInclude, startInclude + searchStr.length(), replacedStr);
    }

    public static String hide(CharSequence text, int startInclude, int endExclude) {
        return CharsKit.replace(text, startInclude, endExclude, '*');
    }

    public static String replaceChars(CharSequence text, String chars, CharSequence replacedStr) {
        if (CharsKit.isEmpty(text) || CharsKit.isEmpty(chars)) {
            return CharsKit.toString(text);
        }
        return CharsKit.replaceChars(text, chars.toCharArray(), replacedStr);
    }

    public static String replaceChars(CharSequence text, char[] chars, CharSequence replacedStr) {
        if (CharsKit.isEmpty(text) || ArrayKit.isEmpty(chars)) {
            return CharsKit.toString(text);
        }
        HashSet<Character> set = new HashSet<Character>(chars.length);
        for (char c : chars) {
            set.add(Character.valueOf(c));
        }
        int strLen = text.length();
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < strLen; ++i) {
            char c = text.charAt(i);
            builder.append(set.contains(Character.valueOf(c)) ? replacedStr : Character.valueOf(c));
        }
        return builder.toString();
    }

    public static String cleanBlank(CharSequence text) {
        return CharsKit.filter(text, c -> !CharsKit.isBlankChar(c.charValue()));
    }

    public static String wrap(CharSequence text, CharSequence prefixAndSuffix) {
        return CharsKit.wrap(text, prefixAndSuffix, prefixAndSuffix);
    }

    public static String wrap(CharSequence text, CharSequence prefix, CharSequence suffix) {
        return CharsKit.nullToEmpty(prefix).concat(CharsKit.nullToEmpty(text)).concat(CharsKit.nullToEmpty(suffix));
    }

    public static String[] wrapAll(CharSequence prefixAndSuffix, CharSequence ... args) {
        return CharsKit.wrapAll(prefixAndSuffix, prefixAndSuffix, args);
    }

    public static String[] wrapAll(CharSequence prefix, CharSequence suffix, CharSequence ... args) {
        String[] results = new String[args.length];
        for (int i = 0; i < args.length; ++i) {
            results[i] = CharsKit.wrap(args[i], prefix, suffix);
        }
        return results;
    }

    public static String unWrap(CharSequence text, String prefix, String suffix) {
        if (CharsKit.isWrap(text, prefix, suffix)) {
            return CharsKit.sub(text, prefix.length(), text.length() - suffix.length());
        }
        return text.toString();
    }

    public static String unWrap(CharSequence text, char prefix, char suffix) {
        if (CharsKit.isEmpty(text)) {
            return CharsKit.toString(text);
        }
        if (text.charAt(0) == prefix && text.charAt(text.length() - 1) == suffix) {
            return CharsKit.sub(text, 1, text.length() - 1);
        }
        return text.toString();
    }

    public static String unWrap(CharSequence text, char prefixAndSuffix) {
        return CharsKit.unWrap(text, prefixAndSuffix, prefixAndSuffix);
    }

    public static boolean isWrap(CharSequence text, String prefix, String suffix) {
        if (ArrayKit.hasNull(text, prefix, suffix)) {
            return false;
        }
        String str2 = text.toString();
        return str2.startsWith(prefix) && str2.endsWith(suffix);
    }

    public static boolean isWrap(CharSequence text, String wrapper) {
        return CharsKit.isWrap(text, wrapper, wrapper);
    }

    public static boolean isWrap(CharSequence text, char wrapper) {
        return CharsKit.isWrap(text, wrapper, wrapper);
    }

    public static boolean isWrap(CharSequence text, char prefixChar, char suffixChar) {
        if (null == text) {
            return false;
        }
        return text.charAt(0) == prefixChar && text.charAt(text.length() - 1) == suffixChar;
    }

    public static String wrapIfMissing(CharSequence text, CharSequence prefix, CharSequence suffix) {
        int len = 0;
        if (CharsKit.isNotEmpty(text)) {
            len += text.length();
        }
        if (CharsKit.isNotEmpty(prefix)) {
            len += prefix.length();
        }
        if (CharsKit.isNotEmpty(suffix)) {
            len += suffix.length();
        }
        StringBuilder stringBuilder = new StringBuilder(len);
        if (CharsKit.isNotEmpty(prefix) && !CharsKit.startWith(text, prefix)) {
            stringBuilder.append(prefix);
        }
        if (CharsKit.isNotEmpty(text)) {
            stringBuilder.append(text);
        }
        if (CharsKit.isNotEmpty(suffix) && !CharsKit.endWith(text, suffix)) {
            stringBuilder.append(suffix);
        }
        return stringBuilder.toString();
    }

    public static String[] wrapAllIfMissing(CharSequence prefixAndSuffix, CharSequence ... args) {
        return CharsKit.wrapAllIfMissing(prefixAndSuffix, prefixAndSuffix, args);
    }

    public static String[] wrapAllIfMissing(CharSequence prefix, CharSequence suffix, CharSequence ... args) {
        String[] results = new String[args.length];
        for (int i = 0; i < args.length; ++i) {
            results[i] = CharsKit.wrapIfMissing(args[i], prefix, suffix);
        }
        return results;
    }

    public static boolean startWith(CharSequence text, char word) {
        if (CharsKit.isEmpty(text)) {
            return false;
        }
        return word == text.charAt(0);
    }

    public static boolean startWith(CharSequence text, CharSequence prefix, boolean ignoreCase) {
        return CharsKit.startWith(text, prefix, ignoreCase, false);
    }

    public static boolean startWith(CharSequence text, CharSequence prefix, boolean ignoreCase, boolean ignoreEquals) {
        if (null == text || null == prefix) {
            if (ignoreEquals) {
                return false;
            }
            return null == text && null == prefix;
        }
        boolean isStartWith = text.toString().regionMatches(ignoreCase, 0, prefix.toString(), 0, prefix.length());
        if (isStartWith) {
            return false == ignoreEquals || false == CharsKit.equals(text, prefix, ignoreCase);
        }
        return false;
    }

    public static boolean startWith(CharSequence text, CharSequence prefix) {
        return CharsKit.startWith(text, prefix, false);
    }

    public static boolean startWithIgnoreEquals(CharSequence text, CharSequence prefix) {
        return CharsKit.startWith(text, prefix, false, true);
    }

    public static boolean startWithAny(CharSequence text, CharSequence ... args) {
        if (CharsKit.isEmpty(text) || ArrayKit.isEmpty(args)) {
            return false;
        }
        for (CharSequence suffix : args) {
            if (!CharsKit.startWith(text, suffix, false)) continue;
            return true;
        }
        return false;
    }

    public static boolean startWithAnyIgnoreCase(CharSequence text, CharSequence ... args) {
        if (CharsKit.isEmpty(text) || ArrayKit.isEmpty(args)) {
            return false;
        }
        for (CharSequence suffix : args) {
            if (!CharsKit.startWith(text, suffix, true)) continue;
            return true;
        }
        return false;
    }

    public static boolean startWithIgnoreCase(CharSequence text, CharSequence prefix) {
        return CharsKit.startWith(text, prefix, true);
    }

    public static boolean endWith(CharSequence text, char c) {
        if (CharsKit.isEmpty(text)) {
            return false;
        }
        return c == text.charAt(text.length() - 1);
    }

    public static boolean endWith(CharSequence text, CharSequence suffix, boolean ignoreCase) {
        return CharsKit.endWith(text, suffix, ignoreCase, false);
    }

    public static boolean endWith(CharSequence text, CharSequence suffix, boolean ignoreCase, boolean ignoreEquals) {
        if (null == text || null == suffix) {
            if (ignoreEquals) {
                return false;
            }
            return null == text && null == suffix;
        }
        int strOffset = text.length() - suffix.length();
        boolean isEndWith = text.toString().regionMatches(ignoreCase, strOffset, suffix.toString(), 0, suffix.length());
        if (isEndWith) {
            return false == ignoreEquals || false == CharsKit.equals(text, suffix, ignoreCase);
        }
        return false;
    }

    public static boolean endWith(CharSequence text, CharSequence suffix) {
        return CharsKit.endWith(text, suffix, false);
    }

    public static boolean endWithAny(CharSequence text, CharSequence ... args) {
        if (CharsKit.isEmpty(text) || ArrayKit.isEmpty(args)) {
            return false;
        }
        for (CharSequence suffix : args) {
            if (!CharsKit.endWith(text, suffix, false)) continue;
            return true;
        }
        return false;
    }

    public static boolean endWithAnyIgnoreCase(CharSequence text, CharSequence ... args) {
        if (CharsKit.isEmpty(text) || ArrayKit.isEmpty(args)) {
            return false;
        }
        for (CharSequence suffix : args) {
            if (!CharsKit.endWith(text, suffix, true)) continue;
            return true;
        }
        return false;
    }

    public static boolean endWithIgnoreCase(CharSequence text, CharSequence suffix) {
        return CharsKit.endWith(text, suffix, true);
    }

    public static String strip(CharSequence text, CharSequence prefixOrSuffix) {
        return CharsKit.strip(text, prefixOrSuffix, prefixOrSuffix);
    }

    public static String strip(CharSequence text, CharSequence prefix, CharSequence suffix) {
        if (CharsKit.isEmpty(text)) {
            return CharsKit.toString(text);
        }
        int from = 0;
        int to = text.length();
        String value = text.toString();
        if (CharsKit.startWith((CharSequence)value, prefix)) {
            from = prefix.length();
        }
        if (CharsKit.endWith((CharSequence)value, suffix)) {
            to -= suffix.length();
        }
        return value.substring(from, to);
    }

    public static String stripIgnoreCase(CharSequence text, CharSequence prefixOrSuffix) {
        return CharsKit.stripIgnoreCase(text, prefixOrSuffix, prefixOrSuffix);
    }

    public static String stripIgnoreCase(CharSequence text, CharSequence prefix, CharSequence suffix) {
        if (CharsKit.isEmpty(text)) {
            return CharsKit.toString(text);
        }
        int from = 0;
        int to = text.length();
        String value = text.toString();
        if (CharsKit.startWithIgnoreCase(value, prefix)) {
            from = prefix.length();
        }
        if (CharsKit.endWithIgnoreCase(value, suffix)) {
            to -= suffix.length();
        }
        return value.substring(from, to);
    }

    public static String addPrefixIfNot(CharSequence text, CharSequence prefix) {
        String xSuffix;
        if (CharsKit.isEmpty(text) || CharsKit.isEmpty(prefix)) {
            return CharsKit.toString(text);
        }
        String value = text.toString();
        if (!value.startsWith(xSuffix = prefix.toString())) {
            return xSuffix.concat(value);
        }
        return value;
    }

    public static String addSuffixIfNot(CharSequence text, CharSequence suffix) {
        String xSuffix;
        if (CharsKit.isEmpty(text) || CharsKit.isEmpty(suffix)) {
            return CharsKit.toString(text);
        }
        String value = text.toString();
        if (!value.endsWith(xSuffix = suffix.toString())) {
            return value.concat(xSuffix);
        }
        return value;
    }

    public static boolean contains(CharSequence text, char word) {
        return CharsKit.indexOf(text, word) > -1;
    }

    public static boolean contains(CharSequence text, CharSequence word) {
        if (null == text || null == word) {
            return false;
        }
        return text.toString().contains(word);
    }

    public static boolean containsAny(CharSequence text, CharSequence ... testStrs) {
        return null != CharsKit.getContainsAny(text, testStrs);
    }

    public static boolean containsAny(CharSequence text, char ... testChars) {
        if (!CharsKit.isEmpty(text)) {
            int len = text.length();
            for (int i = 0; i < len; ++i) {
                if (!ArrayKit.contains(testChars, text.charAt(i))) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsOnly(CharSequence text, char ... testChars) {
        if (!CharsKit.isEmpty(text)) {
            int len = text.length();
            for (int i = 0; i < len; ++i) {
                if (ArrayKit.contains(testChars, text.charAt(i))) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean containsAll(CharSequence text, CharSequence ... args) {
        if (CharsKit.isBlank(text) || ArrayKit.isEmpty(args)) {
            return false;
        }
        for (CharSequence value : args) {
            if (CharsKit.contains(text, value)) continue;
            return false;
        }
        return true;
    }

    public static boolean containsBlank(CharSequence text) {
        if (null == text) {
            return false;
        }
        int length = text.length();
        if (0 == length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (!CharsKit.isBlankChar(text.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static String getContainsAny(CharSequence text, CharSequence ... args) {
        if (CharsKit.isEmpty(text) || ArrayKit.isEmpty(args)) {
            return null;
        }
        for (CharSequence val : args) {
            if (!val.toString().contains(text)) continue;
            return val.toString();
        }
        return null;
    }

    public static boolean containsIgnoreCase(CharSequence text, CharSequence word) {
        if (null == text) {
            return null == word;
        }
        return CharsKit.indexOfIgnoreCase(text, word) > -1;
    }

    public static boolean containsAnyIgnoreCase(CharSequence text, CharSequence ... args) {
        return null != CharsKit.getContainsStrIgnoreCase(text, args);
    }

    public static String getContainsStrIgnoreCase(CharSequence text, CharSequence ... args) {
        if (CharsKit.isEmpty(text) || ArrayKit.isEmpty(args)) {
            return null;
        }
        for (CharSequence value : args) {
            if (!CharsKit.containsIgnoreCase(text, value)) continue;
            return value.toString();
        }
        return null;
    }

    public static boolean isSurround(CharSequence text, CharSequence prefix, CharSequence suffix) {
        if (CharsKit.isBlank(text)) {
            return false;
        }
        if (text.length() < prefix.length() + suffix.length()) {
            return false;
        }
        String str2 = text.toString();
        return str2.startsWith(prefix.toString()) && str2.endsWith(suffix.toString());
    }

    public static boolean isSurround(CharSequence text, char prefix, char suffix) {
        if (CharsKit.isBlank(text)) {
            return false;
        }
        if (text.length() < 2) {
            return false;
        }
        return text.charAt(0) == prefix && text.charAt(text.length() - 1) == suffix;
    }

    public static boolean isUpperCase(CharSequence text) {
        if (null == text) {
            return false;
        }
        int len = text.length();
        for (int i = 0; i < len; ++i) {
            if (!Character.isLowerCase(text.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isLowerCase(CharSequence text) {
        if (null == text) {
            return false;
        }
        int len = text.length();
        for (int i = 0; i < len; ++i) {
            if (!Character.isUpperCase(text.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static int byteLength(CharSequence cs, java.nio.charset.Charset charset) {
        return null == cs ? 0 : cs.toString().getBytes(charset).length;
    }

    public static String[] cut(CharSequence text, int partLength) {
        if (null == text) {
            return null;
        }
        int len = text.length();
        if (len < partLength) {
            return new String[]{text.toString()};
        }
        int part = MathKit.count(len, partLength);
        String[] array = new String[part];
        String str2 = text.toString();
        for (int i = 0; i < part; ++i) {
            array[i] = str2.substring(i * partLength, i == part - 1 ? len : partLength + i * partLength);
        }
        return array;
    }

    public static String brief(CharSequence text, int maxLength) {
        if (null == text) {
            return null;
        }
        int strLength = text.length();
        if (maxLength <= 0 || strLength <= maxLength) {
            return text.toString();
        }
        switch (maxLength) {
            case 1: {
                return String.valueOf(text.charAt(0));
            }
            case 2: {
                return text.charAt(0) + ".";
            }
            case 3: {
                return text.charAt(0) + "." + text.charAt(strLength - 1);
            }
            case 4: {
                return text.charAt(0) + ".." + text.charAt(strLength - 1);
            }
        }
        int suffixLength = (maxLength - 3) / 2;
        int preLength = suffixLength + (maxLength - 3) % 2;
        String str2 = text.toString();
        return CharsKit.format((CharSequence)"{}...{}", str2.substring(0, preLength), str2.substring(strLength - suffixLength));
    }

    private static String appendIfMissing(String text, CharSequence suffix, boolean ignoreCase, CharSequence ... args) {
        if (null == text || CharsKit.isEmpty(suffix) || CharsKit.endWith(text, suffix, ignoreCase)) {
            return CharsKit.toString(text);
        }
        if (null != args && args.length > 0) {
            for (CharSequence s : args) {
                if (!CharsKit.endWith(text, s, ignoreCase)) continue;
                return text;
            }
        }
        return text.concat(suffix.toString());
    }

    public static String appendIfMissing(String text, CharSequence suffix, CharSequence ... args) {
        return CharsKit.appendIfMissing(text, suffix, false, args);
    }

    public static String appendIfMissingIgnoreCase(String text, CharSequence suffix, CharSequence ... args) {
        return CharsKit.appendIfMissing(text, suffix, true, args);
    }

    private static String prependIfMissing(String text, CharSequence prefix, boolean ignoreCase, CharSequence ... args) {
        if (null == text || CharsKit.isEmpty(prefix) || CharsKit.startWith(text, prefix, ignoreCase)) {
            return CharsKit.toString(text);
        }
        if (null != args && args.length > 0) {
            for (CharSequence s : args) {
                if (!CharsKit.startWith(text, s, ignoreCase)) continue;
                return text;
            }
        }
        return prefix.toString().concat(text);
    }

    public static String prependIfMissing(String text, CharSequence prefix, CharSequence ... args) {
        return CharsKit.prependIfMissing(text, prefix, false, args);
    }

    public static String prependIfMissingIgnoreCase(String text, CharSequence prefix, CharSequence ... args) {
        return CharsKit.prependIfMissing(text, prefix, true, args);
    }

    public static String maxLength(CharSequence string, int length) {
        Assert.isTrue(length > 0);
        if (null == string) {
            return null;
        }
        if (string.length() <= length) {
            return string.toString();
        }
        return CharsKit.sub(string, 0, length) + "...";
    }

    public static String center(CharSequence text, int size) {
        return CharsKit.center(text, size, ' ');
    }

    public static String center(CharSequence text, int size, char padChar) {
        if (null == text || size <= 0) {
            return CharsKit.toString(text);
        }
        int strLen = text.length();
        int pads = size - strLen;
        if (pads <= 0) {
            return text.toString();
        }
        text = CharsKit.padPre(text, strLen + pads / 2, padChar);
        text = CharsKit.padAfter(text, size, padChar);
        return text.toString();
    }

    public static String center(CharSequence text, int size, CharSequence padText) {
        int strLen;
        int pads;
        if (null == text || size <= 0) {
            return CharsKit.toString(text);
        }
        if (CharsKit.isEmpty(padText)) {
            padText = " ";
        }
        if ((pads = size - (strLen = text.length())) <= 0) {
            return text.toString();
        }
        text = CharsKit.padPre(text, strLen + pads / 2, padText);
        text = CharsKit.padAfter(text, size, padText);
        return text.toString();
    }

    public static String padPre(CharSequence text, int minLength, CharSequence padText) {
        if (null == text) {
            return null;
        }
        int strLen = text.length();
        if (strLen == minLength) {
            return text.toString();
        }
        if (strLen > minLength) {
            return CharsKit.subPre(text, minLength);
        }
        return CharsKit.repeatByLength(padText, minLength - strLen).concat(text.toString());
    }

    public static String padPre(CharSequence text, int minLength, char padChar) {
        if (null == text) {
            return null;
        }
        int strLen = text.length();
        if (strLen == minLength) {
            return text.toString();
        }
        if (strLen > minLength) {
            return CharsKit.subPre(text, minLength);
        }
        return CharsKit.repeat(padChar, minLength - strLen).concat(text.toString());
    }

    public static String padAfter(CharSequence text, int minLength, char padChar) {
        if (null == text) {
            return null;
        }
        int strLen = text.length();
        if (strLen == minLength) {
            return text.toString();
        }
        if (strLen > minLength) {
            return CharsKit.sub(text, strLen - minLength, strLen);
        }
        return text.toString().concat(CharsKit.repeat(padChar, minLength - strLen));
    }

    public static String padAfter(CharSequence text, int minLength, CharSequence padText) {
        if (null == text) {
            return null;
        }
        int strLen = text.length();
        if (strLen == minLength) {
            return text.toString();
        }
        if (strLen > minLength) {
            return CharsKit.subByLength(text, minLength);
        }
        return text.toString().concat(CharsKit.repeatByLength(padText, minLength - strLen));
    }

    public static boolean equalsCharAt(CharSequence text, int position, char c) {
        if (null == text || position < 0) {
            return false;
        }
        return text.length() > position && c == text.charAt(position);
    }

    public static String filter(CharSequence text, Predicate<Character> filter) {
        if (null == text || null == filter) {
            return CharsKit.toString(text);
        }
        int len = text.length();
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char c = text.charAt(i);
            if (!filter.test(Character.valueOf(c))) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    public static StringBuilder builder(CharSequence ... args) {
        StringBuilder sb = new StringBuilder();
        for (CharSequence text : args) {
            sb.append(text);
        }
        return sb;
    }

    public static int length(CharSequence text) {
        return null == text ? 0 : text.length();
    }

    public static int ordinalIndexOf(CharSequence text, CharSequence word, int ordinal) {
        if (null == text || null == word || ordinal <= 0) {
            return -1;
        }
        if (word.length() == 0) {
            return 0;
        }
        int found = 0;
        int index = -1;
        do {
            if ((index = CharsKit.indexOf(text, word, index + 1, false)) >= 0) continue;
            return index;
        } while (++found < ordinal);
        return index;
    }

    public static String toString(CharSequence text) {
        return null == text ? null : text.toString();
    }

    public static String toString(char text) {
        return ASCIICache.toString(text);
    }

    public static boolean endsWithAny(CharSequence text, CharSequence ... args) {
        if (CharsKit.isEmpty(text) || ArrayKit.isEmpty(args)) {
            return false;
        }
        for (CharSequence val : args) {
            if (!CharsKit.endWith(text, val)) continue;
            return true;
        }
        return false;
    }

    public static <T extends CharSequence> T firstNonNull(T ... args) {
        return (T)((CharSequence)ArrayKit.firstNonNull(args));
    }

    public static <T extends CharSequence> T firstNonEmpty(T ... args) {
        return (T)ArrayKit.firstNonNull(CharsKit::isNotEmpty, args);
    }

    public static <T extends CharSequence> T firstNonBlank(T ... args) {
        return (T)ArrayKit.firstNonNull(CharsKit::isNotBlank, args);
    }
}

