/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.toolkit;

import java.io.Serializable;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.Objects;
import org.aoju.bus.core.exception.InternalException;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.lang.Optional;
import org.aoju.bus.core.map.WeakMap;
import org.aoju.bus.core.toolkit.BeanKit;
import org.aoju.bus.core.toolkit.ClassKit;
import org.aoju.bus.core.toolkit.ReflectKit;

public class LambdaKit {
    private static final WeakMap<String, Info> CACHE = new WeakMap();

    public static <R, T extends Serializable> Class<R> getRealClass(T func) {
        Info lambdaInfo = LambdaKit.resolve(func);
        return (Class)Optional.of(lambdaInfo).map(Info::getInstantiatedMethodParameterTypes).filter(types -> ((Type[])types).length != 0).map(types -> types[((Type[])types).length - 1]).orElseGet(lambdaInfo::getClazz);
    }

    public static <T extends Serializable> Info resolve(T func) {
        return CACHE.computeIfAbsent(func.getClass().getName(), key -> {
            Class<?> implClass;
            SerializedLambda serializedLambda = LambdaKit._resolve(func);
            String methodName = serializedLambda.getImplMethodName();
            ClassKit.loadClass(serializedLambda.getImplClass().replace("/", "."), true);
            try {
                implClass = Class.forName(serializedLambda.getImplClass().replace("/", "."), true, Thread.currentThread().getContextClassLoader());
            }
            catch (ClassNotFoundException e) {
                throw new InternalException(e);
            }
            if ("<init>".equals(methodName)) {
                for (Constructor<?> constructor : implClass.getDeclaredConstructors()) {
                    if (!ReflectKit.getDescriptor(constructor).equals(serializedLambda.getImplMethodSignature())) continue;
                    return new Info(constructor, serializedLambda);
                }
            } else {
                Method[] methods;
                for (Method method : methods = ReflectKit.getMethods(implClass)) {
                    if (!method.getName().equals(methodName) || !ReflectKit.getDescriptor(method).equals(serializedLambda.getImplMethodSignature())) continue;
                    return new Info(method, serializedLambda);
                }
            }
            throw new IllegalStateException("No lambda method found.");
        });
    }

    public static <T extends Serializable> String getMethodName(T func) {
        return LambdaKit.resolve(func).getName();
    }

    public static <T extends Serializable> String getFieldName(T func) throws IllegalArgumentException {
        return BeanKit.getFieldName(LambdaKit.getMethodName(func));
    }

    private static <T extends Serializable> SerializedLambda _resolve(T func) {
        if (func instanceof SerializedLambda) {
            return (SerializedLambda)func;
        }
        if (func instanceof Proxy) {
            throw new IllegalArgumentException("not support proxy, just for now");
        }
        Class<?> clazz = func.getClass();
        if (!clazz.isSynthetic()) {
            throw new IllegalArgumentException("Not a lambda expression: " + clazz.getName());
        }
        Object serLambda = ReflectKit.invoke(func, "writeReplace", new Object[0]);
        if (Objects.nonNull(serLambda) && serLambda instanceof SerializedLambda) {
            return (SerializedLambda)serLambda;
        }
        throw new InternalException("writeReplace result value is not java.lang.invoke.SerializedLambda");
    }

    public static class Info {
        private static final Type[] EMPTY_TYPE = new Type[0];
        private final Type[] instantiatedMethodParameterTypes;
        private final Type[] parameterTypes;
        private final Type returnType;
        private final String name;
        private final Executable executable;
        private final Class<?> clazz;
        private final SerializedLambda lambda;

        public Info(Executable executable, SerializedLambda lambda) {
            Assert.notNull(executable, "executable must be not null!", new Object[0]);
            boolean isMethod = executable instanceof Method;
            boolean isConstructor = executable instanceof Constructor;
            Assert.isTrue(isMethod || isConstructor, "Unsupported executable type: " + executable.getClass(), new Object[0]);
            this.returnType = isMethod ? ((Method)executable).getGenericReturnType() : ((Constructor)executable).getDeclaringClass();
            this.parameterTypes = executable.getGenericParameterTypes();
            this.name = executable.getName();
            this.clazz = executable.getDeclaringClass();
            this.executable = executable;
            this.lambda = lambda;
            String instantiatedMethodType = lambda.getInstantiatedMethodType();
            int index = instantiatedMethodType.indexOf(";)");
            this.instantiatedMethodParameterTypes = index > -1 ? Info.getInstantiatedMethodParamTypes(instantiatedMethodType.substring(1, index + 1)) : EMPTY_TYPE;
        }

        private static Type[] getInstantiatedMethodParamTypes(String className) {
            String[] instantiatedTypeNames = className.split(";");
            Type[] types = new Type[instantiatedTypeNames.length];
            for (int i = 0; i < instantiatedTypeNames.length; ++i) {
                boolean isArray = instantiatedTypeNames[i].startsWith("[");
                if (isArray && !instantiatedTypeNames[i].endsWith(";")) {
                    int n = i;
                    instantiatedTypeNames[n] = instantiatedTypeNames[n] + ";";
                } else {
                    if (instantiatedTypeNames[i].startsWith("L")) {
                        instantiatedTypeNames[i] = instantiatedTypeNames[i].substring(1);
                    }
                    if (instantiatedTypeNames[i].endsWith(";")) {
                        instantiatedTypeNames[i] = instantiatedTypeNames[i].substring(0, instantiatedTypeNames[i].length() - 1);
                    }
                }
                types[i] = ClassKit.loadClass(instantiatedTypeNames[i]);
            }
            return types;
        }

        public Type[] getInstantiatedMethodParameterTypes() {
            return this.instantiatedMethodParameterTypes;
        }

        public Type[] getParameterTypes() {
            return this.parameterTypes;
        }

        public Type getReturnType() {
            return this.returnType;
        }

        public String getName() {
            return this.name;
        }

        public String getFieldName() {
            return BeanKit.getFieldName(this.getName());
        }

        public Executable getExecutable() {
            return this.executable;
        }

        public Class<?> getClazz() {
            return this.clazz;
        }

        public SerializedLambda getLambda() {
            return this.lambda;
        }
    }
}

