/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.toolkit;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import org.aoju.bus.core.annotation.Alias;
import org.aoju.bus.core.beans.NullWrapper;
import org.aoju.bus.core.collection.UniqueKeySet;
import org.aoju.bus.core.convert.Convert;
import org.aoju.bus.core.exception.InternalException;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.lang.Normal;
import org.aoju.bus.core.map.WeakMap;
import org.aoju.bus.core.toolkit.ArrayKit;
import org.aoju.bus.core.toolkit.ClassKit;
import org.aoju.bus.core.toolkit.ObjectKit;
import org.aoju.bus.core.toolkit.StringKit;

public class ReflectKit {
    private static final WeakMap<Class<?>, Constructor<?>[]> CONSTRUCTORS_CACHE = new WeakMap();
    private static final WeakMap<Class<?>, Field[]> FIELDS_CACHE = new WeakMap();
    private static final WeakMap<Class<?>, Method[]> METHODS_CACHE = new WeakMap();

    public static Object invokeGetter(Object object, String name) {
        for (String method : StringKit.splitToArray((CharSequence)name, ".")) {
            String getterMethodName = "get" + StringKit.capitalize(method);
            object = ReflectKit.invokeMethod(object, getterMethodName, new Class[0], new Object[0]);
        }
        return object;
    }

    public static void invokeSetter(Object object, String name, Object value) {
        String[] names = StringKit.splitToArray((CharSequence)name, ".");
        for (int i = 0; i < names.length; ++i) {
            if (i < names.length - 1) {
                String getterMethodName = "get" + StringKit.capitalize(names[i]);
                object = ReflectKit.invokeMethod(object, getterMethodName, new Class[0], new Object[0]);
                continue;
            }
            String setterMethodName = "set" + StringKit.capitalize(names[i]);
            ReflectKit.invokeMethodByName(object, setterMethodName, new Object[]{value});
        }
    }

    public static Object convert(Object object, Class<?> type) {
        if (object instanceof Number) {
            Number number = (Number)object;
            if (type.equals(Byte.TYPE) || type.equals(Byte.class)) {
                return number.byteValue();
            }
            if (type.equals(Short.TYPE) || type.equals(Short.class)) {
                return number.shortValue();
            }
            if (type.equals(Integer.TYPE) || type.equals(Integer.class)) {
                return number.intValue();
            }
            if (type.equals(Long.TYPE) || type.equals(Long.class)) {
                return number.longValue();
            }
            if (type.equals(Float.TYPE) || type.equals(Float.class)) {
                return Float.valueOf(number.floatValue());
            }
            if (type.equals(Double.TYPE) || type.equals(Double.class)) {
                return number.doubleValue();
            }
        }
        if (type.equals(String.class)) {
            return null == object ? "" : object.toString();
        }
        return object;
    }

    public static Object invokeMethod(Method method, Object target) {
        return ReflectKit.invokeMethod(method, target, Normal.EMPTY_OBJECT_ARRAY);
    }

    public static Object invokeMethod(Method method, Object target, Object ... args) {
        try {
            return method.invoke(target, args);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Should never get here");
        }
    }

    public static Object invokeMethod(Object object, String name, Class<?>[] types, Object[] args) {
        Method method = ReflectKit.getAccessibleMethod(object, name, types);
        if (null == method) {
            throw new IllegalArgumentException("Could not find method [" + method + "] on target [" + object + "]");
        }
        try {
            return method.invoke(object, args);
        }
        catch (Exception e) {
            throw ReflectKit.convertReflectionExceptionToUnchecked(e);
        }
    }

    public static Object invokeMethodByName(Object object, String name, Object[] args) {
        Method method = ReflectKit.getAccessibleMethodByName(object, name);
        if (null == method) {
            throw new IllegalArgumentException("Could not find method [" + name + "] on target [" + object + "]");
        }
        try {
            return method.invoke(object, args);
        }
        catch (Exception e) {
            throw ReflectKit.convertReflectionExceptionToUnchecked(e);
        }
    }

    public static Field getAccessibleField(Object object, String name) {
        for (Class<?> superClass = object.getClass(); superClass != Object.class; superClass = superClass.getSuperclass()) {
            try {
                Field field = superClass.getDeclaredField(name);
                ReflectKit.makeAccessible(field);
                return field;
            }
            catch (NoSuchFieldException e) {
                continue;
            }
        }
        return null;
    }

    public static Method getAccessibleMethod(Object object, String name, Class<?> ... types) {
        for (Class<?> searchType = object.getClass(); searchType != Object.class; searchType = searchType.getSuperclass()) {
            try {
                Method method = searchType.getDeclaredMethod(name, types);
                ReflectKit.makeAccessible(method);
                return method;
            }
            catch (NoSuchMethodException e) {
                continue;
            }
        }
        return null;
    }

    public static Method getAccessibleMethodByName(Object object, String name) {
        for (Class<?> searchType = object.getClass(); searchType != Object.class; searchType = searchType.getSuperclass()) {
            Method[] methods;
            for (Method method : methods = searchType.getDeclaredMethods()) {
                if (!method.getName().equals(name)) continue;
                ReflectKit.makeAccessible(method);
                return method;
            }
        }
        return null;
    }

    public static void makeAccessible(Method method) {
        if (!(Modifier.isPublic(method.getModifiers()) && Modifier.isPublic(method.getDeclaringClass().getModifiers()) || method.isAccessible())) {
            method.setAccessible(true);
        }
    }

    public static void makeAccessible(Field field) {
        if (!(Modifier.isPublic(field.getModifiers()) && Modifier.isPublic(field.getDeclaringClass().getModifiers()) && !Modifier.isFinal(field.getModifiers()) || field.isAccessible())) {
            field.setAccessible(true);
        }
    }

    public static <T> Class<T> getClassGenricType(Class clazz) {
        return ReflectKit.getClassGenricType(clazz, 0);
    }

    public static Class getClassGenricType(Class clazz, int index) {
        Type genType = clazz.getGenericSuperclass();
        if (!(genType instanceof ParameterizedType)) {
            return Object.class;
        }
        Type[] params = ((ParameterizedType)genType).getActualTypeArguments();
        if (index >= params.length || index < 0) {
            return Object.class;
        }
        if (!(params[index] instanceof Class)) {
            return Object.class;
        }
        return (Class)params[index];
    }

    public static Class<?> getUserClass(Object instance) {
        Class<?> superClass;
        Class<?> clazz = instance.getClass();
        if (null != clazz && clazz.getName().contains("$$") && null != (superClass = clazz.getSuperclass()) && !Object.class.equals(superClass)) {
            return superClass;
        }
        return clazz;
    }

    public static RuntimeException convertReflectionExceptionToUnchecked(Exception e) {
        if (e instanceof IllegalAccessException || e instanceof IllegalArgumentException || e instanceof NoSuchMethodException) {
            return new IllegalArgumentException(e);
        }
        if (e instanceof InvocationTargetException) {
            return new RuntimeException(((InvocationTargetException)e).getTargetException());
        }
        if (e instanceof RuntimeException) {
            return (RuntimeException)e;
        }
        return new RuntimeException("Unexpected Checked Exception.", e);
    }

    public static boolean hasField(Object object, String fieldName) {
        Field field = ReflectKit.getAccessibleField(object, fieldName);
        return null != field;
    }

    public static boolean isOuterClassField(Field field) {
        return "this$0".equals(field.getName());
    }

    public static <T> Constructor<T> getConstructor(Class<T> clazz, Class<?> ... parameterTypes) {
        Constructor<?>[] constructors;
        if (null == clazz) {
            return null;
        }
        for (Constructor<?> constructor : constructors = clazz.getConstructors()) {
            Class<?>[] pts = constructor.getParameterTypes();
            if (!ClassKit.isAllAssignableFrom(pts, parameterTypes)) continue;
            return constructor;
        }
        return null;
    }

    public static <T> Constructor<T>[] getConstructors(Class<T> beanClass) throws SecurityException {
        Assert.notNull(beanClass);
        return CONSTRUCTORS_CACHE.computeIfAbsent(beanClass, key -> ReflectKit.getConstructorsDirectly(beanClass));
    }

    public static Constructor<?>[] getConstructorsDirectly(Class<?> beanClass) throws SecurityException {
        return beanClass.getDeclaredConstructors();
    }

    public static Field getField(Class<?> beanClass, String name) throws SecurityException {
        Field[] fields = ReflectKit.getFields(beanClass);
        return ArrayKit.firstNonNull(field -> name.equals(ReflectKit.getFieldName(field)), fields);
    }

    public static Field[] getFields(Class<?> beanClass) throws SecurityException {
        Assert.notNull(beanClass);
        return FIELDS_CACHE.computeIfAbsent(beanClass, key -> ReflectKit.getFields(beanClass, true));
    }

    public static Field[] getFields(Class<?> beanClass, Predicate<Field> fieldFilter) throws SecurityException {
        return ArrayKit.filter(ReflectKit.getFields(beanClass), fieldFilter);
    }

    public static Field[] getFields(Class<?> beanClass, boolean withSuperClassFields) throws SecurityException {
        Assert.notNull(beanClass);
        Field[] allFields = null;
        Class<?> searchType = beanClass;
        while (null != searchType) {
            Field[] declaredFields = searchType.getDeclaredFields();
            allFields = null == allFields ? declaredFields : ArrayKit.append(allFields, declaredFields);
            searchType = withSuperClassFields ? searchType.getSuperclass() : null;
        }
        return allFields;
    }

    public static String getFieldName(Field field) {
        if (null == field) {
            return null;
        }
        Alias alias = field.getAnnotation(Alias.class);
        if (null != alias) {
            return alias.value();
        }
        return field.getName();
    }

    public static Object getFieldValue(Object object, String fieldName) throws InternalException {
        if (null == object || StringKit.isBlank(fieldName)) {
            return null;
        }
        return ReflectKit.getFieldValue(object, ReflectKit.getField(object instanceof Class ? (Class<?>)object : object.getClass(), fieldName));
    }

    public static Object getFieldValue(Object object, Field field) throws InternalException {
        Object result;
        if (null == field) {
            return null;
        }
        if (object instanceof Class) {
            object = null;
        }
        ReflectKit.setAccessible(field);
        try {
            result = field.get(object);
        }
        catch (IllegalAccessException e) {
            throw new InternalException("IllegalAccess for {}.{}", field.getDeclaringClass(), field.getName());
        }
        return result;
    }

    public static Object[] getFieldsValue(Object object) {
        Field[] fields;
        if (null != object && null != (fields = ReflectKit.getFields(object instanceof Class ? (Class<?>)object : object.getClass()))) {
            Object[] values = new Object[fields.length];
            for (int i = 0; i < fields.length; ++i) {
                values[i] = ReflectKit.getFieldValue(object, fields[i]);
            }
            return values;
        }
        return null;
    }

    public static void setFieldValue(Object object, String fieldName, Object value) throws InternalException {
        Assert.notNull(object);
        Assert.notBlank(fieldName);
        Field field = ReflectKit.getField(object instanceof Class ? (Class<?>)object : object.getClass(), fieldName);
        Assert.notNull(field, "Field [{}] is not exist in [{}]", fieldName, object.getClass().getName());
        ReflectKit.setFieldValue(object, field, value);
    }

    public static void setFieldValue(Object object, Field field, Object value) throws InternalException {
        Assert.notNull(field, "Field in [{}] not exist !", object);
        Class<?> fieldType = field.getType();
        if (null != value) {
            Object targetValue;
            if (!fieldType.isAssignableFrom(value.getClass()) && null != (targetValue = Convert.convert(fieldType, value))) {
                value = targetValue;
            }
        } else {
            value = ClassKit.getDefaultValue(fieldType);
        }
        ReflectKit.setAccessible(field);
        try {
            field.set(object instanceof Class ? null : object, value);
        }
        catch (IllegalAccessException e) {
            throw new InternalException("IllegalAccess for {}.{}", object, field.getName());
        }
    }

    public static Method getMethodOfObject(Object object, String methodName, Object ... args) throws SecurityException {
        if (null == object || StringKit.isBlank(methodName)) {
            return null;
        }
        return ReflectKit.getMethod(object.getClass(), methodName, ClassKit.getClasses(args));
    }

    public static Method getMethodIgnoreCase(Class<?> clazz, String methodName, Class<?> ... paramTypes) throws SecurityException {
        return ReflectKit.getMethod(clazz, true, methodName, paramTypes);
    }

    public static Method getMethod(Class<?> clazz, String methodName, Class<?> ... paramTypes) throws SecurityException {
        return ReflectKit.getMethod(clazz, false, methodName, paramTypes);
    }

    public static Method getMethod(Class<?> clazz, boolean ignoreCase, String methodName, Class<?> ... paramTypes) throws SecurityException {
        if (null == clazz || StringKit.isBlank(methodName)) {
            return null;
        }
        Method result = null;
        Method[] methods = ReflectKit.getMethods(clazz);
        if (ArrayKit.isNotEmpty(methods)) {
            for (Method method : methods) {
                if (!StringKit.equals(methodName, method.getName(), ignoreCase) || !ClassKit.isAllAssignableFrom(method.getParameterTypes(), paramTypes) || result != null && !result.getReturnType().isAssignableFrom(method.getReturnType())) continue;
                result = method;
            }
        }
        return result;
    }

    public static Set<String> getMethodNames(Class<?> clazz) throws SecurityException {
        Method[] methods;
        HashSet<String> methodSet = new HashSet<String>();
        for (Method method : methods = ReflectKit.getMethods(clazz)) {
            methodSet.add(method.getName());
        }
        return methodSet;
    }

    public static Method[] getMethods(Class<?> clazz, Predicate<Method> filter) throws SecurityException {
        if (null == clazz) {
            return null;
        }
        Method[] methods = ReflectKit.getMethods(clazz);
        if (null == filter) {
            return methods;
        }
        ArrayList<Method> methodList = new ArrayList<Method>();
        for (Method method : methods) {
            if (!filter.test(method)) continue;
            methodList.add(method);
        }
        return methodList.toArray(new Method[methodList.size()]);
    }

    public static Method[] getMethods(Class<?> beanClass) throws SecurityException {
        Assert.notNull(beanClass);
        return METHODS_CACHE.computeIfAbsent(beanClass, key -> ReflectKit.getMethods(beanClass, false, Objects.equals(Object.class, beanClass)));
    }

    public static Method[] getMethods(Class<?> beanClass, boolean withSupers, boolean withMethodFromObject) throws SecurityException {
        Assert.notNull(beanClass);
        if (beanClass.isInterface()) {
            return withSupers ? beanClass.getMethods() : beanClass.getDeclaredMethods();
        }
        UniqueKeySet<String, Method> result = new UniqueKeySet<String, Method>(true, ReflectKit::getUniqueKey);
        Class<?> searchType = beanClass;
        while (searchType != null && (withMethodFromObject || Object.class != searchType)) {
            result.addAllIfAbsent(Arrays.asList(searchType.getDeclaredMethods()));
            result.addAllIfAbsent(ReflectKit.getDefaultMethodsFromInterface(searchType));
            searchType = withSupers && false == searchType.isInterface() ? searchType.getSuperclass() : null;
        }
        return result.toArray(new Method[0]);
    }

    public static boolean isEqualsMethod(Method method) {
        if (method == null || 1 != method.getParameterCount() || !"equals".equals(method.getName())) {
            return false;
        }
        return method.getParameterTypes()[0] == Object.class;
    }

    public static boolean isHashCodeMethod(Method method) {
        return null != method && ObjectKit.equals(method.getName(), "hashCode") && method.getParameterTypes().length == 0;
    }

    public static boolean isToStringMethod(Method method) {
        return null != method && ObjectKit.equals(method.getName(), "toString") && method.getParameterTypes().length == 0;
    }

    public static boolean isEmptyParam(Method method) {
        return method.getParameterCount() == 0;
    }

    public static boolean isGetterOrSetterIgnoreCase(Method method) {
        return ReflectKit.isGetterOrSetter(method, true);
    }

    public static boolean isGetterOrSetter(Method method, boolean ignoreCase) {
        if (null == method) {
            return false;
        }
        int parameterCount = method.getParameterCount();
        if (parameterCount > 1) {
            return false;
        }
        String name = method.getName();
        if ("getClass".equals(name)) {
            return false;
        }
        if (ignoreCase) {
            name = name.toLowerCase();
        }
        switch (parameterCount) {
            case 0: {
                return name.startsWith("get") || name.startsWith("is");
            }
            case 1: {
                return name.startsWith("set");
            }
        }
        return false;
    }

    public static <T> T newInstance(String clazz) throws InternalException {
        try {
            return (T)Class.forName(clazz).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new InternalException(StringKit.format((CharSequence)"Instance class [{}] error!", clazz), e);
        }
    }

    public static <T> T newInstance(Class<T> clazz, Object ... params) throws InternalException {
        if (ArrayKit.isEmpty(params)) {
            Constructor<T> constructor = ReflectKit.getConstructor(clazz, new Class[0]);
            if (null == constructor) {
                throw new InternalException("No constructor for [{}]", clazz);
            }
            try {
                return constructor.newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new InternalException(e, "Instance class [{}] error!", clazz);
            }
        }
        Class<?>[] paramTypes = ClassKit.getClasses(params);
        Constructor<T> constructor = ReflectKit.getConstructor(clazz, paramTypes);
        if (null == constructor) {
            throw new InternalException("No Constructor matched for parameter types: [{}]", new Object[]{paramTypes});
        }
        try {
            return constructor.newInstance(params);
        }
        catch (Exception e) {
            throw new InternalException(e, "Instance class [{}] error!", clazz);
        }
    }

    public static <T> T newInstanceIfPossible(Class<T> type) {
        Assert.notNull(type);
        if (type.isPrimitive()) {
            return (T)ClassKit.getPrimitiveDefaultValue(type);
        }
        if (type.isAssignableFrom(AbstractMap.class)) {
            type = HashMap.class;
        } else if (type.isAssignableFrom(List.class)) {
            type = ArrayList.class;
        } else if (type.isAssignableFrom(Set.class)) {
            type = HashSet.class;
        }
        try {
            return (T)ReflectKit.newInstance(type, new Object[0]);
        }
        catch (Exception exception) {
            Constructor<Object>[] constructors;
            if (type.isEnum()) {
                return (T)type.getEnumConstants()[0];
            }
            if (type.isArray()) {
                return (T)Array.newInstance(type.getComponentType(), 0);
            }
            for (Constructor<Object> constructor : constructors = ReflectKit.getConstructors(type)) {
                Class<?>[] parameterTypes = constructor.getParameterTypes();
                if (0 == parameterTypes.length) continue;
                ReflectKit.setAccessible(constructor);
                try {
                    return (T)constructor.newInstance(ClassKit.getDefaultValues(parameterTypes));
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
            return null;
        }
    }

    public static <T> T invokeStatic(Method method, Object ... args) throws InternalException {
        return ReflectKit.invoke(null, method, args);
    }

    public static <T> T invokeWithCheck(Object object, Method method, Object ... args) throws InternalException {
        Class<?>[] types = method.getParameterTypes();
        if (null != types && null != args) {
            Assert.isTrue(args.length == types.length, "Params length [{}] is not fit for param length [{}] of method !", args.length, types.length);
            for (int i = 0; i < args.length; ++i) {
                Class<?> type = types[i];
                if (!type.isPrimitive() || null != args[i]) continue;
                args[i] = ClassKit.getDefaultValue(type);
            }
        }
        return ReflectKit.invoke(object, method, args);
    }

    public static <T> T invoke(Object object, Method method, Object ... args) {
        ReflectKit.setAccessible(method);
        Class<?>[] parameterTypes = method.getParameterTypes();
        Object[] actualArgs = new Object[parameterTypes.length];
        if (null != args) {
            for (int i = 0; i < actualArgs.length; ++i) {
                if (i >= args.length || null == args[i]) {
                    actualArgs[i] = ClassKit.getDefaultValue(parameterTypes[i]);
                    continue;
                }
                if (!parameterTypes[i].isAssignableFrom(args[i].getClass())) {
                    Object targetValue = Convert.convertQuietly(parameterTypes[i], args[i], args[i]);
                    if (null == targetValue) continue;
                    actualArgs[i] = targetValue;
                    continue;
                }
                actualArgs[i] = args[i];
            }
        }
        try {
            return (T)method.invoke(ClassKit.isStatic(method) ? null : object, actualArgs);
        }
        catch (Exception e) {
            throw new InternalException(e);
        }
    }

    public static <T> T invoke(Object object, String methodName, Object ... args) {
        Method method = ReflectKit.getMethodOfObject(object, methodName, args);
        if (null == method) {
            throw new InternalException(StringKit.format((CharSequence)"No such method: [{}]", methodName));
        }
        return ReflectKit.invoke(object, method, args);
    }

    public static String getGetMethodName(String fieldName) {
        return "get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
    }

    public static String getSetMethodName(String fieldName) {
        return "set" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
    }

    public static <T extends AccessibleObject> T setAccessible(T accessibleObject) {
        if (null != accessibleObject && !accessibleObject.isAccessible()) {
            accessibleObject.setAccessible(true);
        }
        return accessibleObject;
    }

    public static String getDescriptor(Executable executable) {
        Class<?>[] parameters;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('(');
        for (Class<?> parameter : parameters = executable.getParameterTypes()) {
            stringBuilder.append(ReflectKit.getDescriptor(parameter));
        }
        if (executable instanceof Method) {
            Method method = (Method)executable;
            return stringBuilder.append(')').append(ReflectKit.getDescriptor(method.getReturnType())).toString();
        }
        if (executable instanceof Constructor) {
            return stringBuilder.append(")V").toString();
        }
        throw new IllegalArgumentException("Unknown Executable: " + executable);
    }

    public static String getDescriptor(Class<?> clazz) {
        StringBuilder stringBuilder = new StringBuilder();
        Class<?> currentClass = clazz;
        while (currentClass.isArray()) {
            stringBuilder.append('[');
            currentClass = currentClass.getComponentType();
        }
        if (currentClass.isPrimitive()) {
            int descriptor;
            if (currentClass == Boolean.TYPE) {
                descriptor = 90;
            } else if (currentClass == Byte.TYPE) {
                descriptor = 66;
            } else if (currentClass == Short.TYPE) {
                descriptor = 83;
            } else if (currentClass == Character.TYPE) {
                descriptor = 67;
            } else if (currentClass == Integer.TYPE) {
                descriptor = 73;
            } else if (currentClass == Long.TYPE) {
                descriptor = 74;
            } else if (currentClass == Float.TYPE) {
                descriptor = 70;
            } else if (currentClass == Double.TYPE) {
                descriptor = 68;
            } else if (currentClass == Void.TYPE) {
                descriptor = 86;
            } else {
                throw new AssertionError();
            }
            stringBuilder.append((char)descriptor);
        } else {
            stringBuilder.append('L').append(currentClass.getName().replace('.', '/')).append(';');
        }
        return stringBuilder.toString();
    }

    private static Object[] actualArgs(Method method, Object[] args) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        Object[] actualArgs = new Object[parameterTypes.length];
        if (null != args) {
            for (int i = 0; i < actualArgs.length; ++i) {
                if (i >= args.length || null == args[i]) {
                    actualArgs[i] = ClassKit.getDefaultValue(parameterTypes[i]);
                    continue;
                }
                if (args[i] instanceof NullWrapper) {
                    actualArgs[i] = null;
                    continue;
                }
                if (!parameterTypes[i].isAssignableFrom(args[i].getClass())) {
                    Object targetValue = Convert.convert(parameterTypes[i], args[i]);
                    if (null == targetValue) continue;
                    actualArgs[i] = targetValue;
                    continue;
                }
                actualArgs[i] = args[i];
            }
        }
        return actualArgs;
    }

    private static String getUniqueKey(Method method) {
        StringBuilder sb = new StringBuilder();
        sb.append(method.getReturnType().getName()).append('#');
        sb.append(method.getName());
        Class<?>[] parameters = method.getParameterTypes();
        for (int i = 0; i < parameters.length; ++i) {
            if (i == 0) {
                sb.append(':');
            } else {
                sb.append(',');
            }
            sb.append(parameters[i].getName());
        }
        return sb.toString();
    }

    private static List<Method> getDefaultMethodsFromInterface(Class<?> clazz) {
        ArrayList<Method> result = new ArrayList<Method>();
        for (Class<?> ifc : clazz.getInterfaces()) {
            for (Method m : ifc.getMethods()) {
                if (ClassKit.isAbstract(m)) continue;
                result.add(m);
            }
        }
        return result;
    }
}

