/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.convert;

import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.Map;
import org.aoju.bus.core.beans.copier.BeanCopier;
import org.aoju.bus.core.beans.copier.CopyOptions;
import org.aoju.bus.core.beans.copier.ValueProvider;
import org.aoju.bus.core.convert.Converter;
import org.aoju.bus.core.exception.ConvertException;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.map.MapProxy;
import org.aoju.bus.core.toolkit.BeanKit;
import org.aoju.bus.core.toolkit.ObjectKit;
import org.aoju.bus.core.toolkit.ReflectKit;
import org.aoju.bus.core.toolkit.TypeKit;

public class BeanConverter
implements Converter,
Serializable {
    private static final long serialVersionUID = 1L;
    public static BeanConverter INSTANCE = new BeanConverter();
    private final CopyOptions copyOptions;

    public BeanConverter() {
        this(CopyOptions.of().setIgnoreError(true));
    }

    public BeanConverter(CopyOptions copyOptions) {
        this.copyOptions = copyOptions;
    }

    @Override
    public Object convert(Type targetType, Object value) throws ConvertException {
        Assert.notNull(targetType);
        if (null == value) {
            return null;
        }
        if (value instanceof Converter) {
            return ((Converter)value).convert(targetType, value);
        }
        Class<?> targetClass = TypeKit.getClass(targetType);
        Assert.notNull(targetClass, "Target type is not a class!", new Object[0]);
        return this.convertInternal(targetType, targetClass, value);
    }

    private Object convertInternal(Type targetType, Class<?> targetClass, Object value) {
        if (value instanceof Map || value instanceof ValueProvider || BeanKit.isBean(value.getClass())) {
            if (value instanceof Map && targetClass.isInterface()) {
                return MapProxy.of((Map)value).toProxyBean(targetClass);
            }
            return BeanCopier.create(value, ReflectKit.newInstanceIfPossible(targetClass), targetType, this.copyOptions).copy();
        }
        if (value instanceof byte[]) {
            return ObjectKit.deserialize((byte[])value);
        }
        throw new ConvertException("Unsupported source type: [{}] to [{}]", value.getClass(), targetType);
    }
}

