/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.io.copier;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import org.aoju.bus.core.exception.InternalException;
import org.aoju.bus.core.io.Progress;
import org.aoju.bus.core.io.copier.IoCopier;

public class ChannelCopier
extends IoCopier<ReadableByteChannel, WritableByteChannel> {
    public ChannelCopier() {
        this(8192);
    }

    public ChannelCopier(int bufferSize) {
        this(bufferSize, -1L);
    }

    public ChannelCopier(int bufferSize, long count) {
        this(bufferSize, count, null);
    }

    public ChannelCopier(int bufferSize, long count, Progress progress) {
        super(bufferSize, count, progress);
    }

    @Override
    public long copy(ReadableByteChannel source, WritableByteChannel target) {
        long size;
        Progress progress = this.progress;
        if (null != progress) {
            progress.start();
        }
        try {
            size = this.doCopy(source, target, ByteBuffer.allocate(this.bufferSize(this.count)), progress);
        }
        catch (IOException e) {
            throw new InternalException(e);
        }
        if (null != progress) {
            progress.finish();
        }
        return size;
    }

    private long doCopy(ReadableByteChannel source, WritableByteChannel target, ByteBuffer buffer, Progress progress) throws IOException {
        int read;
        long numToRead = this.count > 0L ? this.count : Long.MAX_VALUE;
        long total = 0L;
        while (numToRead > 0L && (read = source.read(buffer)) >= 0) {
            buffer.flip();
            target.write(buffer);
            buffer.clear();
            numToRead -= (long)read;
            total += (long)read;
            if (null == progress) continue;
            progress.progress(this.count < Long.MAX_VALUE ? this.count : -1L, total);
        }
        return total;
    }
}

