/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.io.copier;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import org.aoju.bus.core.exception.InternalException;
import org.aoju.bus.core.io.copier.IoCopier;
import org.aoju.bus.core.toolkit.IoKit;

public class FileChannelCopier
extends IoCopier<FileChannel, FileChannel> {
    public FileChannelCopier(long count) {
        super(-1, count, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long copy(FileInputStream in, FileOutputStream out) {
        long l;
        FileChannel inChannel = null;
        FileChannel outChannel = null;
        try {
            inChannel = in.getChannel();
            outChannel = out.getChannel();
            l = this.copy(inChannel, outChannel);
        }
        catch (Throwable throwable) {
            IoKit.close(outChannel);
            IoKit.close(inChannel);
            throw throwable;
        }
        IoKit.close(outChannel);
        IoKit.close(inChannel);
        return l;
    }

    @Override
    public long copy(FileChannel source, FileChannel target) {
        try {
            return this.doCopySafely(source, target);
        }
        catch (IOException e) {
            throw new InternalException(e);
        }
    }

    private long doCopySafely(FileChannel inChannel, FileChannel outChannel) throws IOException {
        long writeBytes;
        long totalBytes = inChannel.size();
        if (this.count > 0L && this.count < totalBytes) {
            totalBytes = this.count;
        }
        long pos = 0L;
        for (long remaining = totalBytes; remaining > 0L; remaining -= writeBytes) {
            writeBytes = inChannel.transferTo(pos, remaining, outChannel);
            pos += writeBytes;
        }
        return totalBytes;
    }
}

