/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.io.stream;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.aoju.bus.core.exception.InternalException;
import org.aoju.bus.core.io.stream.FastByteOutputStream;
import org.aoju.bus.core.io.stream.ObjectInputStream;
import org.aoju.bus.core.toolkit.IoKit;

public class StreamReader {
    private final InputStream in;
    private final boolean closeAfterRead;

    public StreamReader(InputStream in, boolean closeAfterRead) {
        this.in = in;
        this.closeAfterRead = closeAfterRead;
    }

    public static StreamReader of(InputStream in, boolean closeAfterRead) {
        return new StreamReader(in, closeAfterRead);
    }

    public byte[] readBytes() throws InternalException {
        return this.readBytes(-1);
    }

    public byte[] readBytes(int length) throws InternalException {
        InputStream in = this.in;
        if (null == in || length == 0) {
            return new byte[0];
        }
        return this.read(length).toByteArray();
    }

    public FastByteOutputStream read() throws InternalException {
        return this.read(-1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FastByteOutputStream read(int limit) throws InternalException {
        FastByteOutputStream out;
        InputStream in = this.in;
        if (in instanceof FileInputStream) {
            try {
                int length = in.available();
                if (limit > 0 && limit < length) {
                    length = limit;
                }
                out = new FastByteOutputStream(length);
            }
            catch (IOException e) {
                throw new InternalException(e);
            }
        } else {
            out = new FastByteOutputStream();
        }
        try {
            IoKit.copy(in, out, 8192, (long)limit, null);
        }
        finally {
            if (this.closeAfterRead) {
                IoKit.close(in);
            }
        }
        return out;
    }

    public <T> T readObject(Class<?> ... acceptClasses) throws InternalException {
        ObjectInputStream validateIn;
        InputStream in = this.in;
        if (null == in) {
            return null;
        }
        if (in instanceof ObjectInputStream) {
            validateIn = (ObjectInputStream)in;
            validateIn.accept(acceptClasses);
        } else {
            try {
                validateIn = new ObjectInputStream(in, acceptClasses);
            }
            catch (IOException e) {
                throw new InternalException(e);
            }
        }
        try {
            return (T)validateIn.readObject();
        }
        catch (IOException | ClassNotFoundException e) {
            throw new InternalException(e);
        }
    }
}

