/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.lang.range;

public enum BoundType {
    CLOSE_LOWER_BOUND("[", ">=", -2),
    OPEN_LOWER_BOUND("(", ">", -1),
    OPEN_UPPER_BOUND(")", "<", 1),
    CLOSE_UPPER_BOUND("]", "<=", 2);

    private final String symbol;
    private final String operator;
    private final int code;

    private BoundType(String symbol, String operator, int code) {
        this.symbol = symbol;
        this.operator = operator;
        this.code = code;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public int getCode() {
        return this.code;
    }

    public String getOperator() {
        return this.operator;
    }

    public boolean isDislocated(BoundType boundType) {
        return this.code * boundType.code < 0;
    }

    public boolean isLowerBound() {
        return this.code < 0;
    }

    public boolean isUpperBound() {
        return this.code > 0;
    }

    public boolean isClose() {
        return (this.code & 1) == 0;
    }

    public boolean isOpen() {
        return (this.code & 1) == 1;
    }

    public BoundType negate() {
        if (this.isLowerBound()) {
            return this.isOpen() ? CLOSE_UPPER_BOUND : OPEN_UPPER_BOUND;
        }
        return this.isOpen() ? CLOSE_LOWER_BOUND : OPEN_LOWER_BOUND;
    }
}

