/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.text;

import java.util.Objects;
import java.util.function.UnaryOperator;
import org.aoju.bus.core.exception.InternalException;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.toolkit.StringKit;

public class Placeholder
implements UnaryOperator<String> {
    private final UnaryOperator<String> processor;
    private final String open;
    private final int openLength;
    private final String close;
    private final int closeLength;
    private final char escape;

    public Placeholder(UnaryOperator<String> processor, String prefix, String suffix) {
        this(processor, prefix, suffix, '\\');
    }

    public Placeholder(UnaryOperator<String> processor, String prefix, String suffix, char escape) {
        Assert.isFalse(StringKit.isEmpty(prefix), "\u5f00\u59cb\u7b26\u53f7\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        Assert.isFalse(StringKit.isEmpty(suffix), "\u7ed3\u675f\u7b26\u53f7\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        this.processor = Objects.requireNonNull(processor);
        this.open = prefix;
        this.openLength = prefix.length();
        this.close = suffix;
        this.closeLength = suffix.length();
        this.escape = escape;
    }

    @Override
    public String apply(String text) {
        if (StringKit.isEmpty(text)) {
            return "";
        }
        int closeCursor = 0;
        int openCursor = text.indexOf(this.open, closeCursor);
        if (openCursor == -1) {
            return text;
        }
        char[] src = text.toCharArray();
        StringBuilder result = new StringBuilder(src.length);
        StringBuilder expression = new StringBuilder();
        while (openCursor > -1) {
            if (openCursor > 0 && src[openCursor - 1] == this.escape) {
                result.append(src, closeCursor, openCursor - closeCursor - 1).append(this.open);
                closeCursor = openCursor + this.openLength;
                openCursor = text.indexOf(this.open, closeCursor);
                continue;
            }
            result.append(src, closeCursor, openCursor - closeCursor);
            closeCursor = openCursor + this.openLength;
            int end = text.indexOf(this.close, closeCursor);
            while (end > -1) {
                if (end > closeCursor && src[end - 1] == this.escape) {
                    expression.append(src, closeCursor, end - closeCursor - 1).append(this.close);
                    closeCursor = end + this.closeLength;
                    end = text.indexOf(this.close, closeCursor);
                    continue;
                }
                expression.append(src, closeCursor, end - closeCursor);
                break;
            }
            if (end == -1) {
                throw new InternalException("\"{}\" \u4e2d\u5b57\u7b26\u4e0b\u6807 {} \u5904\u7684\u5f00\u59cb\u7b26\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u7ed3\u675f\u7b26", text, openCursor);
            }
            result.append((String)this.processor.apply(expression.toString()));
            expression.setLength(0);
            closeCursor = end + this.close.length();
            openCursor = text.indexOf(this.open, closeCursor);
        }
        if (closeCursor < src.length) {
            result.append(src, closeCursor, src.length - closeCursor);
        }
        return result.toString();
    }
}

