/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.toolkit;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.aoju.bus.core.date.Almanac;
import org.aoju.bus.core.date.Boundary;
import org.aoju.bus.core.date.DateTime;
import org.aoju.bus.core.date.Lunar;
import org.aoju.bus.core.date.Solar;
import org.aoju.bus.core.lang.Fields;
import org.aoju.bus.core.toolkit.CollKit;

public class DateKit
extends Almanac {
    public static long spendNt(long preTime) {
        return System.nanoTime() - preTime;
    }

    public static long spendMs(long preTime) {
        return System.currentTimeMillis() - preTime;
    }

    public static int ageOfNow(String birthDay) {
        return DateKit.ageOfNow(DateKit.parse(birthDay));
    }

    public static int ageOfNow(Date birthDay) {
        return DateKit.getAge(birthDay, DateKit.date());
    }

    public static String getLastTime(Date date) {
        if (null == date) {
            return null;
        }
        long diff = System.currentTimeMillis() - date.getTime();
        if (diff > Fields.Units.WEEK.getUnit()) {
            long r = diff / Fields.Units.WEEK.getUnit();
            return r + "\u5468\u524d";
        }
        if (diff > Fields.Units.DAY.getUnit()) {
            long r = diff / Fields.Units.DAY.getUnit();
            return r + "\u5929\u524d";
        }
        if (diff > Fields.Units.HOUR.getUnit()) {
            long r = diff / Fields.Units.HOUR.getUnit();
            return r + "\u4e2a\u5c0f\u65f6\u524d";
        }
        if (diff > Fields.Units.MINUTE.getUnit()) {
            long r = diff / Fields.Units.MINUTE.getUnit();
            return r + "\u5206\u949f\u524d";
        }
        return "\u521a\u521a";
    }

    public static Boundary range(Date start, Date end, Fields.Type type) {
        return new Boundary(start, end, type);
    }

    public static List<DateTime> rangeContains(Boundary start, Boundary end) {
        ArrayList<DateTime> startDateTimes = CollKit.newArrayList(start);
        ArrayList<DateTime> endDateTimes = CollKit.newArrayList(end);
        return startDateTimes.stream().filter(endDateTimes::contains).collect(Collectors.toList());
    }

    public static List<DateTime> rangeNotContains(Boundary start, Boundary end) {
        ArrayList<DateTime> startDateTimes = CollKit.newArrayList(start);
        ArrayList<DateTime> endDateTimes = CollKit.newArrayList(end);
        return endDateTimes.stream().filter(item -> !startDateTimes.contains(item)).collect(Collectors.toList());
    }

    public static <T> List<T> rangeFunc(Date start, Date end, Fields.Type type, Function<Date, T> func) {
        if (start == null || end == null || start.after(end)) {
            return Collections.emptyList();
        }
        ArrayList<T> list = new ArrayList<T>();
        for (DateTime date : DateKit.range(start, end, type)) {
            list.add(func.apply(date));
        }
        return list;
    }

    public static void rangeConsume(Date start, Date end, Fields.Type type, Consumer<Date> consumer) {
        if (start == null || end == null || start.after(end)) {
            return;
        }
        DateKit.range(start, end, type).forEach(consumer);
    }

    public static List<DateTime> rangeToList(Date start, Date end, Fields.Type type) {
        return CollKit.newArrayList(DateKit.range(start, end, type));
    }

    public static List<DateTime> rangeToList(Date start, Date end, Fields.Type type, int step) {
        return CollKit.newArrayList(new Boundary(start, end, type, step));
    }

    public Lunar getLunar() {
        return new Lunar(DateKit.date());
    }

    public Lunar getLunar(Calendar calendar) {
        return new Lunar(calendar.get(1), calendar.get(2), calendar.get(5), calendar.get(11), calendar.get(12), calendar.get(13));
    }

    public Lunar getLunar(int year, int month, int day) {
        return this.getLunar(year, month, day, 0, 0);
    }

    public Lunar getLunar(int year, int month, int day, int hour, int minute) {
        return this.getLunar(year, month, day, hour, minute, 0);
    }

    public Lunar getLunar(int year, int month, int day, int hour, int minute, int second) {
        return new Lunar(year, month, day, hour, minute, second);
    }

    public Solar getSolar() {
        return new Solar(DateKit.date());
    }

    public Solar getSolar(Calendar calendar) {
        return new Solar(calendar.get(1), calendar.get(2), calendar.get(5), calendar.get(11), calendar.get(12), calendar.get(13));
    }

    public Solar getSolar(int year, int month, int day) {
        return this.getSolar(year, month, day, 0, 0);
    }

    public Solar getSolar(int year, int month, int day, int hour, int minute) {
        return this.getSolar(year, month, day, hour, minute, 0);
    }

    public Solar getSolar(int year, int month, int day, int hour, int minute, int second) {
        return new Solar(year, month, day, hour, minute, second);
    }
}

