/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.toolkit;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.aoju.bus.core.exception.InternalException;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.lang.Normal;
import org.aoju.bus.core.math.Arrange;
import org.aoju.bus.core.math.Combine;
import org.aoju.bus.core.math.Formula;
import org.aoju.bus.core.math.Money;
import org.aoju.bus.core.toolkit.ArrayKit;
import org.aoju.bus.core.toolkit.CharsKit;
import org.aoju.bus.core.toolkit.ObjectKit;
import org.aoju.bus.core.toolkit.RandomKit;
import org.aoju.bus.core.toolkit.StringKit;

public class MathKit {
    private static final int DEFAULT_DIV_SCALE = 10;
    private static long bytes;

    private MathKit(long bytes) {
        MathKit.bytes = bytes;
    }

    public static double add(float v1, float v2) {
        return MathKit.add(Float.toString(v1), Float.toString(v2)).doubleValue();
    }

    public static double add(float v1, double v2) {
        return MathKit.add(Float.toString(v1), Double.toString(v2)).doubleValue();
    }

    public static double add(double v1, float v2) {
        return MathKit.add(Double.toString(v1), Float.toString(v2)).doubleValue();
    }

    public static double add(double v1, double v2) {
        return MathKit.add(Double.toString(v1), Double.toString(v2)).doubleValue();
    }

    public static BigDecimal add(Number v1, Number v2) {
        return MathKit.add(new Number[]{v1, v2});
    }

    public static BigDecimal add(Number ... args) {
        if (ArrayKit.isEmpty(args)) {
            return BigDecimal.ZERO;
        }
        Number value = args[0];
        BigDecimal result = new BigDecimal(null == value ? "0" : value.toString());
        for (int i = 1; i < args.length; ++i) {
            value = args[i];
            if (null == value) continue;
            result = result.add(new BigDecimal(value.toString()));
        }
        return result;
    }

    public static BigDecimal add(String ... args) {
        if (ArrayKit.isEmpty(args)) {
            return BigDecimal.ZERO;
        }
        String value = args[0];
        BigDecimal result = null == value ? BigDecimal.ZERO : new BigDecimal(value);
        for (int i = 1; i < args.length; ++i) {
            value = args[i];
            if (null == value) continue;
            result = result.add(new BigDecimal(value));
        }
        return result;
    }

    public static BigDecimal add(BigDecimal ... args) {
        if (ArrayKit.isEmpty(args)) {
            return BigDecimal.ZERO;
        }
        BigDecimal value = args[0];
        BigDecimal result = null == value ? BigDecimal.ZERO : value;
        for (int i = 1; i < args.length; ++i) {
            value = args[i];
            if (null == value) continue;
            result = result.add(value);
        }
        return result;
    }

    public static double sub(float v1, float v2) {
        return MathKit.sub(Float.toString(v1), Float.toString(v2)).doubleValue();
    }

    public static double sub(float v1, double v2) {
        return MathKit.sub(Float.toString(v1), Double.toString(v2)).doubleValue();
    }

    public static double sub(double v1, float v2) {
        return MathKit.sub(Double.toString(v1), Float.toString(v2)).doubleValue();
    }

    public static double sub(double v1, double v2) {
        return MathKit.sub(Double.toString(v1), Double.toString(v2)).doubleValue();
    }

    public static BigDecimal sub(Number v1, Number v2) {
        return MathKit.sub(new Number[]{v1, v2});
    }

    public static BigDecimal sub(Number ... args) {
        if (ArrayKit.isEmpty(args)) {
            return BigDecimal.ZERO;
        }
        Number value = args[0];
        BigDecimal result = new BigDecimal(null == value ? "0" : value.toString());
        for (int i = 1; i < args.length; ++i) {
            value = args[i];
            if (null == value) continue;
            result = result.subtract(new BigDecimal(value.toString()));
        }
        return result;
    }

    public static BigDecimal sub(String ... args) {
        if (ArrayKit.isEmpty(args)) {
            return BigDecimal.ZERO;
        }
        String value = args[0];
        BigDecimal result = new BigDecimal(null == value ? "0" : value);
        for (int i = 1; i < args.length; ++i) {
            value = args[i];
            if (null == value) continue;
            result = result.subtract(new BigDecimal(value));
        }
        return result;
    }

    public static BigDecimal sub(BigDecimal ... args) {
        if (ArrayKit.isEmpty(args)) {
            return BigDecimal.ZERO;
        }
        BigDecimal value = args[0];
        BigDecimal result = null == value ? BigDecimal.ZERO : value;
        for (int i = 1; i < args.length; ++i) {
            value = args[i];
            if (null == value) continue;
            result = result.subtract(value);
        }
        return result;
    }

    public static double mul(float v1, float v2) {
        return MathKit.mul(Float.toString(v1), Float.toString(v2)).doubleValue();
    }

    public static double mul(float v1, double v2) {
        return MathKit.mul(Float.toString(v1), Double.toString(v2)).doubleValue();
    }

    public static double mul(double v1, float v2) {
        return MathKit.mul(Double.toString(v1), Float.toString(v2)).doubleValue();
    }

    public static double mul(double v1, double v2) {
        return MathKit.mul(Double.toString(v1), Double.toString(v2)).doubleValue();
    }

    public static BigDecimal mul(Number v1, Number v2) {
        return MathKit.mul(new Number[]{v1, v2});
    }

    public static BigDecimal mul(Number ... args) {
        if (ArrayKit.isEmpty(args)) {
            return BigDecimal.ZERO;
        }
        Number value = args[0];
        BigDecimal result = new BigDecimal(null == value ? "0" : value.toString());
        for (int i = 1; i < args.length; ++i) {
            value = args[i];
            if (null == value) continue;
            result = result.multiply(new BigDecimal(value.toString()));
        }
        return result;
    }

    public static BigDecimal mul(String v1, String v2) {
        return MathKit.mul((Number)new BigDecimal(v1), (Number)new BigDecimal(v2));
    }

    public static BigDecimal mul(String ... args) {
        if (ArrayKit.isEmpty(args) || ArrayKit.hasNull(args)) {
            return BigDecimal.ZERO;
        }
        BigDecimal result = new BigDecimal(args[0]);
        for (int i = 1; i < args.length; ++i) {
            result = result.multiply(new BigDecimal(args[i]));
        }
        return result;
    }

    public static BigDecimal mul(BigDecimal ... args) {
        if (ArrayKit.isEmpty(args) || ArrayKit.hasNull(args)) {
            return BigDecimal.ZERO;
        }
        BigDecimal result = args[0];
        for (int i = 1; i < args.length; ++i) {
            result = result.multiply(args[i]);
        }
        return result;
    }

    public static double div(float v1, float v2) {
        return MathKit.div(v1, v2, 10);
    }

    public static double div(float v1, double v2) {
        return MathKit.div(v1, v2, 10);
    }

    public static double div(double v1, float v2) {
        return MathKit.div(v1, v2, 10);
    }

    public static double div(double v1, double v2) {
        return MathKit.div(v1, v2, 10);
    }

    public static BigDecimal div(Number v1, Number v2) {
        return MathKit.div(v1, v2, 10);
    }

    public static BigDecimal div(String v1, String v2) {
        return MathKit.div(v1, v2, 10);
    }

    public static double div(float v1, float v2, int scale) {
        return MathKit.div(v1, v2, scale, RoundingMode.HALF_UP);
    }

    public static double div(float v1, double v2, int scale) {
        return MathKit.div(v1, v2, scale, RoundingMode.HALF_UP);
    }

    public static double div(double v1, float v2, int scale) {
        return MathKit.div(v1, v2, scale, RoundingMode.HALF_UP);
    }

    public static double div(double v1, double v2, int scale) {
        return MathKit.div(v1, v2, scale, RoundingMode.HALF_UP);
    }

    public static BigDecimal div(Number v1, Number v2, int scale) {
        return MathKit.div(v1, v2, scale, RoundingMode.HALF_UP);
    }

    public static BigDecimal div(String v1, String v2, int scale) {
        return MathKit.div(v1, v2, scale, RoundingMode.HALF_UP);
    }

    public static double div(float v1, float v2, int scale, RoundingMode roundingMode) {
        return MathKit.div(Float.toString(v1), Float.toString(v2), scale, roundingMode).doubleValue();
    }

    public static double div(float v1, double v2, int scale, RoundingMode roundingMode) {
        return MathKit.div(Float.toString(v1), Double.toString(v2), scale, roundingMode).doubleValue();
    }

    public static double div(double v1, float v2, int scale, RoundingMode roundingMode) {
        return MathKit.div(Double.toString(v1), Float.toString(v2), scale, roundingMode).doubleValue();
    }

    public static double div(double v1, double v2, int scale, RoundingMode roundingMode) {
        return MathKit.div(Double.toString(v1), Double.toString(v2), scale, roundingMode).doubleValue();
    }

    public static BigDecimal div(Number v1, Number v2, int scale, RoundingMode roundingMode) {
        if (v1 instanceof BigDecimal && v2 instanceof BigDecimal) {
            return MathKit.div((BigDecimal)v1, (BigDecimal)v2, scale, roundingMode);
        }
        return MathKit.div(StringKit.toStringOrNull(v1), StringKit.toStringOrNull(v2), scale, roundingMode);
    }

    public static BigDecimal div(String v1, String v2, int scale, RoundingMode roundingMode) {
        return MathKit.div(new BigDecimal(v1), new BigDecimal(v2), scale, roundingMode);
    }

    public static BigDecimal div(BigDecimal v1, BigDecimal v2, int scale, RoundingMode roundingMode) {
        Assert.notNull(v2, "Divisor must be not null !", new Object[0]);
        if (null == v1) {
            return BigDecimal.ZERO;
        }
        if (scale < 0) {
            scale = -scale;
        }
        return v1.divide(v2, scale, roundingMode);
    }

    public static int ceilDiv(int v1, int v2) {
        return (int)Math.ceil((double)v1 / (double)v2);
    }

    public static BigDecimal round(double v, int scale) {
        return MathKit.round(v, scale, RoundingMode.HALF_UP);
    }

    public static String roundString(double v, int scale) {
        return MathKit.round(v, scale).toPlainString();
    }

    public static BigDecimal round(String number, int scale) {
        return MathKit.round(number, scale, RoundingMode.HALF_UP);
    }

    public static BigDecimal round(BigDecimal number, int scale) {
        return MathKit.round(number, scale, RoundingMode.HALF_UP);
    }

    public static String roundString(String number, int scale) {
        return MathKit.round(number, scale).toPlainString();
    }

    public static BigDecimal round(double v, int scale, RoundingMode roundingMode) {
        return MathKit.round(Double.toString(v), scale, roundingMode);
    }

    public static String roundString(double v, int scale, RoundingMode roundingMode) {
        return MathKit.round(v, scale, roundingMode).toPlainString();
    }

    public static BigDecimal round(String number, int scale, RoundingMode roundingMode) {
        Assert.notBlank(number);
        if (scale < 0) {
            scale = 0;
        }
        return MathKit.round(MathKit.toBigDecimal(number), scale, roundingMode);
    }

    public static BigDecimal round(BigDecimal number, int scale, RoundingMode roundingMode) {
        if (null == number) {
            number = BigDecimal.ZERO;
        }
        if (scale < 0) {
            scale = 0;
        }
        if (null == roundingMode) {
            roundingMode = RoundingMode.HALF_UP;
        }
        return number.setScale(scale, roundingMode);
    }

    public static String roundString(String number, int scale, RoundingMode roundingMode) {
        return MathKit.round(number, scale, roundingMode).toPlainString();
    }

    public static BigDecimal roundHalfEven(Number number, int scale) {
        return MathKit.roundHalfEven(MathKit.toBigDecimal(number), scale);
    }

    public static BigDecimal roundHalfEven(BigDecimal value, int scale) {
        return MathKit.round(value, scale, RoundingMode.HALF_EVEN);
    }

    public static BigDecimal roundDown(Number number, int scale) {
        return MathKit.roundDown(MathKit.toBigDecimal(number), scale);
    }

    public static BigDecimal roundDown(BigDecimal value, int scale) {
        return MathKit.round(value, scale, RoundingMode.DOWN);
    }

    public static String decimalFormat(String pattern, double value) {
        return new DecimalFormat(pattern).format(value);
    }

    public static String decimalFormat(String pattern, long value) {
        Assert.isTrue(MathKit.isValid(value), "value is NaN or Infinite!", new Object[0]);
        return new DecimalFormat(pattern).format(value);
    }

    public static String decimalFormat(String pattern, Object value) {
        return MathKit.decimalFormat(pattern, value, null);
    }

    public static String decimalFormat(String pattern, Object value, RoundingMode roundingMode) {
        DecimalFormat decimalFormat = new DecimalFormat(pattern);
        if (null != roundingMode) {
            decimalFormat.setRoundingMode(roundingMode);
        }
        return decimalFormat.format(value);
    }

    public static String decimalFormatMoney(double value) {
        return MathKit.decimalFormat(",##0.00", value);
    }

    public static String formatPercent(double number, int scale) {
        NumberFormat format = NumberFormat.getPercentInstance();
        format.setMaximumFractionDigits(scale);
        return format.format(number);
    }

    public static String formatPercent(Number num, Number total, int scale) {
        return MathKit.formatPercent(num.doubleValue() / total.doubleValue(), scale);
    }

    public static boolean isNumber(CharSequence text) {
        int i;
        int start;
        if (StringKit.isBlank(text)) {
            return false;
        }
        char[] chars = text.toString().toCharArray();
        int sz = chars.length;
        boolean hasExp = false;
        boolean hasDecPoint = false;
        boolean allowSigns = false;
        boolean foundDigit = false;
        int n = start = chars[0] == '-' ? 1 : 0;
        if (sz > start + 1 && chars[start] == '0' && chars[start + 1] == 'x') {
            int i2 = start + 2;
            if (i2 == sz) {
                return false;
            }
            while (i2 < chars.length) {
                if (!(chars[i2] >= '0' && chars[i2] <= '9' || chars[i2] >= 'a' && chars[i2] <= 'f' || chars[i2] >= 'A' && chars[i2] <= 'F')) {
                    return false;
                }
                ++i2;
            }
            return true;
        }
        --sz;
        for (i = start; i < sz || i < sz + 1 && allowSigns && !foundDigit; ++i) {
            if (chars[i] >= '0' && chars[i] <= '9') {
                foundDigit = true;
                allowSigns = false;
                continue;
            }
            if (chars[i] == '.') {
                if (hasDecPoint || hasExp) {
                    return false;
                }
                hasDecPoint = true;
                continue;
            }
            if (chars[i] == 'e' || chars[i] == 'E') {
                if (hasExp) {
                    return false;
                }
                if (!foundDigit) {
                    return false;
                }
                hasExp = true;
                allowSigns = true;
                continue;
            }
            if (chars[i] == '+' || chars[i] == '-') {
                if (!allowSigns) {
                    return false;
                }
                allowSigns = false;
                foundDigit = false;
                continue;
            }
            return false;
        }
        if (i < chars.length) {
            if (chars[i] >= '0' && chars[i] <= '9') {
                return true;
            }
            if (chars[i] == 'e' || chars[i] == 'E') {
                return false;
            }
            if (chars[i] == '.') {
                if (hasDecPoint || hasExp) {
                    return false;
                }
                return foundDigit;
            }
            if (!(allowSigns || chars[i] != 'd' && chars[i] != 'D' && chars[i] != 'f' && chars[i] != 'F')) {
                return foundDigit;
            }
            if (chars[i] == 'l' || chars[i] == 'L') {
                return foundDigit && !hasExp;
            }
            return false;
        }
        return !allowSigns && foundDigit;
    }

    public static boolean isInteger(String s) {
        if (StringKit.isBlank(s)) {
            return false;
        }
        try {
            Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    public static boolean isLong(String s) {
        try {
            Long.parseLong(s);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    public static boolean isDouble(String s) {
        if (StringKit.isBlank(s)) {
            return false;
        }
        try {
            Double.parseDouble(s);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return s.contains(".");
    }

    public static boolean isPrimes(int n) {
        Assert.isTrue(n > 1, "The number must be > 1", new Object[0]);
        int i = 2;
        while ((double)i <= Math.sqrt(n)) {
            if (n % i == 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static int[] generateRandomNumber(int begin, int end, int size) {
        return MathKit.generateRandomNumber(begin, end, size, ArrayKit.range(begin, end));
    }

    public static int[] generateRandomNumber(int begin, int end, int size, int[] seed) {
        if (begin > end) {
            int temp = begin;
            begin = end;
            end = temp;
        }
        Assert.isTrue(end - begin >= size, "Size is larger than range between begin and end!", new Object[0]);
        Assert.isTrue(seed.length >= size, "Size is larger than seed size!", new Object[0]);
        int[] ranArr = new int[size];
        for (int i = 0; i < size; ++i) {
            int j = RandomKit.randomInt(seed.length - i);
            ranArr[i] = seed[j];
            seed[j] = seed[seed.length - 1 - i];
        }
        return ranArr;
    }

    public static Integer[] generateBySet(int begin, int end, int size) {
        if (begin > end) {
            int temp = begin;
            begin = end;
            end = temp;
        }
        if (end - begin < size) {
            throw new InternalException("Size is larger than range between begin and end!");
        }
        HashSet<Integer> set = new HashSet<Integer>(size, 1.0f);
        while (set.size() < size) {
            set.add(begin + RandomKit.randomInt(end - begin));
        }
        return set.toArray(new Integer[0]);
    }

    public static int[] range(int stop) {
        return MathKit.range(0, stop);
    }

    public static int[] range(int start, int stop) {
        return MathKit.range(start, stop, 1);
    }

    public static int[] range(int start, int stop, int step) {
        if (start < stop) {
            step = Math.abs(step);
        } else if (start > stop) {
            step = -Math.abs(step);
        } else {
            return new int[]{start};
        }
        int size = Math.abs((stop - start) / step) + 1;
        int[] values = new int[size];
        int index = 0;
        int i = start;
        while (step > 0 ? i <= stop : i >= stop) {
            values[index] = i;
            ++index;
            i += step;
        }
        return values;
    }

    public static Collection<Integer> appendRange(int start, int stop, Collection<Integer> values) {
        return MathKit.appendRange(start, stop, 1, values);
    }

    public static Collection<Integer> appendRange(int start, int stop, int step, Collection<Integer> values) {
        if (start < stop) {
            step = Math.abs(step);
        } else if (start > stop) {
            step = -Math.abs(step);
        } else {
            values.add(start);
            return values;
        }
        int i = start;
        while (step > 0 ? i <= stop : i >= stop) {
            values.add(i);
            i += step;
        }
        return values;
    }

    public static BigInteger factorial(BigInteger n) {
        if (n.equals(BigInteger.ZERO)) {
            return BigInteger.ONE;
        }
        return MathKit.factorial(n, BigInteger.ZERO);
    }

    public static BigInteger factorial(BigInteger start, BigInteger end) {
        if (start.compareTo(BigInteger.ZERO) < 0 || end.compareTo(BigInteger.ZERO) < 0) {
            throw new IllegalArgumentException(StringKit.format((CharSequence)"Factorial start and end both must be > 0, but got start={}, end={}", start, end));
        }
        if (start.equals(BigInteger.ZERO)) {
            start = BigInteger.ONE;
        }
        if (end.compareTo(BigInteger.ONE) < 0) {
            end = BigInteger.ONE;
        }
        BigInteger result = start;
        end = end.add(BigInteger.ONE);
        while (start.compareTo(end) > 0) {
            start = start.subtract(BigInteger.ONE);
            result = result.multiply(start);
        }
        return result;
    }

    public static long factorial(long start, long end) {
        if (start < end) {
            return 0L;
        }
        if (start == end) {
            return 1L;
        }
        return start * MathKit.factorial(start - 1L, end);
    }

    public static long factorial(long n) {
        return MathKit.factorial(n, 1L);
    }

    public static long sqrt(long x) {
        long y = 0L;
        for (long b = 0x4000000000000000L; b > 0L; b >>= 2) {
            if (x >= y + b) {
                x -= y + b;
                y >>= 1;
                y += b;
                continue;
            }
            y >>= 1;
        }
        return y;
    }

    public static int processMultiple(int selectNum, int minNum) {
        int result = MathKit.mathSubnode(selectNum, minNum) / MathKit.mathNode(selectNum - minNum);
        return result;
    }

    public static int divisor(int m, int n) {
        while (m % n != 0) {
            int temp = m % n;
            m = n;
            n = temp;
        }
        return n;
    }

    public static int multiple(int m, int n) {
        return m * n / MathKit.divisor(m, n);
    }

    public static String getBinaryString(Number number) {
        if (number instanceof Long) {
            return Long.toBinaryString((Long)number);
        }
        if (number instanceof Integer) {
            return Integer.toBinaryString((Integer)number);
        }
        return Long.toBinaryString(number.longValue());
    }

    public static int binaryToInt(String binaryStr) {
        return Integer.parseInt(binaryStr, 2);
    }

    public static long binaryToLong(String binaryStr) {
        return Long.parseLong(binaryStr, 2);
    }

    public static int compare(char x, char y) {
        return x - y;
    }

    public static int compare(double x, double y) {
        return Double.compare(x, y);
    }

    public static int compare(int x, int y) {
        if (x == y) {
            return 0;
        }
        if (x < y) {
            return -1;
        }
        return 1;
    }

    public static int compare(long x, long y) {
        if (x == y) {
            return 0;
        }
        if (x < y) {
            return -1;
        }
        return 1;
    }

    public static int compare(short x, short y) {
        if (x == y) {
            return 0;
        }
        if (x < y) {
            return -1;
        }
        return 1;
    }

    public static int compare(byte x, byte y) {
        return x - y;
    }

    public static boolean isGreater(BigDecimal bigNum1, BigDecimal bigNum2) {
        Assert.notNull(bigNum1);
        Assert.notNull(bigNum2);
        return bigNum1.compareTo(bigNum2) > 0;
    }

    public static boolean isGreaterOrEqual(BigDecimal bigNum1, BigDecimal bigNum2) {
        Assert.notNull(bigNum1);
        Assert.notNull(bigNum2);
        return bigNum1.compareTo(bigNum2) >= 0;
    }

    public static boolean isLess(BigDecimal bigNum1, BigDecimal bigNum2) {
        Assert.notNull(bigNum1);
        Assert.notNull(bigNum2);
        return bigNum1.compareTo(bigNum2) < 0;
    }

    public static boolean isLessOrEqual(BigDecimal bigNum1, BigDecimal bigNum2) {
        Assert.notNull(bigNum1);
        Assert.notNull(bigNum2);
        return bigNum1.compareTo(bigNum2) <= 0;
    }

    public static boolean isIn(BigDecimal value, BigDecimal minInclude, BigDecimal maxInclude) {
        Assert.notNull(value);
        Assert.notNull(minInclude);
        Assert.notNull(maxInclude);
        return MathKit.isGreaterOrEqual(value, minInclude) && MathKit.isLessOrEqual(value, maxInclude);
    }

    public static boolean equals(BigDecimal bigNum1, BigDecimal bigNum2) {
        return ObjectKit.equals(bigNum1, bigNum2);
    }

    public static boolean equals(double num1, double num2) {
        return Double.doubleToLongBits(num1) == Double.doubleToLongBits(num2);
    }

    public static boolean equals(float num1, float num2) {
        return Float.floatToIntBits(num1) == Float.floatToIntBits(num2);
    }

    public static boolean equals(long num1, long num2) {
        return num1 == num2;
    }

    public static boolean equals(char c1, char c2, boolean ignoreCase) {
        return CharsKit.equals(c1, c2, ignoreCase);
    }

    public static <T extends Comparable<? super T>> T min(T[] numberArray) {
        return (T)ArrayKit.min(numberArray);
    }

    public static long min(long ... args) {
        return ArrayKit.min(args);
    }

    public static int min(int ... args) {
        return ArrayKit.min(args);
    }

    public static short min(short ... args) {
        return ArrayKit.min(args);
    }

    public static double min(double ... args) {
        return ArrayKit.min(args);
    }

    public static float min(float ... args) {
        return ArrayKit.min(args);
    }

    public static <T extends Comparable<? super T>> T max(T[] args) {
        return (T)ArrayKit.max(args);
    }

    public static long max(long ... args) {
        return ArrayKit.max(args);
    }

    public static int max(int ... args) {
        return ArrayKit.max(args);
    }

    public static short max(short ... args) {
        return ArrayKit.max(args);
    }

    public static double max(double ... args) {
        return ArrayKit.max(args);
    }

    public static float max(float ... args) {
        return ArrayKit.max(args);
    }

    public static String toString(Number number, String defaultValue) {
        return null == number ? defaultValue : MathKit.toString(number);
    }

    public static String toString(Number number) {
        return MathKit.toString(number, true);
    }

    public static String toString(Number number, boolean isStripTrailingZeros) {
        Assert.notNull(number, "Number is null !", new Object[0]);
        if (number instanceof BigDecimal) {
            return MathKit.toString((BigDecimal)number, isStripTrailingZeros);
        }
        Assert.isTrue(MathKit.isValidNumber(number), "Number is non-finite!", new Object[0]);
        String string = number.toString();
        if (isStripTrailingZeros && string.indexOf(46) > 0 && string.indexOf(101) < 0 && string.indexOf(69) < 0) {
            while (string.endsWith("0")) {
                string = string.substring(0, string.length() - 1);
            }
            if (string.endsWith(".")) {
                string = string.substring(0, string.length() - 1);
            }
        }
        return string;
    }

    public static String toString(BigDecimal bigDecimal) {
        return MathKit.toString(bigDecimal, true);
    }

    public static String toString(BigDecimal bigDecimal, boolean isStripTrailingZeros) {
        Assert.notNull(bigDecimal, "BigDecimal is null !", new Object[0]);
        if (isStripTrailingZeros) {
            bigDecimal = bigDecimal.stripTrailingZeros();
        }
        return bigDecimal.toPlainString();
    }

    public static BigDecimal toBigDecimal(Number number) {
        if (null == number) {
            return BigDecimal.ZERO;
        }
        if (number instanceof BigDecimal) {
            return (BigDecimal)number;
        }
        if (number instanceof Long) {
            return new BigDecimal((Long)number);
        }
        if (number instanceof Integer) {
            return new BigDecimal((Integer)number);
        }
        if (number instanceof BigInteger) {
            return new BigDecimal((BigInteger)number);
        }
        return MathKit.toBigDecimal(number.toString());
    }

    public static BigDecimal toBigDecimal(String number) {
        if (StringKit.isBlank(number)) {
            return BigDecimal.ZERO;
        }
        try {
            Number parseNumber = MathKit.parseNumber(number);
            if (parseNumber instanceof BigDecimal) {
                return (BigDecimal)parseNumber;
            }
            return new BigDecimal(parseNumber.toString());
        }
        catch (Exception exception) {
            return new BigDecimal(number);
        }
    }

    public static BigInteger toBigInteger(Number number) {
        if (null == number) {
            return BigInteger.ZERO;
        }
        if (number instanceof BigInteger) {
            return (BigInteger)number;
        }
        if (number instanceof Long) {
            return BigInteger.valueOf((Long)number);
        }
        return MathKit.toBigInteger(number.longValue());
    }

    public static BigInteger toBigInteger(String number) {
        return null == number ? BigInteger.ZERO : new BigInteger(number);
    }

    public static int count(int total, int part) {
        return total % part == 0 ? total / part : total / part + 1;
    }

    public static BigDecimal null2Zero(BigDecimal decimal) {
        return null == decimal ? BigDecimal.ZERO : decimal;
    }

    public static int zero2One(int value) {
        return 0 == value ? 1 : value;
    }

    public static BigInteger newBigInteger(String text) {
        if (null == (text = StringKit.trimToNull(text))) {
            return null;
        }
        int pos = 0;
        int radix = 10;
        boolean negate = false;
        if (text.startsWith("-")) {
            negate = true;
            pos = 1;
        }
        if (text.startsWith("0x", pos) || text.startsWith("0X", pos)) {
            radix = 16;
            pos += 2;
        } else if (text.startsWith("#", pos)) {
            radix = 16;
            ++pos;
        } else if (text.startsWith("0", pos) && text.length() > pos + 1) {
            radix = 8;
            ++pos;
        }
        if (pos > 0) {
            text = text.substring(pos);
        }
        BigInteger value = new BigInteger(text, radix);
        return negate ? value.negate() : value;
    }

    public static boolean isBeside(long number1, long number2) {
        return Math.abs(number1 - number2) == 1L;
    }

    public static boolean isBeside(int number1, int number2) {
        return Math.abs(number1 - number2) == 1;
    }

    public static int partValue(int total, int partCount) {
        return MathKit.partValue(total, partCount, true);
    }

    public static int partValue(int total, int partCount, boolean isPlusOneWhenHasRem) {
        int partValue = total / partCount;
        if (isPlusOneWhenHasRem && total % partCount > 0) {
            ++partValue;
        }
        return partValue;
    }

    public static BigDecimal pow(Number number, int n) {
        return MathKit.pow(MathKit.toBigDecimal(number), n);
    }

    public static BigDecimal pow(BigDecimal number, int n) {
        return number.pow(n);
    }

    public static int parseInt(String number) throws NumberFormatException {
        if (StringKit.isBlank(number)) {
            return 0;
        }
        if (StringKit.containsIgnoreCase(number, "E")) {
            throw new NumberFormatException(StringKit.format((CharSequence)"Unsupported int format: [{}]", number));
        }
        if (StringKit.startWithIgnoreCase(number, "0x")) {
            return Integer.parseInt(number.substring(2), 16);
        }
        try {
            return Integer.parseInt(number);
        }
        catch (NumberFormatException e) {
            return MathKit.parseNumber(number).intValue();
        }
    }

    public static long parseLong(String number) {
        if (StringKit.isBlank(number)) {
            return 0L;
        }
        if (number.startsWith("0x")) {
            return Long.parseLong(number.substring(2), 16);
        }
        try {
            return Long.parseLong(number);
        }
        catch (NumberFormatException e) {
            return MathKit.parseNumber(number).longValue();
        }
    }

    public static float parseFloat(String number) {
        if (StringKit.isBlank(number)) {
            return 0.0f;
        }
        try {
            return Float.parseFloat(number);
        }
        catch (NumberFormatException e) {
            return MathKit.parseNumber(number).floatValue();
        }
    }

    public static double parseDouble(String number) {
        if (StringKit.isBlank(number)) {
            return 0.0;
        }
        try {
            return Double.parseDouble(number);
        }
        catch (NumberFormatException e) {
            return MathKit.parseNumber(number).doubleValue();
        }
    }

    public static Number parseNumber(String number) throws NumberFormatException {
        if (StringKit.startWithIgnoreCase(number, "0x")) {
            return Long.parseLong(number.substring(2), 16);
        }
        try {
            NumberFormat format = NumberFormat.getInstance();
            if (format instanceof DecimalFormat) {
                ((DecimalFormat)format).setParseBigDecimal(true);
            }
            return format.parse(number);
        }
        catch (ParseException e) {
            NumberFormatException nfe = new NumberFormatException(e.getMessage());
            nfe.initCause(e);
            throw nfe;
        }
    }

    public static byte[] toBytes(int value) {
        byte[] result = new byte[]{(byte)(value >> 24), (byte)(value >> 16), (byte)(value >> 8), (byte)value};
        return result;
    }

    public static int toInt(byte[] bytes) {
        return (bytes[0] & 0xFF) << 24 | (bytes[1] & 0xFF) << 16 | (bytes[2] & 0xFF) << 8 | bytes[3] & 0xFF;
    }

    public static byte[] toUnsignedByteArray(BigInteger value) {
        byte[] bytes = value.toByteArray();
        if (bytes[0] == 0) {
            byte[] tmp = new byte[bytes.length - 1];
            System.arraycopy(bytes, 1, tmp, 0, tmp.length);
            return tmp;
        }
        return bytes;
    }

    public static byte[] toUnsignedByteArray(int length, BigInteger value) {
        byte[] bytes = value.toByteArray();
        if (bytes.length == length) {
            return bytes;
        }
        int start = bytes[0] == 0 ? 1 : 0;
        int count = bytes.length - start;
        if (count > length) {
            throw new IllegalArgumentException("standard length exceeded for value");
        }
        byte[] tmp = new byte[length];
        System.arraycopy(bytes, start, tmp, tmp.length - count, count);
        return tmp;
    }

    public static BigInteger fromUnsignedByteArray(byte[] buf) {
        return new BigInteger(1, buf);
    }

    public static BigInteger fromUnsignedByteArray(byte[] buf, int off, int length) {
        byte[] mag = buf;
        if (off != 0 || length != buf.length) {
            mag = new byte[length];
            System.arraycopy(buf, off, mag, 0, length);
        }
        return new BigInteger(1, mag);
    }

    public static boolean isValid(double number) {
        return false == (Double.isNaN(number) || Double.isInfinite(number));
    }

    public static boolean isValid(float number) {
        return false == (Float.isNaN(number) || Float.isInfinite(number));
    }

    public static double calculate(String expression) {
        return Formula.conversion(expression);
    }

    private static int mathSubnode(int selectNum, int minNum) {
        if (selectNum == minNum) {
            return 1;
        }
        return selectNum * MathKit.mathSubnode(selectNum - 1, minNum);
    }

    private static int mathNode(int selectNum) {
        if (selectNum == 0) {
            return 1;
        }
        return selectNum * MathKit.mathNode(selectNum - 1);
    }

    public static String addZero(Number numObj, int length) {
        NumberFormat nf = NumberFormat.getInstance();
        nf.setGroupingUsed(false);
        nf.setMaximumIntegerDigits(length);
        nf.setMinimumIntegerDigits(length);
        return nf.format(numObj);
    }

    public static int toInt(String text) {
        return MathKit.toInt(text, 0);
    }

    public static int toInt(String text, int defaultValue) {
        if (null == text) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(text);
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    public static long toLong(String text) {
        return MathKit.toLong(text, 0L);
    }

    public static long toLong(String text, long defaultValue) {
        if (null == text) {
            return defaultValue;
        }
        try {
            return Long.parseLong(text);
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    public static float toFloat(String text) {
        return MathKit.toFloat(text, 0.0f);
    }

    public static float toFloat(String text, float defaultValue) {
        if (null == text) {
            return defaultValue;
        }
        try {
            return Float.parseFloat(text);
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    public static double toDouble(String text) {
        return MathKit.toDouble(text, 0.0);
    }

    public static double toDouble(String text, double defaultValue) {
        if (null == text) {
            return defaultValue;
        }
        try {
            return Double.parseDouble(text);
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    public static double toDouble(BigDecimal value) {
        return MathKit.toDouble(value, 0.0);
    }

    public static double toDouble(BigDecimal value, double defaultValue) {
        return null == value ? defaultValue : value.doubleValue();
    }

    public static double toDouble(Number value) {
        if (value instanceof Float) {
            return Double.parseDouble(value.toString());
        }
        return value.doubleValue();
    }

    public static byte toByte(String text) {
        return MathKit.toByte(text, (byte)0);
    }

    public static byte toByte(String text, byte defaultValue) {
        if (null == text) {
            return defaultValue;
        }
        try {
            return Byte.parseByte(text);
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    public static short toShort(String text) {
        return MathKit.toShort(text, (short)0);
    }

    public static short toShort(String text, short defaultValue) {
        if (null == text) {
            return defaultValue;
        }
        try {
            return Short.parseShort(text);
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    public static BigDecimal toScaledBigDecimal(BigDecimal value) {
        return MathKit.toScaledBigDecimal(value, (int)Normal.INTEGER_TWO, RoundingMode.HALF_EVEN);
    }

    public static BigDecimal toScaledBigDecimal(BigDecimal value, int scale, RoundingMode roundingMode) {
        if (null == value) {
            return BigDecimal.ZERO;
        }
        return value.setScale(scale, null == roundingMode ? RoundingMode.HALF_EVEN : roundingMode);
    }

    public static BigDecimal toScaledBigDecimal(Float value) {
        return MathKit.toScaledBigDecimal(value, (int)Normal.INTEGER_TWO, RoundingMode.HALF_EVEN);
    }

    public static BigDecimal toScaledBigDecimal(Float value, int scale, RoundingMode roundingMode) {
        if (null == value) {
            return BigDecimal.ZERO;
        }
        return MathKit.toScaledBigDecimal(BigDecimal.valueOf(value.floatValue()), scale, roundingMode);
    }

    public static BigDecimal toScaledBigDecimal(Double value) {
        return MathKit.toScaledBigDecimal(value, (int)Normal.INTEGER_TWO, RoundingMode.HALF_EVEN);
    }

    public static BigDecimal toScaledBigDecimal(Double value, int scale, RoundingMode roundingMode) {
        if (null == value) {
            return BigDecimal.ZERO;
        }
        return MathKit.toScaledBigDecimal(BigDecimal.valueOf(value), scale, roundingMode);
    }

    public static BigDecimal toScaledBigDecimal(String value) {
        return MathKit.toScaledBigDecimal(value, (int)Normal.INTEGER_TWO, RoundingMode.HALF_EVEN);
    }

    public static BigDecimal toScaledBigDecimal(String value, int scale, RoundingMode roundingMode) {
        if (null == value) {
            return BigDecimal.ZERO;
        }
        return MathKit.toScaledBigDecimal(MathKit.createBigDecimal(value), scale, roundingMode);
    }

    public static BigDecimal createBigDecimal(String text) {
        if (null == text) {
            return null;
        }
        if (StringKit.isBlank(text)) {
            throw new NumberFormatException("A blank string is not a valid number");
        }
        if (text.trim().startsWith("--")) {
            throw new NumberFormatException(text + " is not a valid number.");
        }
        return new BigDecimal(text);
    }

    public static long arrangeCount(int n, int m) {
        return Arrange.count(n, m);
    }

    public static long arrangeCount(int n) {
        return Arrange.count(n);
    }

    public static List<String[]> arrangeSelect(String[] datas, int m) {
        return new Arrange(datas).select(m);
    }

    public static List<String[]> arrangeSelect(String[] datas) {
        return new Arrange(datas).select();
    }

    public static long combineCount(int n, int m) {
        return Combine.count(n, m);
    }

    public static List<String[]> combineSelect(String[] datas, int m) {
        return new Combine(datas).select(m);
    }

    public static MathKit ofBytes(long bytes) {
        return new MathKit(bytes);
    }

    public static MathKit ofKilobytes(long kilobytes) {
        return new MathKit(Math.multiplyExact(kilobytes, 1024L));
    }

    public static MathKit ofMegabytes(long megabytes) {
        return new MathKit(Math.multiplyExact(megabytes, 0x100000L));
    }

    public static MathKit ofGigabytes(long gigabytes) {
        return new MathKit(Math.multiplyExact(gigabytes, 0x40000000L));
    }

    public static MathKit ofTerabytes(long terabytes) {
        return new MathKit(Math.multiplyExact(terabytes, 0x10000000000L));
    }

    public static String format(long size) {
        if (size <= 0L) {
            return "0";
        }
        int digitGroups = Math.min(Normal.CAPACITY_NAMES.length - 1, (int)(Math.log10(size) / Math.log10(1024.0)));
        return new DecimalFormat("#,##0.##").format((double)size / Math.pow(1024.0, digitGroups)) + " " + Normal.CAPACITY_NAMES[digitGroups];
    }

    public static long parse(String text) {
        return MathKit.parse(text, null).toBytes();
    }

    public static MathKit parse(CharSequence text) {
        return MathKit.parse(text, null);
    }

    public static MathKit parse(CharSequence text, String defaultUnit) {
        Assert.notNull(text, "Text must not be null", new Object[0]);
        try {
            Matcher matcher = Pattern.compile("^([+\\-]?\\d+)([a-zA-Z]{0,2})$").matcher(text);
            Assert.state(matcher.matches(), "Does not match data size pattern", new Object[0]);
            String unit = MathKit.determineDataUnit(matcher.group(2), defaultUnit);
            long amount = Long.parseLong(matcher.group(1));
            return new MathKit(Math.multiplyExact(amount, bytes));
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("'" + String.valueOf(text) + "' is not a valid data size", ex);
        }
    }

    private static String determineDataUnit(String suffix, String defaultUnit) {
        String defaultUnitToUse = null != defaultUnit ? defaultUnit : Normal.CAPACITY_NAMES[0];
        return StringKit.isNotEmpty(suffix) ? MathKit.getCapacity(suffix) : defaultUnitToUse;
    }

    public static boolean isValidNumber(Number number) {
        if (null == number) {
            return false;
        }
        if (number instanceof Double) {
            return false == ((Double)number).isInfinite() && false == ((Double)number).isNaN();
        }
        if (number instanceof Float) {
            return false == ((Float)number).isInfinite() && false == ((Float)number).isNaN();
        }
        return true;
    }

    public static boolean isBetween(int min, int max, int value) {
        return value >= min && value <= max;
    }

    public static boolean isBetween(long min, long max, long value) {
        return value >= min && value <= max;
    }

    public static boolean isBetween(float min, float max, float value) {
        return value >= min && value <= max;
    }

    public static boolean isBetween(double min, double max, double value) {
        return value >= min && value <= max;
    }

    public static String getCapacity(String suffix) {
        for (String candidate : Normal.CAPACITY_NAMES) {
            if (!StringKit.startWithIgnoreCase(candidate, suffix)) continue;
            return candidate;
        }
        return suffix;
    }

    public static boolean isOdd(int num) {
        return (num & 1) == 1;
    }

    public static boolean isEven(int num) {
        return false == MathKit.isOdd(num);
    }

    public static long yuanToCent(double yuan) {
        return new Money(yuan).getCent();
    }

    public static double centToYuan(long cent) {
        long yuan = cent / 100L;
        int centPart = (int)(cent % 100L);
        return new Money(yuan, centPart).getAmount().doubleValue();
    }

    public boolean isNegative() {
        return bytes < 0L;
    }

    public long toBytes() {
        return bytes;
    }

    public long toKilobytes() {
        return bytes / 1024L;
    }

    public long toMegabytes() {
        return bytes / 0x100000L;
    }

    public long toGigabytes() {
        return bytes / 0x40000000L;
    }

    public long toTerabytes() {
        return bytes / 0x10000000000L;
    }
}

