/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.toolkit;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.Authenticator;
import java.net.DatagramSocket;
import java.net.HttpCookie;
import java.net.IDN;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import org.aoju.bus.core.collection.EnumerationIterator;
import org.aoju.bus.core.convert.Convert;
import org.aoju.bus.core.exception.InternalException;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.lang.RegEx;
import org.aoju.bus.core.net.MaskBit;
import org.aoju.bus.core.toolkit.CollKit;
import org.aoju.bus.core.toolkit.IoKit;
import org.aoju.bus.core.toolkit.MapKit;
import org.aoju.bus.core.toolkit.RandomKit;
import org.aoju.bus.core.toolkit.StringKit;

public class NetKit {
    public static final int PORT_RANGE_MIN = 1024;
    public static final int PORT_RANGE_MAX = 65535;

    public static BigInteger ipv6ToBigInteger(String ipv6Str) {
        try {
            InetAddress address = InetAddress.getByName(ipv6Str);
            if (address instanceof Inet6Address) {
                return new BigInteger(1, address.getAddress());
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return null;
    }

    public static String bigIntegerToIPv6(BigInteger bigInteger) {
        try {
            return InetAddress.getByAddress(bigInteger.toByteArray()).toString().substring(1);
        }
        catch (UnknownHostException ignore) {
            return null;
        }
    }

    public static boolean isUsableLocalPort(int port) {
        if (!NetKit.isValidPort(port)) {
            return false;
        }
        try (ServerSocket ss = new ServerSocket(port);){
            ss.setReuseAddress(true);
        }
        catch (IOException ignored) {
            return false;
        }
        try (DatagramSocket ds = new DatagramSocket(port);){
            ds.setReuseAddress(true);
        }
        catch (IOException ignored) {
            return false;
        }
        return true;
    }

    public static boolean isValidPort(int port) {
        return port >= 0 && port <= 65535;
    }

    public static int getUsableLocalPort() {
        return NetKit.getUsableLocalPort(1024);
    }

    public static int getUsableLocalPort(int minPort) {
        return NetKit.getUsableLocalPort(minPort, 65535);
    }

    public static int getUsableLocalPort(int minPort, int maxPort) {
        int maxPortExclude = maxPort + 1;
        for (int i = minPort; i < maxPortExclude; ++i) {
            int randomPort = RandomKit.randomInt(minPort, maxPortExclude);
            if (!NetKit.isUsableLocalPort(randomPort)) continue;
            return randomPort;
        }
        throw new InternalException("Could not find an available port in the range [{}, {}] after {} attempts", minPort, maxPort, maxPort - minPort);
    }

    public static TreeSet<Integer> getUsableLocalPorts(int numRequested, int minPort, int maxPort) {
        TreeSet<Integer> availablePorts = new TreeSet<Integer>();
        int attemptCount = 0;
        while (++attemptCount <= numRequested + 100 && availablePorts.size() < numRequested) {
            availablePorts.add(NetKit.getUsableLocalPort(minPort, maxPort));
        }
        if (availablePorts.size() != numRequested) {
            throw new InternalException("Could not find {} available  ports in the range [{}, {}]", numRequested, minPort, maxPort);
        }
        return availablePorts;
    }

    public static String toAbsoluteUrl(String absoluteBasePath, String relativePath) {
        try {
            URL absoluteUrl = new URL(absoluteBasePath);
            return new URL(absoluteUrl, relativePath).toString();
        }
        catch (Exception e) {
            throw new InternalException(e, "To absolute url [{}] base [{}] error!", relativePath, absoluteBasePath);
        }
    }

    public static String hideIpPart(String ip) {
        return StringKit.builder(ip.length()).append(ip, 0, ip.lastIndexOf(".") + 1).append("*").toString();
    }

    public static String hideIpPart(long ip) {
        return NetKit.hideIpPart(NetKit.longToIpv4(ip));
    }

    public static InetSocketAddress buildInetSocketAddress(String host, int defaultPort) {
        int port;
        String destHost;
        int index;
        if (StringKit.isBlank(host)) {
            host = "127.0.0.1";
        }
        if ((index = host.indexOf(":")) != -1) {
            destHost = host.substring(0, index);
            port = Integer.parseInt(host.substring(index + 1));
        } else {
            destHost = host;
            port = defaultPort;
        }
        return new InetSocketAddress(destHost, port);
    }

    public static String getIpByHost(String hostName) {
        try {
            return InetAddress.getByName(hostName).getHostAddress();
        }
        catch (UnknownHostException e) {
            return hostName;
        }
    }

    public static NetworkInterface getNetworkInterface(String name) {
        Enumeration<NetworkInterface> networkInterfaces;
        try {
            networkInterfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            return null;
        }
        while (networkInterfaces.hasMoreElements()) {
            NetworkInterface netInterface = networkInterfaces.nextElement();
            if (null == netInterface || !name.equals(netInterface.getName())) continue;
            return netInterface;
        }
        return null;
    }

    public static Collection<NetworkInterface> getNetworkInterfaces() {
        Enumeration<NetworkInterface> networkInterfaces;
        try {
            networkInterfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            return null;
        }
        return CollKit.addAll(new ArrayList(), networkInterfaces);
    }

    public static LinkedHashSet<String> localIpv4s() {
        return NetKit.toIpList(NetKit.localAddressList(t -> t instanceof Inet4Address));
    }

    public static LinkedHashSet<String> localIpv6s() {
        return NetKit.toIpList(NetKit.localAddressList(t -> t instanceof Inet6Address));
    }

    public static LinkedHashSet<String> toIpList(Set<InetAddress> addressList) {
        LinkedHashSet<String> ipSet = new LinkedHashSet<String>();
        for (InetAddress address : addressList) {
            ipSet.add(address.getHostAddress());
        }
        return ipSet;
    }

    public static LinkedHashSet<String> localIps() {
        return NetKit.toIpList(NetKit.localAddressList(null));
    }

    public static LinkedHashSet<InetAddress> localAddressList(Predicate<InetAddress> addressPredicate) {
        return NetKit.localAddressList(null, addressPredicate);
    }

    public static LinkedHashSet<InetAddress> localAddressList(Predicate<NetworkInterface> networkInterfaceFilter, Predicate<InetAddress> addressPredicate) {
        Enumeration<NetworkInterface> networkInterfaces;
        try {
            networkInterfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            throw new InternalException(e);
        }
        if (networkInterfaces == null) {
            throw new InternalException("Get network interface error!");
        }
        LinkedHashSet<InetAddress> ipSet = new LinkedHashSet<InetAddress>();
        while (networkInterfaces.hasMoreElements()) {
            NetworkInterface networkInterface = networkInterfaces.nextElement();
            if (networkInterfaceFilter != null && !networkInterfaceFilter.test(networkInterface)) continue;
            Enumeration<InetAddress> inetAddresses = networkInterface.getInetAddresses();
            while (inetAddresses.hasMoreElements()) {
                InetAddress inetAddress = inetAddresses.nextElement();
                if (inetAddress == null || null != addressPredicate && !addressPredicate.test(inetAddress)) continue;
                ipSet.add(inetAddress);
            }
        }
        return ipSet;
    }

    public static String getLocalhostString() {
        InetAddress localhost = NetKit.getLocalhost();
        if (null != localhost) {
            return localhost.getHostAddress();
        }
        return null;
    }

    public static InetAddress getLocalhost() {
        LinkedHashSet<InetAddress> localAddressList = NetKit.localAddressList(address -> false == address.isLoopbackAddress() && address instanceof Inet4Address);
        if (CollKit.isNotEmpty(localAddressList)) {
            InetAddress address2 = null;
            for (InetAddress inetAddress : localAddressList) {
                if (!inetAddress.isSiteLocalAddress()) {
                    return inetAddress;
                }
                if (null != address2) continue;
                address2 = inetAddress;
            }
            if (null != address2) {
                return address2;
            }
        }
        try {
            return InetAddress.getLocalHost();
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
    }

    public static String getLocalMacAddress() {
        return NetKit.getMacAddress(NetKit.getLocalhost());
    }

    public static String getMacAddress(InetAddress inetAddress) {
        return NetKit.getMacAddress(inetAddress, "-");
    }

    public static String getMacAddress(InetAddress inetAddress, String separator) {
        if (null == inetAddress) {
            return null;
        }
        byte[] mac = NetKit.getHardwareAddress(inetAddress);
        if (null != mac) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < mac.length; ++i) {
                String s;
                if (i != 0) {
                    sb.append(separator);
                }
                sb.append((String)((s = Integer.toHexString(mac[i] & 0xFF)).length() == 1 ? "0" + s : s));
            }
            return sb.toString();
        }
        return null;
    }

    public static byte[] getHardwareAddress(InetAddress inetAddress) {
        if (null == inetAddress) {
            return null;
        }
        try {
            NetworkInterface networkInterface = NetworkInterface.getByInetAddress(inetAddress);
            if (null != networkInterface) {
                return networkInterface.getHardwareAddress();
            }
        }
        catch (SocketException e) {
            throw new InternalException(e);
        }
        return null;
    }

    public static byte[] getLocalHardwareAddress() {
        return NetKit.getHardwareAddress(NetKit.getLocalhost());
    }

    public static String getLocalHostName() {
        InetAddress localhost = NetKit.getLocalhost();
        if (null != localhost) {
            String name = localhost.getHostName();
            if (StringKit.isEmpty(name)) {
                name = localhost.getHostAddress();
            }
            return name;
        }
        return null;
    }

    public static InetSocketAddress createAddress(String host, int port) {
        if (StringKit.isBlank(host)) {
            return new InetSocketAddress(port);
        }
        return new InetSocketAddress(host, port);
    }

    public static void netCat(String host, int port, boolean isBlock, ByteBuffer data) throws InternalException {
        try (SocketChannel channel = SocketChannel.open(NetKit.createAddress(host, port));){
            channel.configureBlocking(isBlock);
            channel.write(data);
        }
        catch (IOException e) {
            throw new InternalException(e);
        }
    }

    public static void netCat(String host, int port, byte[] data) throws InternalException {
        OutputStream out = null;
        try (Socket socket = new Socket(host, port);){
            out = socket.getOutputStream();
            out.write(data);
            out.flush();
        }
        catch (IOException e) {
            try {
                throw new InternalException(e);
            }
            catch (Throwable throwable) {
                IoKit.close(out);
                throw throwable;
            }
        }
        IoKit.close(out);
    }

    public static boolean isInRange(String ip, String cidr) {
        int maskSplitMarkIndex = cidr.lastIndexOf("/");
        if (maskSplitMarkIndex < 0) {
            throw new IllegalArgumentException("Invalid cidr: " + cidr);
        }
        long mask = -1L << 32 - Integer.parseInt(cidr.substring(maskSplitMarkIndex + 1));
        long cidrIpAddr = NetKit.ipv4ToLong(cidr.substring(0, maskSplitMarkIndex));
        return (NetKit.ipv4ToLong(ip) & mask) == (cidrIpAddr & mask);
    }

    public static String idnToASCII(String unicode) {
        return IDN.toASCII(unicode);
    }

    public static String getMultistageReverseProxyIp(String ip) {
        if (ip != null && ip.indexOf(",") > 0) {
            String[] ips;
            for (String subIp : ips = ip.trim().split(",")) {
                if (NetKit.isUnknown(subIp)) continue;
                ip = subIp;
                break;
            }
        }
        return ip;
    }

    public static boolean isUnknown(String checkString) {
        return StringKit.isBlank(checkString) || "unknown".equalsIgnoreCase(checkString);
    }

    public static boolean ping(String ip) {
        return NetKit.ping(ip, 200);
    }

    public static boolean ping(String ip, int timeout) {
        try {
            return InetAddress.getByName(ip).isReachable(timeout);
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static List<HttpCookie> parseCookies(String cookieStr) {
        if (StringKit.isBlank(cookieStr)) {
            return Collections.emptyList();
        }
        return HttpCookie.parse(cookieStr);
    }

    public static boolean isOpen(InetSocketAddress address, int timeout) {
        boolean bl;
        Socket sc = new Socket();
        try {
            sc.connect(address, timeout);
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    sc.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                return false;
            }
        }
        sc.close();
        return bl;
    }

    public static void setGlobalAuthenticator(Authenticator authenticator) {
        Authenticator.setDefault(authenticator);
    }

    public static List<String> getDnsInfo(String hostName, String ... attrNames) {
        String uri = StringKit.addPrefixIfNot(hostName, "dns:");
        Attributes attributes = NetKit.getAttributes(uri, attrNames);
        ArrayList<String> infos = new ArrayList<String>();
        for (Attribute attribute : new EnumerationIterator<Attribute>(attributes.getAll())) {
            try {
                infos.add((String)attribute.get());
            }
            catch (NamingException namingException) {}
        }
        return infos;
    }

    public static String formatIpBlock(String ip, String mask) {
        return ip + "/" + NetKit.getMaskBitByMask(mask);
    }

    public static List<String> list(String ipRange, boolean isAll) {
        if (ipRange.contains("-")) {
            String[] range = StringKit.splitToArray((CharSequence)ipRange, "-");
            return NetKit.list(range[0], range[1]);
        }
        if (ipRange.contains("/")) {
            String[] param = StringKit.splitToArray((CharSequence)ipRange, "/");
            return NetKit.list(param[0], Integer.parseInt(param[1]), isAll);
        }
        return CollKit.of(ipRange);
    }

    public static List<String> list(String ip, int maskBit, boolean isAll) {
        if (maskBit == 32) {
            ArrayList<String> list = new ArrayList<String>();
            if (isAll) {
                list.add(ip);
            }
            return list;
        }
        Object startIp = NetKit.getBeginIpStr(ip, maskBit);
        Object endIp = NetKit.getEndIpStr(ip, maskBit);
        if (isAll) {
            return NetKit.list((String)startIp, (String)endIp);
        }
        int lastDotIndex = ((String)startIp).lastIndexOf(46) + 1;
        startIp = StringKit.subPre((CharSequence)startIp, lastDotIndex) + (Integer.parseInt(Objects.requireNonNull(StringKit.subSuf((CharSequence)startIp, lastDotIndex))) + 1);
        lastDotIndex = ((String)endIp).lastIndexOf(46) + 1;
        endIp = StringKit.subPre((CharSequence)endIp, lastDotIndex) + (Integer.parseInt(Objects.requireNonNull(StringKit.subSuf((CharSequence)endIp, lastDotIndex))) - 1);
        return NetKit.list((String)startIp, (String)endIp);
    }

    public static List<String> list(String ipFrom, String ipTo) {
        int[] ipf = Convert.convert(int[].class, (Object)StringKit.splitToArray((CharSequence)ipFrom, '.'));
        int[] ipt = Convert.convert(int[].class, (Object)StringKit.splitToArray((CharSequence)ipTo, '.'));
        ArrayList<String> ips = new ArrayList<String>();
        for (int a = ipf[0]; a <= ipt[0]; ++a) {
            for (int b = a == ipf[0] ? ipf[1] : 0; b <= (a == ipt[0] ? ipt[1] : 255); ++b) {
                for (int c = b == ipf[1] ? ipf[2] : 0; c <= (b == ipt[1] ? ipt[2] : 255); ++c) {
                    for (int d = c == ipf[2] ? ipf[3] : 0; d <= (c == ipt[2] ? ipt[3] : 255); ++d) {
                        ips.add(a + "." + b + "." + c + "." + d);
                    }
                }
            }
        }
        return ips;
    }

    public static String longToIpv4(long longIP) {
        StringBuilder sb = StringKit.builder();
        sb.append(longIP >> 24 & 0xFFL);
        sb.append('.');
        sb.append(longIP >> 16 & 0xFFL);
        sb.append('.');
        sb.append(longIP >> 8 & 0xFFL);
        sb.append('.');
        sb.append(longIP & 0xFFL);
        return sb.toString();
    }

    public static long ipv4ToLong(String strIP) {
        Matcher matcher = RegEx.IPV4.matcher(strIP);
        if (matcher.matches()) {
            return NetKit.matchAddress(matcher);
        }
        throw new IllegalArgumentException("Invalid IPv4 address!");
    }

    public static String getBeginIpStr(String ip, int maskBit) {
        return NetKit.longToIpv4(NetKit.getBeginIpLong(ip, maskBit));
    }

    public static Long getBeginIpLong(String ip, int maskBit) {
        return NetKit.ipv4ToLong(ip) & NetKit.ipv4ToLong(NetKit.getMaskByMaskBit(maskBit));
    }

    public static String getEndIpStr(String ip, int maskBit) {
        return NetKit.longToIpv4(NetKit.getEndIpLong(ip, maskBit));
    }

    public static int getMaskBitByMask(String mask) {
        Integer maskBit = MaskBit.getMaskBit(mask);
        if (maskBit == null) {
            throw new IllegalArgumentException("Invalid netmask " + mask);
        }
        return maskBit;
    }

    public static int countByMaskBit(int maskBit, boolean isAll) {
        if (!(isAll || maskBit > 0 && maskBit < 32)) {
            return 0;
        }
        int count = (int)Math.pow(2.0, 32 - maskBit);
        return isAll ? count : count - 2;
    }

    public static String getMaskByMaskBit(int maskBit) {
        return MaskBit.get(maskBit);
    }

    public static String getMaskByIpRange(String fromIp, String toIp) {
        long toIpLong = NetKit.ipv4ToLong(toIp);
        long fromIpLong = NetKit.ipv4ToLong(fromIp);
        Assert.isTrue(fromIpLong < toIpLong, "to IP must be greater than from IP!", new Object[0]);
        String[] fromIpSplit = StringKit.splitToArray((CharSequence)fromIp, '.');
        String[] toIpSplit = StringKit.splitToArray((CharSequence)toIp, '.');
        StringBuilder mask = new StringBuilder();
        for (int i = 0; i < toIpSplit.length; ++i) {
            mask.append(255 - Integer.parseInt(toIpSplit[i]) + Integer.parseInt(fromIpSplit[i])).append('.');
        }
        return mask.substring(0, mask.length() - 1);
    }

    public static int countByIpRange(String fromIp, String toIp) {
        long toIpLong = NetKit.ipv4ToLong(toIp);
        long fromIpLong = NetKit.ipv4ToLong(fromIp);
        if (fromIpLong > toIpLong) {
            throw new IllegalArgumentException("to IP must be greater than from IP!");
        }
        int count = 1;
        int[] fromIpSplit = StringKit.split((CharSequence)fromIp, '.').stream().mapToInt(Integer::parseInt).toArray();
        int[] toIpSplit = StringKit.split((CharSequence)toIp, '.').stream().mapToInt(Integer::parseInt).toArray();
        for (int i = fromIpSplit.length - 1; i >= 0; --i) {
            count = (int)((double)count + (double)(toIpSplit[i] - fromIpSplit[i]) * Math.pow(256.0, fromIpSplit.length - i - 1));
        }
        return count;
    }

    public static boolean isMaskValid(String mask) {
        return MaskBit.getMaskBit(mask) != null;
    }

    public static boolean isMaskBitValid(int maskBit) {
        return MaskBit.get(maskBit) != null;
    }

    public static boolean isInnerIP(String ipAddress) {
        long ipNum = NetKit.ipv4ToLong(ipAddress);
        long aBegin = NetKit.ipv4ToLong("10.0.0.0");
        long aEnd = NetKit.ipv4ToLong("10.255.255.255");
        long bBegin = NetKit.ipv4ToLong("172.16.0.0");
        long bEnd = NetKit.ipv4ToLong("172.31.255.255");
        long cBegin = NetKit.ipv4ToLong("192.168.0.0");
        long cEnd = NetKit.ipv4ToLong("192.168.255.255");
        boolean isInnerIp = NetKit.isInner(ipNum, aBegin, aEnd) || NetKit.isInner(ipNum, bBegin, bEnd) || NetKit.isInner(ipNum, cBegin, cEnd) || "127.0.0.1".equals(ipAddress);
        return isInnerIp;
    }

    public static Long getEndIpLong(String ip, int maskBit) {
        return NetKit.getBeginIpLong(ip, maskBit) + (NetKit.ipv4ToLong(NetKit.getMaskByMaskBit(maskBit)) ^ 0xFFFFFFFFFFFFFFFFL);
    }

    private static long matchAddress(Matcher matcher) {
        long addr = 0L;
        for (int i = 1; i <= 4; ++i) {
            addr |= Long.parseLong(matcher.group(i)) << 8 * (4 - i);
        }
        return addr;
    }

    private static boolean isInner(long userIp, long begin, long end) {
        return userIp >= begin && userIp <= end;
    }

    public static InitialDirContext createInitialDirContext(Map<String, String> environment) {
        try {
            if (MapKit.isEmpty(environment)) {
                return new InitialDirContext();
            }
            return new InitialDirContext(Convert.convert(Hashtable.class, environment));
        }
        catch (NamingException e) {
            throw new InternalException(e);
        }
    }

    public static InitialContext createInitialContext(Map<String, String> environment) {
        try {
            if (MapKit.isEmpty(environment)) {
                return new InitialContext();
            }
            return new InitialContext(Convert.convert(Hashtable.class, environment));
        }
        catch (NamingException e) {
            throw new InternalException(e);
        }
    }

    public static Attributes getAttributes(String uri, String ... attrIds) {
        try {
            return NetKit.createInitialDirContext(null).getAttributes(uri, attrIds);
        }
        catch (NamingException e) {
            throw new InternalException(e);
        }
    }
}

