/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.beans;

import java.beans.PropertyDescriptor;
import java.util.Map;
import org.aoju.bus.core.lang.function.XSupplier;
import org.aoju.bus.core.map.ReferenceMap;
import org.aoju.bus.core.map.WeakMap;

public enum PropertyCache {
    INSTANCE;

    private final WeakMap<Class<?>, Map<String, PropertyDescriptor>> pdCache = new WeakMap();
    private final WeakMap<Class<?>, Map<String, PropertyDescriptor>> ignoreCasePdCache = new WeakMap();

    public Map<String, PropertyDescriptor> getPropertyDescriptorMap(Class<?> beanClass, boolean ignoreCase) {
        return this.getCache(ignoreCase).get(beanClass);
    }

    public Map<String, PropertyDescriptor> getPropertyDescriptorMap(Class<?> beanClass, boolean ignoreCase, XSupplier<Map<String, PropertyDescriptor>> supplier) {
        return this.getCache(ignoreCase).computeIfAbsent(beanClass, key -> (Map)supplier.get());
    }

    public void putPropertyDescriptorMap(Class<?> beanClass, Map<String, PropertyDescriptor> fieldNamePropertyDescriptorMap, boolean ignoreCase) {
        this.getCache(ignoreCase).put(beanClass, fieldNamePropertyDescriptorMap);
    }

    public void clear() {
        this.pdCache.clear();
        this.ignoreCasePdCache.clear();
    }

    private ReferenceMap<Class<?>, Map<String, PropertyDescriptor>> getCache(boolean ignoreCase) {
        return ignoreCase ? this.ignoreCasePdCache : this.pdCache;
    }
}

