/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.codec.provider;

import java.util.Arrays;
import org.aoju.bus.core.codec.Decoder;
import org.aoju.bus.core.codec.Encoder;
import org.aoju.bus.core.toolkit.StringKit;

public class Base58Provider
implements Encoder<byte[], String>,
Decoder<CharSequence, byte[]> {
    public static Base58Provider INSTANCE = new Base58Provider();

    private static byte divmod(byte[] number, int firstDigit, int base, int divisor) {
        int remainder = 0;
        for (int i = firstDigit; i < number.length; ++i) {
            int digit = number[i] & 0xFF;
            int temp = remainder * base + digit;
            number[i] = (byte)(temp / divisor);
            remainder = temp % divisor;
        }
        return (byte)remainder;
    }

    @Override
    public String encode(byte[] data) {
        return Base58Encoder.ENCODER.encode(data);
    }

    @Override
    public byte[] decode(CharSequence encoded) throws IllegalArgumentException {
        return Base58Decoder.DECODER.decode(encoded);
    }

    public static class Base58Encoder
    implements Encoder<byte[], String> {
        private static final String DEFAULT_ALPHABET = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789012345";
        public static final Base58Encoder ENCODER = new Base58Encoder("ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789012345".toCharArray());
        private final char[] alphabet;
        private final char alphabetZero;

        public Base58Encoder(char[] alphabet) {
            this.alphabet = alphabet;
            this.alphabetZero = alphabet[0];
        }

        @Override
        public String encode(byte[] data) {
            int zeroCount;
            if (null == data) {
                return null;
            }
            if (data.length == 0) {
                return "";
            }
            for (zeroCount = 0; zeroCount < data.length && data[zeroCount] == 0; ++zeroCount) {
            }
            data = Arrays.copyOf(data, data.length);
            char[] encoded = new char[data.length * 2];
            int outputStart = encoded.length;
            int inputStart = zeroCount;
            while (inputStart < data.length) {
                encoded[--outputStart] = this.alphabet[Base58Provider.divmod(data, inputStart, 256, 58)];
                if (data[inputStart] != 0) continue;
                ++inputStart;
            }
            while (outputStart < encoded.length && encoded[outputStart] == this.alphabetZero) {
                ++outputStart;
            }
            while (--zeroCount >= 0) {
                encoded[--outputStart] = this.alphabetZero;
            }
            return new String(encoded, outputStart, encoded.length - outputStart);
        }
    }

    public static class Base58Decoder
    implements Decoder<CharSequence, byte[]> {
        public static Base58Decoder DECODER = new Base58Decoder("ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789012345");
        private final byte[] lookupTable;

        public Base58Decoder(String alphabet) {
            byte[] lookupTable = new byte[123];
            Arrays.fill(lookupTable, (byte)-1);
            int length = alphabet.length();
            for (int i = 0; i < length; ++i) {
                lookupTable[alphabet.charAt((int)i)] = (byte)i;
            }
            this.lookupTable = lookupTable;
        }

        @Override
        public byte[] decode(CharSequence encoded) {
            int zeros;
            if (encoded.length() == 0) {
                return new byte[0];
            }
            byte[] input58 = new byte[encoded.length()];
            for (int i = 0; i < encoded.length(); ++i) {
                int digit;
                char c = encoded.charAt(i);
                int n = digit = c < '\u0080' ? this.lookupTable[c] : -1;
                if (digit < 0) {
                    throw new IllegalArgumentException(StringKit.format((CharSequence)"Invalid char '{}' at [{}]", Character.valueOf(c), i));
                }
                input58[i] = (byte)digit;
            }
            for (zeros = 0; zeros < input58.length && input58[zeros] == 0; ++zeros) {
            }
            byte[] decoded = new byte[encoded.length()];
            int outputStart = decoded.length;
            int inputStart = zeros;
            while (inputStart < input58.length) {
                decoded[--outputStart] = Base58Provider.divmod(input58, inputStart, 58, 256);
                if (input58[inputStart] != 0) continue;
                ++inputStart;
            }
            while (outputStart < decoded.length && decoded[outputStart] == 0) {
                ++outputStart;
            }
            return Arrays.copyOfRange(decoded, outputStart - zeros, decoded.length);
        }
    }
}

