/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.codec.provider;

import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import org.aoju.bus.core.codec.Decoder;
import org.aoju.bus.core.codec.Encoder;
import org.aoju.bus.core.toolkit.ArrayKit;

public class Base62Provider
implements Encoder<byte[], byte[]>,
Decoder<byte[], byte[]>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final int STANDARD_BASE = 256;
    private static final int TARGET_BASE = 62;
    public static Base62Provider INSTANCE = new Base62Provider();

    private static byte[] translate(byte[] indices, byte[] dictionary) {
        byte[] translation = new byte[indices.length];
        for (int i = 0; i < indices.length; ++i) {
            translation[i] = dictionary[indices[i]];
        }
        return translation;
    }

    private static byte[] convert(byte[] message, int sourceBase, int targetBase) {
        int estimatedLength = Base62Provider.estimateOutputLength(message.length, sourceBase, targetBase);
        ByteArrayOutputStream out = new ByteArrayOutputStream(estimatedLength);
        byte[] source = message;
        while (source.length > 0) {
            ByteArrayOutputStream quotient = new ByteArrayOutputStream(source.length);
            int remainder = 0;
            for (byte b : source) {
                int accumulator = (b & 0xFF) + remainder * sourceBase;
                int digit = (accumulator - accumulator % targetBase) / targetBase;
                remainder = accumulator % targetBase;
                if (quotient.size() <= 0 && digit <= 0) continue;
                quotient.write(digit);
            }
            out.write(remainder);
            source = quotient.toByteArray();
        }
        for (int i = 0; i < message.length - 1 && message[i] == 0; ++i) {
            out.write(0);
        }
        return ArrayKit.reverse(out.toByteArray());
    }

    private static int estimateOutputLength(int inputLength, int sourceBase, int targetBase) {
        return (int)Math.ceil(Math.log(sourceBase) / Math.log(targetBase) * (double)inputLength);
    }

    @Override
    public byte[] encode(byte[] data) {
        return this.encode(data, false);
    }

    public byte[] encode(byte[] data, boolean useInverted) {
        Base62Encoder encoder = useInverted ? Base62Encoder.INVERTED_ENCODER : Base62Encoder.GMP_ENCODER;
        return encoder.encode(data);
    }

    @Override
    public byte[] decode(byte[] encoded) {
        return this.decode(encoded, false);
    }

    public byte[] decode(byte[] encoded, boolean useInverted) {
        Base62Decoder decoder = useInverted ? Base62Decoder.INVERTED_DECODER : Base62Decoder.GMP_DECODER;
        return decoder.decode(encoded);
    }

    public static class Base62Encoder
    implements Encoder<byte[], byte[]> {
        public static Base62Encoder GMP_ENCODER = new Base62Encoder("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789".getBytes());
        public static Base62Encoder INVERTED_ENCODER = new Base62Encoder("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789".getBytes());
        private final byte[] alphabet;

        public Base62Encoder(byte[] alphabet) {
            this.alphabet = alphabet;
        }

        @Override
        public byte[] encode(byte[] data) {
            byte[] indices = Base62Provider.convert(data, 256, 62);
            return Base62Provider.translate(indices, this.alphabet);
        }
    }

    public static class Base62Decoder
    implements Decoder<byte[], byte[]> {
        public static Base62Decoder GMP_DECODER = new Base62Decoder("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789".getBytes());
        public static Base62Decoder INVERTED_DECODER = new Base62Decoder("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789".getBytes());
        private final byte[] lookupTable = new byte[123];

        public Base62Decoder(byte[] alphabet) {
            for (int i = 0; i < alphabet.length; ++i) {
                this.lookupTable[alphabet[i]] = (byte)i;
            }
        }

        @Override
        public byte[] decode(byte[] encoded) {
            byte[] prepared = Base62Provider.translate(encoded, this.lookupTable);
            return Base62Provider.convert(prepared, 62, 256);
        }
    }
}

