/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.convert;

import java.sql.Time;
import java.sql.Timestamp;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Date;
import org.aoju.bus.core.convert.AbstractConverter;
import org.aoju.bus.core.date.DateTime;
import org.aoju.bus.core.exception.ConvertException;
import org.aoju.bus.core.toolkit.DateKit;
import org.aoju.bus.core.toolkit.StringKit;

public class DateConverter
extends AbstractConverter {
    private static final long serialVersionUID = 1L;
    public static final DateConverter INSTANCE = new DateConverter();
    private String format;

    public DateConverter() {
        this(null);
    }

    public DateConverter(String format) {
        this.format = format;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    @Override
    protected Date convertInternal(Class<?> targetClass, Object value) {
        DateTime dateTime;
        if (value == null || value instanceof CharSequence && StringKit.isBlank(value.toString())) {
            return null;
        }
        if (value instanceof TemporalAccessor) {
            return this.wrap(targetClass, DateKit.date((TemporalAccessor)value));
        }
        if (value instanceof Calendar) {
            return this.wrap(targetClass, DateKit.date((Calendar)value));
        }
        if (null == this.format && value instanceof Number) {
            return this.wrap(targetClass, ((Number)value).longValue());
        }
        String valueStr = this.convertToString(value);
        DateTime dateTime2 = dateTime = StringKit.isBlank(this.format) ? DateKit.parse(valueStr) : DateKit.parse((CharSequence)valueStr, this.format);
        if (null != dateTime) {
            return this.wrap(targetClass, dateTime);
        }
        throw new ConvertException("Can not convert {}:[{}] to {}", value.getClass().getName(), value, targetClass.getName());
    }

    private Date wrap(Class<?> targetClass, DateTime date) {
        if (Date.class == targetClass) {
            return date.toJdkDate();
        }
        if (DateTime.class == targetClass) {
            return date;
        }
        if (java.sql.Date.class == targetClass) {
            return date.toSqlDate();
        }
        if (Time.class == targetClass) {
            return new Time(date.getTime());
        }
        if (Timestamp.class == targetClass) {
            return date.toTimestamp();
        }
        throw new UnsupportedOperationException(StringKit.format((CharSequence)"Unsupported target Date type: {}", targetClass.getName()));
    }

    private Date wrap(Class<?> targetClass, long mills) {
        if (Date.class == targetClass) {
            return new Date(mills);
        }
        if (DateTime.class == targetClass) {
            return DateKit.date(mills);
        }
        if (java.sql.Date.class == targetClass) {
            return new java.sql.Date(mills);
        }
        if (Time.class == targetClass) {
            return new Time(mills);
        }
        if (Timestamp.class == targetClass) {
            return new Timestamp(mills);
        }
        throw new UnsupportedOperationException(StringKit.format((CharSequence)"Unsupported target Date type: {}", targetClass.getName()));
    }
}

