/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.date;

import java.sql.Date;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalField;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;
import org.aoju.bus.core.date.Almanac;
import org.aoju.bus.core.date.Between;
import org.aoju.bus.core.date.Converter;
import org.aoju.bus.core.date.Formatter;
import org.aoju.bus.core.date.formatter.DatePrinter;
import org.aoju.bus.core.date.formatter.FormatBuilder;
import org.aoju.bus.core.date.formatter.parser.PositionDateParser;
import org.aoju.bus.core.exception.InternalException;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.lang.Fields;
import org.aoju.bus.core.lang.System;
import org.aoju.bus.core.toolkit.ObjectKit;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.core.toolkit.ZoneKit;

public class DateTime
extends java.util.Date {
    private static final long serialVersionUID = 1L;
    private boolean mutable = true;
    private Fields.Week firstDayOfWeek = Fields.Week.Sun;
    private TimeZone timeZone;
    private int firstWeekOfDays;

    public DateTime() {
        this(TimeZone.getDefault());
    }

    public DateTime(TimeZone timeZone) {
        this(java.lang.System.currentTimeMillis(), timeZone);
    }

    public DateTime(java.util.Date date) {
        this(date.getTime(), date instanceof DateTime ? ((DateTime)date).timeZone : TimeZone.getDefault());
    }

    public DateTime(java.util.Date date, TimeZone timeZone) {
        this(ObjectKit.defaultIfNull(date, java.util.Date::new).getTime(), timeZone);
    }

    public DateTime(Calendar calendar) {
        this(calendar.getTime(), calendar.getTimeZone());
        this.setFirstDayOfWeek(Fields.Week.getByCode(calendar.getFirstDayOfWeek()));
    }

    public DateTime(Instant instant) {
        this(instant.toEpochMilli());
    }

    public DateTime(Instant instant, ZoneId zoneId) {
        this(instant.toEpochMilli(), ZoneKit.toTimeZone(zoneId));
    }

    public DateTime(TemporalAccessor temporalAccessor) {
        this(Converter.toInstant(temporalAccessor));
    }

    public DateTime(ZonedDateTime zonedDateTime) {
        this(zonedDateTime.toInstant(), zonedDateTime.getZone());
    }

    public DateTime(long timeMillis) {
        this(timeMillis, TimeZone.getDefault());
    }

    public DateTime(long timeMillis, TimeZone timeZone) {
        super(timeMillis);
        this.timeZone = ObjectKit.defaultIfNull(timeZone, TimeZone::getDefault);
    }

    public DateTime(CharSequence text) {
        this(Formatter.parse(text));
    }

    public DateTime(CharSequence text, String format) {
        this(text, Formatter.newSimpleFormat(format));
    }

    public DateTime(CharSequence text, DateFormat format) {
        this(DateTime.parse(text, format), format.getTimeZone());
    }

    public DateTime(CharSequence text, DateTimeFormatter formatter) {
        this(Converter.toInstant(formatter.parse(text)), formatter.getZone());
    }

    public DateTime(CharSequence text, PositionDateParser parser) {
        this(text, parser, System.getBoolean(System.BUS_DATE_LENIENT, true));
    }

    public DateTime(CharSequence text, PositionDateParser parser, boolean lenient) {
        this(DateTime.parse(text, parser, lenient));
    }

    public static DateTime of(long timeMillis) {
        return new DateTime(timeMillis);
    }

    public static DateTime of(java.util.Date date) {
        if (date instanceof DateTime) {
            return (DateTime)date;
        }
        return new DateTime(date);
    }

    public static DateTime of(Calendar calendar) {
        return new DateTime(calendar);
    }

    public static DateTime of(String text, String format) {
        return new DateTime((CharSequence)text, format);
    }

    public static DateTime now() {
        return new DateTime();
    }

    private static java.util.Date parse(CharSequence text, DateFormat dateFormat) {
        Assert.notBlank(text, "Date String must be not blank !", new Object[0]);
        try {
            return dateFormat.parse(text.toString());
        }
        catch (Exception e) {
            String pattern = dateFormat instanceof SimpleDateFormat ? ((SimpleDateFormat)dateFormat).toPattern() : dateFormat.toString();
            throw new InternalException(StringKit.format((CharSequence)"Parse [{}] with format [{}] error!", text, pattern), e);
        }
    }

    private static Calendar parse(CharSequence text, PositionDateParser parser, boolean lenient) {
        Assert.notNull(parser, "Parser or DateFromat must be not null !", new Object[0]);
        Assert.notBlank(text, "Date String must be not blank !", new Object[0]);
        Calendar calendar = Formatter.parseByPatterns(text, lenient, parser);
        if (null == calendar) {
            throw new InternalException("Parse [{}] with format [{}] error!", text, parser.getPattern());
        }
        calendar.setFirstDayOfWeek(Fields.Week.Mon.getKey());
        return calendar;
    }

    public static LocalDateTime of(TemporalAccessor temporalAccessor) {
        if (null == temporalAccessor) {
            return null;
        }
        if (temporalAccessor instanceof LocalDate) {
            return ((LocalDate)temporalAccessor).atStartOfDay();
        }
        if (temporalAccessor instanceof Instant) {
            return LocalDateTime.ofInstant((Instant)temporalAccessor, ZoneId.systemDefault());
        }
        if (temporalAccessor instanceof ZonedDateTime) {
            return ((ZonedDateTime)temporalAccessor).toLocalDateTime();
        }
        return LocalDateTime.of(DateTime.get(temporalAccessor, ChronoField.YEAR), DateTime.get(temporalAccessor, ChronoField.MONTH_OF_YEAR), DateTime.get(temporalAccessor, ChronoField.DAY_OF_MONTH), DateTime.get(temporalAccessor, ChronoField.HOUR_OF_DAY), DateTime.get(temporalAccessor, ChronoField.MINUTE_OF_HOUR), DateTime.get(temporalAccessor, ChronoField.SECOND_OF_MINUTE), DateTime.get(temporalAccessor, ChronoField.NANO_OF_SECOND));
    }

    public static int get(TemporalAccessor temporalAccessor, TemporalField field) {
        if (temporalAccessor.isSupported(field)) {
            return temporalAccessor.get(field);
        }
        return (int)field.range().getMinimum();
    }

    public DateTime offset(Fields.Type type, int offset) {
        if (Fields.Type.ERA == type) {
            throw new IllegalArgumentException("ERA is not support offset!");
        }
        Calendar cal = this.toCalendar();
        cal.add(type.getValue(), offset);
        DateTime dt = this.mutable ? this : ObjectKit.clone(this);
        return dt.setTimeInternal(cal.getTimeInMillis());
    }

    public DateTime offsetNew(Fields.Type type, int offset) {
        Calendar cal = this.toCalendar();
        cal.add(type.getValue(), offset);
        DateTime dt = ObjectKit.clone(this);
        return dt.setTimeInternal(cal.getTimeInMillis());
    }

    public int getField(Fields.Type field) {
        return this.getField(field.getValue());
    }

    public int getField(int field) {
        return this.toCalendar().get(field);
    }

    public DateTime setField(Fields.Type field, int value) {
        return this.setField(field.getValue(), value);
    }

    public DateTime setField(int field, int value) {
        Calendar calendar = this.toCalendar();
        calendar.set(field, value);
        DateTime dt = this;
        if (!this.mutable) {
            dt = ObjectKit.clone(this);
        }
        return dt.setTimeInternal(calendar.getTimeInMillis());
    }

    @Override
    public void setTime(long time) {
        if (!this.mutable) {
            throw new InternalException("This is not a mutable object !");
        }
        super.setTime(time);
    }

    public int year() {
        return this.getField(Fields.Type.YEAR);
    }

    public int quarter() {
        return this.month() / 3 + 1;
    }

    public Fields.Quarter quarterEnum() {
        return Fields.Quarter.of(this.quarter());
    }

    public int month() {
        return this.getField(Fields.Type.MONTH);
    }

    public int monthStartFromOne() {
        return this.month() + 1;
    }

    public Fields.Month monthEnum() {
        return Fields.Month.getByCode(this.month());
    }

    public int weekOfYear() {
        return this.getField(Fields.Type.WEEK_OF_YEAR);
    }

    public int weekOfMonth() {
        return this.getField(Fields.Type.WEEK_OF_MONTH);
    }

    public int dayOfMonth() {
        return this.getField(Fields.Type.DAY_OF_MONTH);
    }

    public int dayOfYear() {
        return this.getField(Fields.Type.DAY_OF_YEAR);
    }

    public int dayOfWeek() {
        return this.getField(Fields.Type.DAY_OF_WEEK);
    }

    public int dayOfWeekInMonth() {
        return this.getField(Fields.Type.DAY_OF_WEEK_IN_MONTH);
    }

    public Fields.Week dayOfWeekEnum() {
        return Fields.Week.getByCode(this.dayOfWeek());
    }

    public int hour(boolean is24HourClock) {
        return this.getField(is24HourClock ? Fields.Type.HOUR_OF_DAY : Fields.Type.HOUR);
    }

    public int minute() {
        return this.getField(Fields.Type.MINUTE);
    }

    public int second() {
        return this.getField(Fields.Type.SECOND);
    }

    public int millsecond() {
        return this.getField(Fields.Type.MILLISECOND);
    }

    public boolean isAM() {
        return 0 == this.getField(Fields.Type.AM_PM);
    }

    public boolean isPM() {
        return 1 == this.getField(Fields.Type.AM_PM);
    }

    public boolean isWeekend() {
        int dayOfWeek = this.dayOfWeek();
        return 7 == dayOfWeek || 1 == dayOfWeek;
    }

    public Calendar toCalendar() {
        return this.toCalendar(Locale.getDefault(Locale.Category.FORMAT));
    }

    public Calendar toCalendar(Locale locale) {
        return this.toCalendar(this.timeZone, locale);
    }

    public Calendar toCalendar(TimeZone zone) {
        return this.toCalendar(zone, Locale.getDefault(Locale.Category.FORMAT));
    }

    public Calendar toCalendar(TimeZone zone, Locale locale) {
        if (null == locale) {
            locale = Locale.getDefault(Locale.Category.FORMAT);
        }
        Calendar cal = null != zone ? Calendar.getInstance(zone, locale) : Calendar.getInstance(locale);
        cal.setFirstDayOfWeek(this.firstDayOfWeek.getKey());
        if (this.firstWeekOfDays > 0) {
            cal.setMinimalDaysInFirstWeek(this.firstWeekOfDays);
        }
        cal.setTime(this);
        return cal;
    }

    public java.util.Date toJdkDate() {
        return new java.util.Date(this.getTime());
    }

    public Timestamp toTimestamp() {
        return new Timestamp(this.getTime());
    }

    public Date toSqlDate() {
        return new Date(this.getTime());
    }

    public Between between(java.util.Date date) {
        return new Between(this, date);
    }

    public long between(java.util.Date date, Fields.Units units) {
        return new Between(this, date).between(units);
    }

    public boolean isIn(java.util.Date beginDate, java.util.Date endDate) {
        long beginMills = beginDate.getTime();
        long endMills = endDate.getTime();
        long thisMills = this.getTime();
        return thisMills >= Math.min(beginMills, endMills) && thisMills <= Math.max(beginMills, endMills);
    }

    public boolean isBefore(java.util.Date date) {
        if (null == date) {
            throw new NullPointerException("Date to compare is null !");
        }
        return this.compareTo(date) < 0;
    }

    public boolean isBeforeOrEquals(java.util.Date date) {
        if (null == date) {
            throw new NullPointerException("Date to compare is null !");
        }
        return this.compareTo(date) <= 0;
    }

    public boolean isAfter(java.util.Date date) {
        if (null == date) {
            throw new NullPointerException("Date to compare is null !");
        }
        return this.compareTo(date) > 0;
    }

    public boolean isAfterOrEquals(java.util.Date date) {
        if (null == date) {
            throw new NullPointerException("Date to compare is null !");
        }
        return this.compareTo(date) >= 0;
    }

    public boolean isMutable() {
        return this.mutable;
    }

    public DateTime setMutable(boolean mutable) {
        this.mutable = mutable;
        return this;
    }

    public Fields.Week getFirstDayOfWeek() {
        return this.firstDayOfWeek;
    }

    public DateTime setFirstDayOfWeek(Fields.Week firstDayOfWeek) {
        this.firstDayOfWeek = firstDayOfWeek;
        return this;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public DateTime setTimeZone(TimeZone timeZone) {
        this.timeZone = ObjectKit.defaultIfNull(timeZone, TimeZone::getDefault);
        return this;
    }

    public DateTime setFirstWeekOfDays(int firstWeekOfDays) {
        this.firstWeekOfDays = firstWeekOfDays;
        return this;
    }

    public ZoneId getZoneId() {
        return this.timeZone.toZoneId();
    }

    public String toDateString() {
        if (null != this.timeZone) {
            return this.toString(Formatter.newSimpleFormat("yyyy-MM-dd", null, this.timeZone));
        }
        return this.toString(Fields.NORM_DATE_FORMAT);
    }

    public String toTimeString() {
        if (null != this.timeZone) {
            return this.toString(Formatter.newSimpleFormat("HH:mm:ss", null, this.timeZone));
        }
        return this.toString(Fields.NORM_TIME_FORMAT);
    }

    public String toMsString() {
        return this.toString(Fields.NORM_DATETIME_MS_FORMAT);
    }

    @Override
    public String toString() {
        return this.toString(this.timeZone);
    }

    public String toString(TimeZone timeZone) {
        if (null != timeZone) {
            return this.toString(Formatter.newSimpleFormat("yyyy-MM-dd HH:mm:ss", null, timeZone));
        }
        return this.toString(Fields.NORM_DATETIME_FORMAT);
    }

    public String toString(String format) {
        if (null != this.timeZone) {
            return this.toString(Formatter.newSimpleFormat(format, null, this.timeZone));
        }
        return this.toString(FormatBuilder.getInstance(format));
    }

    public String toString(DatePrinter format) {
        return format.format(this);
    }

    public String toString(DateFormat format) {
        return format.format(this);
    }

    private DateTime setTimeInternal(long time) {
        super.setTime(time);
        return this;
    }

    public boolean isLastDayOfMonth() {
        return this.dayOfMonth() == this.getLastDayOfMonth();
    }

    public int getLastDayOfMonth() {
        return this.monthEnum().getLastDay(this.isLeapYear());
    }

    public boolean isLeapYear() {
        return Almanac.isLeapYear(this.year());
    }
}

