/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.io.reader;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Iterator;
import org.aoju.bus.core.collection.ComputeIterator;
import org.aoju.bus.core.io.reader.ReaderWrapper;
import org.aoju.bus.core.toolkit.CharsKit;
import org.aoju.bus.core.toolkit.IoKit;
import org.aoju.bus.core.toolkit.StringKit;

public class LineReader
extends ReaderWrapper
implements Iterable<String> {
    public LineReader(InputStream in, Charset charset) {
        this(IoKit.getReader(in, charset));
    }

    public LineReader(Reader reader) {
        super(IoKit.toBuffered(reader));
    }

    public String readLine() throws IOException {
        int c;
        StringBuilder str = null;
        boolean precedingBackslash = false;
        while ((c = this.read()) > 0) {
            if (null == str) {
                str = StringKit.builder(1024);
            }
            if (92 == c) {
                if (!precedingBackslash) {
                    precedingBackslash = true;
                    continue;
                }
                precedingBackslash = false;
            } else if (precedingBackslash) {
                if (CharsKit.isBlankChar(c)) continue;
                precedingBackslash = false;
            } else if (10 == c) {
                int lastIndex = str.length() - 1;
                if (lastIndex < 0 || '\r' != str.charAt(lastIndex)) break;
                str.deleteCharAt(lastIndex);
                break;
            }
            str.append((char)c);
        }
        return StringKit.toStringOrNull(str);
    }

    @Override
    public Iterator<String> iterator() {
        return new ComputeIterator<String>(){

            @Override
            protected String computeNext() {
                try {
                    return LineReader.this.readLine();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }
}

