/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.map;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.aoju.bus.core.lang.Optional;
import org.aoju.bus.core.map.MapWrapper;
import org.aoju.bus.core.map.MultiValueMap;
import org.aoju.bus.core.toolkit.CollKit;
import org.aoju.bus.core.toolkit.ObjectKit;

public abstract class AbstractCollValueMap<K, V>
extends MapWrapper<K, Collection<V>>
implements MultiValueMap<K, V> {
    protected static final int DEFAULT_COLLECTION_INITIAL_CAPACITY = 3;
    private static final long serialVersionUID = 1L;

    public AbstractCollValueMap() {
        super(new HashMap(16));
    }

    public AbstractCollValueMap(Map<K, Collection<V>> map) {
        super(new HashMap<K, Collection<V>>(map));
    }

    public AbstractCollValueMap(Supplier<Map<K, Collection<V>>> mapFactory) {
        super(mapFactory);
    }

    @Override
    public boolean putAllValues(K key, Collection<V> coll) {
        if (ObjectKit.isNull(coll)) {
            return false;
        }
        return super.computeIfAbsent(key, k -> this.createCollection()).addAll(coll);
    }

    @Override
    public boolean putValue(K key, V value) {
        return super.computeIfAbsent(key, k -> this.createCollection()).add(value);
    }

    @Override
    public boolean removeValue(K key, V value) {
        return Optional.ofNullable((Collection)super.get(key)).map(t -> t.remove(value)).orElse(false);
    }

    @Override
    public boolean removeAllValues(K key, Collection<V> values) {
        if (CollKit.isEmpty(values)) {
            return false;
        }
        Collection coll = (Collection)this.get(key);
        return ObjectKit.isNotNull(coll) && coll.removeAll(values);
    }

    @Override
    public MultiValueMap<K, V> filterAllValues(BiPredicate<K, V> filter) {
        this.entrySet().forEach((? super T e) -> {
            Object k = e.getKey();
            Collection coll = ((Collection)e.getValue()).stream().filter(v -> filter.test(k, v)).collect(Collectors.toCollection(this::createCollection));
            e.setValue(coll);
        });
        return this;
    }

    @Override
    public MultiValueMap<K, V> replaceAllValues(BiFunction<K, V, V> operate) {
        this.entrySet().forEach((? super T e) -> {
            Object k = e.getKey();
            Collection coll = ((Collection)e.getValue()).stream().map(v -> operate.apply(k, v)).collect(Collectors.toCollection(this::createCollection));
            e.setValue(coll);
        });
        return this;
    }

    public abstract Collection<V> createCollection();
}

