/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.scanner;

import java.util.Collection;
import java.util.Comparator;
import org.aoju.bus.core.map.RowKeyTable;
import org.aoju.bus.core.map.Table;
import org.aoju.bus.core.scanner.Synthesized;
import org.aoju.bus.core.scanner.SynthesizedProcessor;
import org.aoju.bus.core.toolkit.ObjectKit;

public class CacheableProcessor
implements SynthesizedProcessor {
    private final Table<String, Class<?>, Object> valueCaches = new RowKeyTable();
    private final Comparator<Synthesized> annotationComparator;

    public CacheableProcessor(Comparator<Synthesized> annotationComparator) {
        this.annotationComparator = annotationComparator;
    }

    public <T> T getAttributeValue(String attributeName, Class<T> attributeType, Collection<? extends Synthesized> synthesizedAnnotations) {
        Object value = this.valueCaches.get(attributeName, attributeType);
        if (ObjectKit.isNotNull(value)) {
            return (T)value;
        }
        value = synthesizedAnnotations.stream().filter(ma -> ma.hasAttribute(attributeName, attributeType)).min(this.annotationComparator).map(ma -> ma.getAttribute(attributeName)).orElse(null);
        this.valueCaches.put(attributeName, attributeType, value);
        return (T)value;
    }
}

