/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.scanner.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.scanner.AnnotationScanner;
import org.aoju.bus.core.toolkit.AnnoKit;
import org.aoju.bus.core.toolkit.ArrayKit;
import org.aoju.bus.core.toolkit.CollKit;
import org.aoju.bus.core.toolkit.ObjectKit;

public abstract class AbstractTypeScanner<T extends AbstractTypeScanner<T>>
implements AnnotationScanner {
    private final Set<Class<?>> excludeTypes;
    private final List<UnaryOperator<Class<?>>> converters;
    private final T typedThis;
    private boolean includeInterfaces;
    private Predicate<Class<?>> filter;
    private boolean hasConverters;
    private boolean includeSupperClass;

    protected AbstractTypeScanner(boolean includeSupperClass, boolean includeInterfaces, Predicate<Class<?>> filter, Set<Class<?>> excludeTypes) {
        Assert.notNull(filter, "filter must not null", new Object[0]);
        Assert.notNull(excludeTypes, "excludeTypes must not null", new Object[0]);
        this.includeSupperClass = includeSupperClass;
        this.includeInterfaces = includeInterfaces;
        this.filter = filter;
        this.excludeTypes = excludeTypes;
        this.converters = new ArrayList();
        this.typedThis = this;
    }

    public boolean isIncludeSupperClass() {
        return this.includeSupperClass;
    }

    protected T setIncludeSupperClass(boolean includeSupperClass) {
        this.includeSupperClass = includeSupperClass;
        return this.typedThis;
    }

    public boolean isIncludeInterfaces() {
        return this.includeInterfaces;
    }

    protected T setIncludeInterfaces(boolean includeInterfaces) {
        this.includeInterfaces = includeInterfaces;
        return this.typedThis;
    }

    public T setFilter(Predicate<Class<?>> filter) {
        Assert.notNull(filter, "filter must not null", new Object[0]);
        this.filter = filter;
        return this.typedThis;
    }

    public T addExcludeTypes(Class<?> ... excludeTypes) {
        CollKit.addAll(this.excludeTypes, excludeTypes);
        return this.typedThis;
    }

    public T addConverters(UnaryOperator<Class<?>> converter) {
        Assert.notNull(converter, "converter must not null", new Object[0]);
        this.converters.add(converter);
        if (!this.hasConverters) {
            this.hasConverters = CollKit.isNotEmpty(this.converters);
        }
        return this.typedThis;
    }

    @Override
    public void scan(BiConsumer<Integer, Annotation> consumer, AnnotatedElement annotatedEle, Predicate<Annotation> filter) {
        filter = ObjectKit.defaultIfNull(filter, annotation -> true);
        Class<?> sourceClass = this.getClassFormAnnotatedElement(annotatedEle);
        LinkedList<List> classDeque = CollKit.newLinkedList(CollKit.newArrayList(sourceClass));
        LinkedHashSet accessedTypes = new LinkedHashSet();
        int index = 0;
        while (!classDeque.isEmpty()) {
            List currClassQueue = (List)classDeque.removeFirst();
            ArrayList nextClassQueue = new ArrayList();
            for (Class<?> targetClass : currClassQueue) {
                Annotation[] targetAnnotations;
                if (this.isNotNeedProcess(accessedTypes, targetClass = this.convert(targetClass))) continue;
                accessedTypes.add(targetClass);
                this.scanSuperClassIfNecessary(nextClassQueue, targetClass);
                this.scanInterfaceIfNecessary(nextClassQueue, targetClass);
                for (Annotation annotation2 : targetAnnotations = this.getAnnotationsFromTargetClass(annotatedEle, index, targetClass)) {
                    if (!AnnoKit.isNotJdkMateAnnotation(annotation2.annotationType()) && !filter.test(annotation2)) continue;
                    consumer.accept(index, annotation2);
                }
                ++index;
            }
            if (!CollKit.isNotEmpty(nextClassQueue)) continue;
            classDeque.addLast(nextClassQueue);
        }
    }

    protected abstract Class<?> getClassFormAnnotatedElement(AnnotatedElement var1);

    protected abstract Annotation[] getAnnotationsFromTargetClass(AnnotatedElement var1, int var2, Class<?> var3);

    protected boolean isNotNeedProcess(Set<Class<?>> accessedTypes, Class<?> targetClass) {
        return ObjectKit.isNull(targetClass) || accessedTypes.contains(targetClass) || this.excludeTypes.contains(targetClass) || this.filter.negate().test(targetClass);
    }

    protected void scanInterfaceIfNecessary(List<Class<?>> nextClasses, Class<?> targetClass) {
        Class<?>[] interfaces;
        if (this.includeInterfaces && ArrayKit.isNotEmpty(interfaces = targetClass.getInterfaces())) {
            CollKit.addAll(nextClasses, interfaces);
        }
    }

    protected void scanSuperClassIfNecessary(List<Class<?>> nextClassQueue, Class<?> targetClass) {
        Class<?> superClass;
        if (this.includeSupperClass && !ObjectKit.equals(superClass = targetClass.getSuperclass(), Object.class) && ObjectKit.isNotNull(superClass)) {
            nextClassQueue.add(superClass);
        }
    }

    protected Class<?> convert(Class<?> target) {
        if (this.hasConverters) {
            for (UnaryOperator<Class<?>> converter : this.converters) {
                target = (Class)converter.apply(target);
            }
        }
        return target;
    }

    public static class JdkProxyClassConverter
    implements UnaryOperator<Class<?>> {
        @Override
        public Class<?> apply(Class<?> sourceClass) {
            return Proxy.isProxyClass(sourceClass) ? this.apply(sourceClass.getSuperclass()) : sourceClass;
        }
    }
}

