/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.cron.pattern.matcher;

import java.util.ArrayList;
import java.util.List;
import org.aoju.bus.core.lang.exception.CommonException;
import org.aoju.bus.core.utils.CollUtils;
import org.aoju.bus.core.utils.NumberUtils;
import org.aoju.bus.core.utils.StringUtils;
import org.aoju.bus.cron.pattern.matcher.AlwaysTrueValueMatcher;
import org.aoju.bus.cron.pattern.matcher.BoolArrayValueMatcher;
import org.aoju.bus.cron.pattern.matcher.DayOfMonthValueMatcher;
import org.aoju.bus.cron.pattern.matcher.ValueMatcher;
import org.aoju.bus.cron.pattern.matcher.YearValueMatcher;
import org.aoju.bus.cron.pattern.parser.DayOfMonthValueParser;
import org.aoju.bus.cron.pattern.parser.ValueParser;
import org.aoju.bus.cron.pattern.parser.YearValueParser;

public class ValueMatcherBuilder {
    public static ValueMatcher build(String value, ValueParser parser) {
        if (ValueMatcherBuilder.isMatchAllStr(value)) {
            return new AlwaysTrueValueMatcher();
        }
        List<Integer> values = ValueMatcherBuilder.parseArray(value, parser);
        if (values.size() == 0) {
            throw new CommonException("Invalid field: [{}]", value);
        }
        if (parser instanceof DayOfMonthValueParser) {
            return new DayOfMonthValueMatcher(values);
        }
        if (parser instanceof YearValueParser) {
            return new YearValueMatcher(values);
        }
        return new BoolArrayValueMatcher(values);
    }

    private static List<Integer> parseArray(String value, ValueParser parser) {
        ArrayList<Integer> values = new ArrayList<Integer>();
        List parts = StringUtils.split((String)value, (char)',');
        for (String part : parts) {
            CollUtils.addAllIfNotContains(values, ValueMatcherBuilder.parseStep(part, parser));
        }
        return values;
    }

    private static List<Integer> parseStep(String value, ValueParser parser) {
        List<Integer> results;
        List parts = StringUtils.split((String)value, (char)'/');
        int size = parts.size();
        if (size == 1) {
            results = ValueMatcherBuilder.parseRange(value, -1, parser);
        } else if (size == 2) {
            int step = parser.parse((String)parts.get(1));
            if (step < 1) {
                throw new CommonException("Non positive divisor for field: [{}]", value);
            }
            results = ValueMatcherBuilder.parseRange((String)parts.get(0), step, parser);
        } else {
            throw new CommonException("Invalid syntax of field: [{}]", value);
        }
        return results;
    }

    private static List<Integer> parseRange(String value, int step, ValueParser parser) {
        ArrayList<Integer> results = new ArrayList<Integer>();
        if (value.length() <= 2) {
            int minValue = parser.getMin();
            if (!ValueMatcherBuilder.isMatchAllStr(value)) {
                try {
                    minValue = Math.max(minValue, Integer.parseInt(value));
                }
                catch (NumberFormatException e) {
                    throw new CommonException("Invalid field value: [{}]", value);
                }
            } else if (step < 1) {
                step = 1;
            }
            if (step > 0) {
                int maxValue = parser.getMax();
                if (minValue > maxValue) {
                    throw new CommonException("Invalid value {} > {}", new Object[]{minValue, maxValue});
                }
                for (int i = minValue; i <= maxValue; i += step) {
                    results.add(i);
                }
            } else {
                results.add(minValue);
            }
            return results;
        }
        List parts = StringUtils.split((String)value, (char)'-');
        int size = parts.size();
        if (size == 1) {
            int v1 = parser.parse(value);
            if (step > 0) {
                NumberUtils.appendRange((int)v1, (int)parser.getMax(), (int)step, results);
            } else {
                results.add(v1);
            }
        } else if (size == 2) {
            int v1 = parser.parse((String)parts.get(0));
            int v2 = parser.parse((String)parts.get(1));
            if (step < 1) {
                step = 1;
            }
            if (v1 < v2) {
                NumberUtils.appendRange((int)v1, (int)v2, (int)step, results);
            } else if (v1 > v2) {
                NumberUtils.appendRange((int)v1, (int)parser.getMax(), (int)step, results);
                NumberUtils.appendRange((int)parser.getMin(), (int)v2, (int)step, results);
            } else if (step > 0) {
                NumberUtils.appendRange((int)v1, (int)parser.getMax(), (int)step, results);
            } else {
                results.add(v1);
            }
        } else {
            throw new CommonException("Invalid syntax of field: [{}]", value);
        }
        return results;
    }

    private static boolean isMatchAllStr(String value) {
        return 1 == value.length() && ("*".equals(value) || "?".equals(value));
    }
}

