/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.cron;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.aoju.bus.core.consts.Charset;
import org.aoju.bus.core.consts.Fields;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.utils.DateUtils;
import org.aoju.bus.cron.Scheduler;
import org.aoju.bus.cron.pattern.CronPattern;
import org.aoju.bus.cron.task.Task;
import org.aoju.bus.setting.Setting;

public final class CronUtils {
    public static final String CRONTAB_CONFIG_PATH = "config/cron.setting";
    private static final Scheduler scheduler = new Scheduler();
    private static Setting crontabSetting;

    private CronUtils() {
    }

    public static void setCronSetting(Setting cronSetting) {
        crontabSetting = cronSetting;
    }

    public static void setCronSetting(String cronSettingPath) {
        try {
            crontabSetting = new Setting(cronSettingPath, Charset.UTF_8, false);
        }
        catch (InstrumentException instrumentException) {
            // empty catch block
        }
    }

    public static void setMatchSecond(boolean isMatchSecond) {
        scheduler.setMatchSecond(isMatchSecond);
    }

    public static String schedule(String schedulingPattern, Task task) {
        return scheduler.schedule(schedulingPattern, task);
    }

    public static String schedule(String id, String schedulingPattern, Task task) {
        scheduler.schedule(id, schedulingPattern, task);
        return id;
    }

    public static String schedule(String schedulingPattern, Runnable task) {
        return scheduler.schedule(schedulingPattern, task);
    }

    public static void schedule(Setting cronSetting) {
        scheduler.schedule(cronSetting);
    }

    public static void remove(String schedulerId) {
        scheduler.deschedule(schedulerId);
    }

    public static void updatePattern(String id, CronPattern pattern) {
        scheduler.updatePattern(id, pattern);
    }

    public static Scheduler getScheduler() {
        return scheduler;
    }

    public static void start() {
        CronUtils.start(false);
    }

    public static synchronized void start(boolean isDeamon) {
        if (null == crontabSetting) {
            CronUtils.setCronSetting(CRONTAB_CONFIG_PATH);
        }
        if (scheduler.isStarted()) {
            throw new InstrumentException("Scheduler has been started, please stop it first!");
        }
        CronUtils.schedule(crontabSetting);
        scheduler.start(isDeamon);
    }

    public static synchronized void restart() {
        if (null != crontabSetting) {
            crontabSetting.load();
        }
        if (scheduler.isStarted()) {
            scheduler.stop(true);
        }
        CronUtils.schedule(crontabSetting);
        scheduler.start();
    }

    public static synchronized void stop() {
        scheduler.stop();
    }

    public static List<Date> matchedDates(String patternStr, Date start, int count, boolean isMatchSecond) {
        return CronUtils.matchedDates(patternStr, start, (Date)DateUtils.endOfYear((Date)start), count, isMatchSecond);
    }

    public static List<Date> matchedDates(String patternStr, Date start, Date end, int count, boolean isMatchSecond) {
        return CronUtils.matchedDates(patternStr, start.getTime(), end.getTime(), count, isMatchSecond);
    }

    public static List<Date> matchedDates(String patternStr, long start, long end, int count, boolean isMatchSecond) {
        return CronUtils.matchedDates(new CronPattern(patternStr), start, end, count, isMatchSecond);
    }

    public static List<Date> matchedDates(CronPattern pattern, long start, long end, int count, boolean isMatchSecond) {
        Assert.isTrue((start < end ? 1 : 0) != 0, (String)"Start date is later than end !", (Object[])new Object[0]);
        ArrayList<Date> result = new ArrayList<Date>(count);
        long step = isMatchSecond ? Fields.Unit.SECOND.getMillis() : Fields.Unit.MINUTE.getMillis();
        for (long i = start; i < end; i += step) {
            if (!pattern.match(i, isMatchSecond)) continue;
            result.add((Date)DateUtils.date((long)i));
            if (result.size() >= count) break;
        }
        return result;
    }
}

