/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.cron.consts;

public enum ExecutorBlockStrategy {
    SERIAL_EXECUTION("Serial execution"),
    CONCURRENT_EXECUTION("Parallel flow"),
    DISCARD_LATER("Discard Later"),
    COVER_EARLY("Cover Early");

    private String title;

    private ExecutorBlockStrategy(String title) {
        this.title = title;
    }

    public static ExecutorBlockStrategy match(String name, ExecutorBlockStrategy defaultItem) {
        if (name != null) {
            for (ExecutorBlockStrategy item : ExecutorBlockStrategy.values()) {
                if (!item.name().equals(name)) continue;
                return item;
            }
        }
        return defaultItem;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }
}

