/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.cron.pattern.parser;

import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.cron.pattern.parser.SimpleValueParser;

public class DayOfWeekValueParser
extends SimpleValueParser {
    private static final String[] ALIASES = new String[]{"sun", "mon", "tue", "wed", "thu", "fri", "sat"};

    public DayOfWeekValueParser() {
        super(0, 7);
    }

    @Override
    public int parse(String value) throws InstrumentException {
        try {
            return super.parse(value) % 7;
        }
        catch (Exception e) {
            return this.parseAlias(value);
        }
    }

    private int parseAlias(String value) throws InstrumentException {
        if (value.equalsIgnoreCase("L")) {
            return ALIASES.length - 1;
        }
        for (int i = 0; i < ALIASES.length; ++i) {
            if (!ALIASES[i].equalsIgnoreCase(value)) continue;
            return i;
        }
        throw new InstrumentException("Invalid month alias: {}", value);
    }
}

