/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.cron;

public enum ExecutorStrategy {
    SERIAL_EXECUTION("Serial execution"),
    CONCURRENT_EXECUTION("Parallel flow"),
    DISCARD_LATER("Discard Later"),
    COVER_EARLY("Cover Early");

    private String title;

    private ExecutorStrategy(String title) {
        this.title = title;
    }

    public static ExecutorStrategy match(String name, ExecutorStrategy defaultItem) {
        if (name != null) {
            for (ExecutorStrategy item : ExecutorStrategy.values()) {
                if (!item.name().equals(name)) continue;
                return item;
            }
        }
        return defaultItem;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }
}

