/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.cron.pattern.parser;

import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.cron.pattern.parser.ValueParser;

public class SimpleValueParser
implements ValueParser {
    protected int min;
    protected int max;

    public SimpleValueParser(int min, int max) {
        if (min > max) {
            this.min = max;
            this.max = min;
        } else {
            this.min = min;
            this.max = max;
        }
    }

    @Override
    public int parse(String value) throws InstrumentException {
        int i;
        if ("L".equalsIgnoreCase(value)) {
            return this.max;
        }
        try {
            i = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new InstrumentException("Invalid integer value: [{}]", value);
        }
        if (i < this.min || i > this.max) {
            throw new InstrumentException("Value [{}] out of range: [{} , {}]", new Object[]{i, this.min, this.max});
        }
        return i;
    }

    @Override
    public int getMin() {
        return this.min;
    }

    @Override
    public int getMax() {
        return this.max;
    }
}

