/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.cron;

import org.aoju.bus.core.lang.Fields;
import org.aoju.bus.core.toolkit.ThreadKit;
import org.aoju.bus.cron.Scheduler;
import org.aoju.bus.logger.Logger;

public class CronTimer
extends Thread {
    private final long TIMER_UNIT_SECOND = Fields.Time.SECOND.getMillis();
    private final long TIMER_UNIT_MINUTE = Fields.Time.MINUTE.getMillis();
    private final Scheduler scheduler;
    private boolean isStop;

    public CronTimer(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    private static boolean isValidSleepMillis(long millis, long timerUnit) {
        return millis > 0L && millis < 2L * timerUnit;
    }

    @Override
    public void run() {
        long timerUnit = this.scheduler.config.matchSecond ? this.TIMER_UNIT_SECOND : this.TIMER_UNIT_MINUTE;
        long thisTime = System.currentTimeMillis();
        while (!this.isStop) {
            long nextTime = (thisTime / timerUnit + 1L) * timerUnit;
            long sleep = nextTime - System.currentTimeMillis();
            if (CronTimer.isValidSleepMillis(sleep, timerUnit)) {
                if (!ThreadKit.safeSleep((long)sleep)) break;
                thisTime = System.currentTimeMillis();
                this.spawnLauncher(thisTime);
                continue;
            }
            thisTime = System.currentTimeMillis();
        }
        Logger.debug((String)"Cron timer stopped.", (Object[])new Object[0]);
    }

    public synchronized void stopTimer() {
        this.isStop = true;
        ThreadKit.interrupt((Thread)this, (boolean)true);
    }

    private void spawnLauncher(long millis) {
        this.scheduler.supervisor.spawnLauncher(millis);
    }
}

