/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.cron.pattern;

import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.TimeZone;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.lang.Fields;
import org.aoju.bus.core.toolkit.CollKit;
import org.aoju.bus.core.toolkit.DateKit;
import org.aoju.bus.cron.pattern.matcher.MatcherTable;
import org.aoju.bus.cron.pattern.parser.CronPatternParser;

public class CronPattern {
    private final String pattern;
    private final MatcherTable matcherTable;

    public CronPattern(String pattern) {
        this.pattern = pattern;
        this.matcherTable = CronPatternParser.parse(pattern);
    }

    public static Date nextDateAfter(CronPattern pattern, Date start, boolean isMatchSecond) {
        List<Date> matchedDates = CronPattern.matchedDates(pattern, start.getTime(), DateKit.endOfYear((Date)start).getTime(), 1, isMatchSecond);
        if (CollKit.isNotEmpty(matchedDates)) {
            return matchedDates.get(0);
        }
        return null;
    }

    public static List<Date> matchedDates(String patternStr, Date start, int count, boolean isMatchSecond) {
        return CronPattern.matchedDates(patternStr, start, (Date)DateKit.endOfYear((Date)start), count, isMatchSecond);
    }

    public static List<Date> matchedDates(String patternStr, Date start, Date end, int count, boolean isMatchSecond) {
        return CronPattern.matchedDates(patternStr, start.getTime(), end.getTime(), count, isMatchSecond);
    }

    public static List<Date> matchedDates(String patternStr, long start, long end, int count, boolean isMatchSecond) {
        return CronPattern.matchedDates(new CronPattern(patternStr), start, end, count, isMatchSecond);
    }

    public static List<Date> matchedDates(CronPattern pattern, long start, long end, int count, boolean isMatchSecond) {
        Assert.isTrue((start < end ? 1 : 0) != 0, (String)"Start date is later than end !", (Object[])new Object[0]);
        ArrayList<Date> result = new ArrayList<Date>(count);
        long step = isMatchSecond ? Fields.Units.SECOND.getUnit() : Fields.Units.MINUTE.getUnit();
        for (long i = start; i < end; i += step) {
            if (!pattern.match(i, isMatchSecond)) continue;
            result.add((Date)DateKit.date((long)i));
            if (result.size() >= count) break;
        }
        return result;
    }

    public boolean match(long millis, boolean isMatchSecond) {
        return this.match(TimeZone.getDefault(), millis, isMatchSecond);
    }

    public boolean match(TimeZone timezone, long millis, boolean isMatchSecond) {
        GregorianCalendar calendar = new GregorianCalendar(timezone);
        calendar.setTimeInMillis(millis);
        return this.match(calendar, isMatchSecond);
    }

    public boolean match(GregorianCalendar calendar, boolean isMatchSecond) {
        int second = isMatchSecond ? calendar.get(13) : -1;
        int minute = calendar.get(12);
        int hour = calendar.get(11);
        int dayOfMonth = calendar.get(5);
        int month = calendar.get(2) + 1;
        int dayOfWeek = calendar.get(7) - 1;
        int year = calendar.get(1);
        return this.matcherTable.match(second, minute, hour, dayOfMonth, month, dayOfWeek, year);
    }

    public String toString() {
        return this.pattern;
    }
}

