/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.cron.pattern.parser;

import org.aoju.bus.core.lang.exception.CrontabException;
import org.aoju.bus.cron.pattern.parser.AbstractValueParser;

public class DayOfWeekValueParser
extends AbstractValueParser {
    private static final String[] ALIASES = new String[]{"sun", "mon", "tue", "wed", "thu", "fri", "sat"};

    public DayOfWeekValueParser() {
        super(0, 7);
    }

    @Override
    public int parse(String value) throws CrontabException {
        try {
            return super.parse(value) % 7;
        }
        catch (Exception e) {
            return this.parseAlias(value);
        }
    }

    private int parseAlias(String value) throws CrontabException {
        if ("L".equalsIgnoreCase(value)) {
            return ALIASES.length - 1;
        }
        for (int i = 0; i < ALIASES.length; ++i) {
            if (!ALIASES[i].equalsIgnoreCase(value)) continue;
            return i;
        }
        throw new CrontabException("Invalid month alias: {}", value);
    }
}

