/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.cron.timings;

import java.util.concurrent.DelayQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.aoju.bus.core.toolkit.ThreadKit;
import org.aoju.bus.cron.timings.TimerTask;
import org.aoju.bus.cron.timings.TimerTaskList;
import org.aoju.bus.cron.timings.TimingWheel;

public class SystemTimer {
    private final TimingWheel timeWheel;
    private final DelayQueue<TimerTaskList> delayQueue = new DelayQueue();
    private long delayQueueTimeout = 100L;
    private ExecutorService bossThreadPool;

    public SystemTimer() {
        this.timeWheel = new TimingWheel(1L, 20, this.delayQueue::offer);
    }

    public SystemTimer setDelayQueueTimeout(long delayQueueTimeout) {
        this.delayQueueTimeout = delayQueueTimeout;
        return this;
    }

    public SystemTimer start() {
        this.bossThreadPool = ThreadKit.newSingleExecutor();
        this.bossThreadPool.submit(() -> {
            while (this.advanceClock()) {
            }
        });
        return this;
    }

    public void stop() {
        this.bossThreadPool.shutdown();
    }

    public void addTask(TimerTask timerTask) {
        if (!this.timeWheel.addTask(timerTask)) {
            ThreadKit.execAsync((Runnable)timerTask.getTask());
        }
    }

    private boolean advanceClock() {
        try {
            TimerTaskList timerTaskList = this.poll();
            if (null != timerTaskList) {
                this.timeWheel.advanceClock(timerTaskList.getExpire());
                timerTaskList.flush(this::addTask);
            }
        }
        catch (InterruptedException ignore) {
            return false;
        }
        return true;
    }

    private TimerTaskList poll() throws InterruptedException {
        return this.delayQueueTimeout > 0L ? (TimerTaskList)this.delayQueue.poll(this.delayQueueTimeout, TimeUnit.MILLISECONDS) : (TimerTaskList)this.delayQueue.poll();
    }
}

