/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.cron;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.aoju.bus.core.exception.CrontabException;
import org.aoju.bus.core.exception.InternalException;
import org.aoju.bus.core.lang.Charset;
import org.aoju.bus.cron.Scheduler;
import org.aoju.bus.cron.factory.Task;
import org.aoju.bus.cron.pattern.CronPattern;
import org.aoju.bus.setting.magic.PopSetting;

public class Builder {
    public static final String CRONTAB_CONFIG_PATH = "config/cron.setting";
    public static final String CRONTAB_CONFIG_PATH2 = "cron.setting";
    private static final Lock lock = new ReentrantLock();
    private static final Scheduler scheduler = new Scheduler();
    private static PopSetting crontabSetting;

    public static void setCronSetting(PopSetting cronSetting) {
        crontabSetting = cronSetting;
    }

    public static void setCronSetting(String cronSettingPath) {
        try {
            crontabSetting = new PopSetting(cronSettingPath, Charset.UTF_8, false);
        }
        catch (InternalException internalException) {
            // empty catch block
        }
    }

    public static void setMatchSecond(boolean isMatchSecond) {
        scheduler.setMatchSecond(isMatchSecond);
    }

    public static String schedule(String schedulingPattern, Task task) {
        return scheduler.schedule(schedulingPattern, task);
    }

    public static String schedule(String id, String schedulingPattern, Task task) {
        scheduler.schedule(id, schedulingPattern, task);
        return id;
    }

    public static String schedule(String schedulingPattern, Runnable task) {
        return scheduler.schedule(schedulingPattern, task);
    }

    public static void schedule(PopSetting cronSetting) {
        scheduler.schedule(cronSetting);
    }

    public static boolean remove(String schedulerId) {
        return scheduler.descheduleWithStatus(schedulerId);
    }

    public static void updatePattern(String id, CronPattern pattern) {
        scheduler.updatePattern(id, pattern);
    }

    public static Scheduler getScheduler() {
        return scheduler;
    }

    public static void start() {
        Builder.start(false);
    }

    public static synchronized void start(boolean isDaemon) {
        if (scheduler.isStarted()) {
            throw new CrontabException("Scheduler has been started, please stop it first!");
        }
        lock.lock();
        try {
            if (null == crontabSetting) {
                Builder.setCronSetting(CRONTAB_CONFIG_PATH);
            }
            if (null == crontabSetting) {
                Builder.setCronSetting(CRONTAB_CONFIG_PATH2);
            }
        }
        finally {
            lock.unlock();
        }
        Builder.schedule(crontabSetting);
        scheduler.start(isDaemon);
    }

    public static void restart() {
        lock.lock();
        try {
            if (null != crontabSetting) {
                crontabSetting.load();
            }
            if (scheduler.isStarted()) {
                Builder.stop();
            }
        }
        finally {
            lock.unlock();
        }
        Builder.schedule(crontabSetting);
        scheduler.start();
    }

    public static void stop() {
        scheduler.stop(true);
    }
}

