/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.cron;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.aoju.bus.core.exception.CrontabException;
import org.aoju.bus.core.key.UUID;
import org.aoju.bus.core.thread.ExecutorBuilder;
import org.aoju.bus.core.thread.ThreadBuilder;
import org.aoju.bus.core.toolkit.MapKit;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.cron.Configure;
import org.aoju.bus.cron.CronTimer;
import org.aoju.bus.cron.Manager;
import org.aoju.bus.cron.Repertoire;
import org.aoju.bus.cron.Supervisor;
import org.aoju.bus.cron.factory.InvokeTask;
import org.aoju.bus.cron.factory.RunnableTask;
import org.aoju.bus.cron.factory.Task;
import org.aoju.bus.cron.listener.TaskListener;
import org.aoju.bus.cron.listener.TaskListenerManager;
import org.aoju.bus.cron.pattern.CronPattern;
import org.aoju.bus.logger.Logger;
import org.aoju.bus.setting.magic.PopSetting;

public class Scheduler
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Lock lock = new ReentrantLock();
    protected Configure config = new Configure();
    protected boolean daemon;
    protected Repertoire repertoire = new Repertoire();
    protected Supervisor supervisor;
    protected Manager manager;
    protected TaskListenerManager listenerManager = new TaskListenerManager();
    protected ExecutorService threadExecutor;
    private boolean started = false;
    private CronTimer timer;

    public TimeZone getTimeZone() {
        return this.config.getTimeZone();
    }

    public Scheduler setTimeZone(TimeZone timeZone) {
        this.config.setTimeZone(timeZone);
        return this;
    }

    public Scheduler setThreadExecutor(ExecutorService threadExecutor) throws CrontabException {
        this.lock.lock();
        try {
            this.checkStarted();
            this.threadExecutor = threadExecutor;
        }
        finally {
            this.lock.unlock();
        }
        return this;
    }

    public boolean isDaemon() {
        return this.daemon;
    }

    public Scheduler setDaemon(boolean on) throws CrontabException {
        this.lock.lock();
        try {
            this.checkStarted();
            this.daemon = on;
        }
        finally {
            this.lock.unlock();
        }
        return this;
    }

    public boolean isMatchSecond() {
        return this.config.isMatchSecond();
    }

    public Scheduler setMatchSecond(boolean isMatchSecond) {
        this.config.setMatchSecond(isMatchSecond);
        return this;
    }

    public Scheduler addListener(TaskListener listener) {
        this.listenerManager.addListener(listener);
        return this;
    }

    public Scheduler removeListener(TaskListener listener) {
        this.listenerManager.removeListener(listener);
        return this;
    }

    public Scheduler schedule(PopSetting cronSetting) {
        if (MapKit.isNotEmpty((Map)cronSetting)) {
            for (Map.Entry groupedEntry : cronSetting.getGroupMap().entrySet()) {
                String group = (String)groupedEntry.getKey();
                for (Map.Entry entry : ((LinkedHashMap)groupedEntry.getValue()).entrySet()) {
                    Object jobClass = (String)entry.getKey();
                    if (StringKit.isNotBlank((CharSequence)group)) {
                        jobClass = group + "." + (String)jobClass;
                    }
                    String pattern = (String)entry.getValue();
                    Logger.debug((String)"Load job: {} {}", (Object[])new Object[]{pattern, jobClass});
                    try {
                        this.schedule("id_" + (String)jobClass, pattern, (Task)new InvokeTask((String)jobClass));
                    }
                    catch (Exception e) {
                        throw new CrontabException("Schedule [{}] [{}] error!", new Object[]{pattern, jobClass});
                    }
                }
            }
        }
        return this;
    }

    public String schedule(String pattern, Runnable task) {
        return this.schedule(pattern, new RunnableTask(task));
    }

    public String schedule(String pattern, Task task) {
        String id = UUID.randomUUID().toString();
        this.schedule(id, pattern, task);
        return id;
    }

    public Scheduler schedule(String id, String pattern, Runnable task) {
        return this.schedule(id, new CronPattern(pattern), (Task)new RunnableTask(task));
    }

    public Scheduler schedule(String id, String pattern, Task task) {
        return this.schedule(id, new CronPattern(pattern), task);
    }

    public Scheduler schedule(String id, CronPattern pattern, Task task) {
        this.repertoire.add(id, pattern, task);
        return this;
    }

    public Scheduler deschedule(String id) {
        this.descheduleWithStatus(id);
        return this;
    }

    public boolean descheduleWithStatus(String id) {
        return this.repertoire.remove(id);
    }

    public Scheduler updatePattern(String id, CronPattern pattern) {
        this.repertoire.updatePattern(id, pattern);
        return this;
    }

    public Repertoire getTaskTable() {
        return this.repertoire;
    }

    public CronPattern getPattern(String id) {
        return this.repertoire.getPattern(id);
    }

    public Task getTask(String id) {
        return this.repertoire.getTask(id);
    }

    public boolean isEmpty() {
        return this.repertoire.isEmpty();
    }

    public int size() {
        return this.repertoire.size();
    }

    public Scheduler clear() {
        this.repertoire = new Repertoire();
        return this;
    }

    public boolean isStarted() {
        return this.started;
    }

    public Scheduler start(boolean isDaemon) {
        this.daemon = isDaemon;
        return this.start();
    }

    public Scheduler start() {
        this.lock.lock();
        try {
            this.checkStarted();
            if (null == this.threadExecutor) {
                this.threadExecutor = ExecutorBuilder.create().useSynchronousQueue().setThreadFactory(ThreadBuilder.create().setNamePrefix("exec-cron-").setDaemon(this.daemon).build()).build();
            }
            this.supervisor = new Supervisor(this);
            this.manager = new Manager(this);
            this.timer = new CronTimer(this);
            this.timer.setDaemon(this.daemon);
            this.timer.start();
            this.started = true;
        }
        finally {
            this.lock.unlock();
        }
        return this;
    }

    public Scheduler stop() {
        return this.stop(false);
    }

    public Scheduler stop(boolean clearTasks) {
        this.lock.lock();
        try {
            if (!this.started) {
                throw new IllegalStateException("Scheduler not started !");
            }
            this.timer.stopTimer();
            this.timer = null;
            this.threadExecutor.shutdown();
            this.threadExecutor = null;
            if (clearTasks) {
                this.clear();
            }
            this.started = false;
        }
        finally {
            this.lock.unlock();
        }
        return this;
    }

    private void checkStarted() throws CrontabException {
        if (this.started) {
            throw new CrontabException("Scheduler already started!");
        }
    }
}

