/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.crypto.factory;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.aoju.bus.core.consts.Charset;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.crypto.CryptoFactory;
import org.aoju.bus.crypto.Mode;

public class AesCryptoFactory
implements CryptoFactory {
    private volatile Cipher encryptCipher = null;
    private volatile Cipher decryptCipher = null;

    @Override
    public byte[] encrypt(String key, byte[] content) {
        try {
            return this.encryptCipher(key).doFinal(content);
        }
        catch (Exception e) {
            throw new InstrumentException((Throwable)e);
        }
    }

    @Override
    public byte[] decrypt(String key, byte[] content) {
        try {
            return this.decryptCipher(key).doFinal(content);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new InstrumentException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Cipher encryptCipher(String key) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException {
        if (this.encryptCipher != null) return this.encryptCipher;
        Class<AesCryptoFactory> clazz = AesCryptoFactory.class;
        synchronized (AesCryptoFactory.class) {
            if (this.encryptCipher != null) return this.encryptCipher;
            KeyGenerator generator = KeyGenerator.getInstance(Mode.AES.getValue());
            SecureRandom random = SecureRandom.getInstance(Mode.SHAPRNG.getValue());
            random.setSeed(key.getBytes(Charset.UTF_8));
            generator.init(128, random);
            SecretKey secretKey = generator.generateKey();
            byte[] enCodeFormat = secretKey.getEncoded();
            SecretKeySpec spec = new SecretKeySpec(enCodeFormat, Mode.AES.getValue());
            Cipher cipher = Cipher.getInstance(Mode.AES.getValue());
            cipher.init(1, spec);
            this.encryptCipher = cipher;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.encryptCipher;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Cipher decryptCipher(String key) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException {
        if (this.decryptCipher != null) return this.decryptCipher;
        Class<AesCryptoFactory> clazz = AesCryptoFactory.class;
        synchronized (AesCryptoFactory.class) {
            if (this.decryptCipher != null) return this.decryptCipher;
            KeyGenerator generator = KeyGenerator.getInstance(Mode.AES.getValue());
            SecureRandom random = SecureRandom.getInstance(Mode.SHAPRNG.getValue());
            random.setSeed(key.getBytes(Charset.UTF_8));
            generator.init(128, random);
            SecretKey secretKey = generator.generateKey();
            byte[] enCodeFormat = secretKey.getEncoded();
            SecretKeySpec spec = new SecretKeySpec(enCodeFormat, Mode.AES.getValue());
            Cipher cipher = Cipher.getInstance(Mode.AES.getValue());
            cipher.init(2, spec);
            this.decryptCipher = cipher;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.decryptCipher;
        }
    }
}

