/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.crypto.symmetric;

import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import org.aoju.bus.core.utils.StringUtils;
import org.aoju.bus.crypto.CryptoUtils;
import org.aoju.bus.crypto.Mode;
import org.aoju.bus.crypto.Padding;
import org.aoju.bus.crypto.symmetric.Symmetric;

public class DESede
extends Symmetric {
    public DESede() {
        super(Mode.DESede);
    }

    public DESede(byte[] key) {
        super(Mode.DESede, key);
    }

    public DESede(Mode mode, Padding padding) {
        this(mode.name(), padding.name());
    }

    public DESede(Mode mode, Padding padding, byte[] key) {
        this(mode, padding, key, null);
    }

    public DESede(Mode mode, Padding padding, byte[] key, byte[] iv) {
        this(mode.name(), padding.name(), key, iv);
    }

    public DESede(Mode mode, Padding padding, SecretKey key) {
        this(mode, padding, key, null);
    }

    public DESede(Mode mode, Padding padding, SecretKey key, IvParameterSpec iv) {
        this(mode.name(), padding.name(), key, iv);
    }

    public DESede(String mode, String padding) {
        this(mode, padding, (byte[])null);
    }

    public DESede(String mode, String padding, byte[] key) {
        this(mode, padding, key, null);
    }

    public DESede(String mode, String padding, byte[] key, byte[] iv) {
        this(mode, padding, CryptoUtils.generateKey(Mode.DESede.getValue(), key), null == iv ? null : new IvParameterSpec(iv));
    }

    public DESede(String mode, String padding, SecretKey key) {
        this(mode, padding, key, null);
    }

    public DESede(String mode, String padding, SecretKey key, IvParameterSpec iv) {
        super(StringUtils.format((String)"{}/{}/{}", (Object[])new Object[]{Mode.DESede.getValue(), mode, padding}), key, iv);
    }

    public DESede setIv(IvParameterSpec iv) {
        super.setParams(iv);
        return this;
    }

    public DESede setIv(byte[] iv) {
        this.setIv(new IvParameterSpec(iv));
        return this;
    }
}

