/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.crypto.asymmetric;

import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Set;
import org.aoju.bus.core.codec.Base64;
import org.aoju.bus.core.lang.exception.CommonException;
import org.aoju.bus.core.utils.CollUtils;
import org.aoju.bus.crypto.CryptoUtils;
import org.aoju.bus.crypto.Mode;
import org.aoju.bus.crypto.asymmetric.BaseAsymmetric;

public class Sign
extends BaseAsymmetric<Sign> {
    protected Signature signature;

    public Sign(Mode mode) {
        this(mode, (byte[])null, (byte[])null);
    }

    public Sign(String mode) {
        this(mode, (byte[])null, (byte[])null);
    }

    public Sign(Mode mode, String privateKeyStr, String publicKeyStr) {
        this(mode.getValue(), CryptoUtils.decode(privateKeyStr), CryptoUtils.decode(publicKeyStr));
    }

    public Sign(Mode mode, byte[] privateKey, byte[] publicKey) {
        this(mode.getValue(), privateKey, publicKey);
    }

    public Sign(Mode mode, KeyPair keyPair) {
        this(mode.getValue(), keyPair);
    }

    public Sign(Mode mode, PrivateKey privateKey, PublicKey publicKey) {
        this(mode.getValue(), privateKey, publicKey);
    }

    public Sign(String mode, String privateKeyBase64, String publicKeyBase64) {
        this(mode, Base64.decode((String)privateKeyBase64), Base64.decode((String)publicKeyBase64));
    }

    public Sign(String mode, byte[] privateKey, byte[] publicKey) {
        this(mode, CryptoUtils.generatePrivateKey(mode, privateKey), CryptoUtils.generatePublicKey(mode, publicKey));
    }

    public Sign(String mode, KeyPair keyPair) {
        this(mode, keyPair.getPrivate(), keyPair.getPublic());
    }

    public Sign(String mode, PrivateKey privateKey, PublicKey publicKey) {
        super(mode, privateKey, publicKey);
    }

    @Override
    public Sign init(String mode, PrivateKey privateKey, PublicKey publicKey) {
        try {
            this.signature = Signature.getInstance(mode);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CommonException((Throwable)e);
        }
        super.init(mode, privateKey, publicKey);
        return this;
    }

    public byte[] sign(byte[] data) {
        this.lock.lock();
        try {
            this.signature.initSign(this.privateKey);
            this.signature.update(data);
            byte[] byArray = this.signature.sign();
            return byArray;
        }
        catch (Exception e) {
            throw new CommonException((Throwable)e);
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean verify(byte[] data, byte[] sign) {
        this.lock.lock();
        try {
            this.signature.initVerify(this.publicKey);
            this.signature.update(data);
            boolean bl = this.signature.verify(sign);
            return bl;
        }
        catch (Exception e) {
            throw new CommonException((Throwable)e);
        }
        finally {
            this.lock.unlock();
        }
    }

    public Signature getSignature() {
        return this.signature;
    }

    public Sign setSignature(Signature signature) {
        this.signature = signature;
        return this;
    }

    public Sign setCertificate(Certificate certificate) {
        boolean[] keyUsageInfo;
        X509Certificate cert;
        Set<String> critSet;
        if (certificate instanceof X509Certificate && CollUtils.isNotEmpty(critSet = (cert = (X509Certificate)certificate).getCriticalExtensionOIDs()) && critSet.contains("2.5.29.15") && (keyUsageInfo = cert.getKeyUsage()) != null && !keyUsageInfo[0]) {
            throw new CommonException("Wrong key usage");
        }
        this.publicKey = certificate.getPublicKey();
        return this;
    }
}

