/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.crypto.digest;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import org.aoju.bus.core.lang.exception.CommonException;
import org.aoju.bus.core.utils.ArrayUtils;
import org.aoju.bus.core.utils.FileUtils;
import org.aoju.bus.core.utils.HexUtils;
import org.aoju.bus.core.utils.IoUtils;
import org.aoju.bus.core.utils.StringUtils;
import org.aoju.bus.crypto.CryptoUtils;
import org.aoju.bus.crypto.Mode;

public class Digester {
    protected byte[] salt;
    protected int saltPosition;
    protected int digestCount;
    private MessageDigest digest;

    public Digester(Mode algorithm) {
        this(algorithm.getValue());
    }

    public Digester(String algorithm) {
        this(algorithm, null);
    }

    public Digester(Mode algorithm, Provider provider) {
        this.init(algorithm.getValue(), provider);
    }

    public Digester(String algorithm, Provider provider) {
        this.init(algorithm, provider);
    }

    public Digester init(String algorithm, Provider provider) {
        if (null == provider) {
            this.digest = CryptoUtils.createMessageDigest(algorithm);
        } else {
            try {
                this.digest = MessageDigest.getInstance(algorithm, provider);
            }
            catch (NoSuchAlgorithmException e) {
                throw new CommonException((Throwable)e);
            }
        }
        return this;
    }

    public Digester setSalt(byte[] salt) {
        this.salt = salt;
        return this;
    }

    public Digester setSaltPosition(int saltPosition) {
        this.saltPosition = saltPosition;
        return this;
    }

    public Digester setDigestCount(int digestCount) {
        this.digestCount = digestCount;
        return this;
    }

    public Digester reset() {
        this.digest.reset();
        return this;
    }

    public byte[] digest(String data, String charset) {
        return this.digest(StringUtils.bytes((CharSequence)data, (String)charset));
    }

    public byte[] digest(String data) {
        return this.digest(data, "UTF-8");
    }

    public String digestHex(String data, String charset) {
        return HexUtils.encodeHexStr((byte[])this.digest(data, charset));
    }

    public String digestHex(String data) {
        return this.digestHex(data, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] digest(File file) throws CommonException {
        BufferedInputStream in = null;
        try {
            in = FileUtils.getInputStream((File)file);
            byte[] byArray = this.digest(in);
            return byArray;
        }
        finally {
            IoUtils.close((Closeable)in);
        }
    }

    public String digestHex(File file) {
        return HexUtils.encodeHexStr((byte[])this.digest(file));
    }

    public byte[] digest(byte[] data) {
        byte[] result = null;
        if (this.saltPosition <= 0) {
            result = this.doDigest(this.salt, data);
        } else if (this.saltPosition >= data.length) {
            result = this.doDigest(data, this.salt);
        } else if (ArrayUtils.isNotEmpty((byte[])this.salt)) {
            this.digest.update(data, 0, this.saltPosition);
            this.digest.update(this.salt);
            this.digest.update(data, this.saltPosition, data.length - this.saltPosition);
            result = this.digest.digest();
        } else {
            result = this.doDigest(new byte[][]{data});
        }
        return this.resetAndRepeatDigest(result);
    }

    public String digestHex(byte[] data) {
        return HexUtils.encodeHexStr((byte[])this.digest(data));
    }

    public byte[] digest(InputStream data) {
        return this.digest(data, 1024);
    }

    public String digestHex(InputStream data) {
        return HexUtils.encodeHexStr((byte[])this.digest(data));
    }

    public byte[] digest(InputStream data, int bufferLength) throws CommonException {
        byte[] result;
        if (bufferLength < 1) {
            bufferLength = 1024;
        }
        try {
            result = ArrayUtils.isEmpty((byte[])this.salt) ? this.digestWithoutSalt(data, bufferLength) : this.digestWithSalt(data, bufferLength);
        }
        catch (IOException e) {
            throw new CommonException((Throwable)e);
        }
        return this.resetAndRepeatDigest(result);
    }

    public String digestHex(InputStream data, int bufferLength) {
        return HexUtils.encodeHexStr((byte[])this.digest(data, bufferLength));
    }

    public MessageDigest getDigest() {
        return this.digest;
    }

    public int getDigestLength() {
        return this.digest.getDigestLength();
    }

    private byte[] digestWithoutSalt(InputStream data, int bufferLength) throws IOException {
        int read;
        byte[] buffer = new byte[bufferLength];
        while ((read = data.read(buffer, 0, bufferLength)) > -1) {
            this.digest.update(buffer, 0, read);
        }
        return this.digest.digest();
    }

    private byte[] digestWithSalt(InputStream data, int bufferLength) throws IOException {
        int read;
        if (this.saltPosition <= 0) {
            this.digest.update(this.salt);
        }
        byte[] buffer = new byte[bufferLength];
        int total = 0;
        while ((read = data.read(buffer, 0, bufferLength)) > -1) {
            if (this.saltPosition > 0 && (total += read) >= this.saltPosition) {
                if (total != this.saltPosition) {
                    this.digest.update(buffer, 0, total - this.saltPosition);
                }
                this.digest.update(this.salt);
                this.digest.update(buffer, total - this.saltPosition, read);
                continue;
            }
            this.digest.update(buffer, 0, read);
        }
        if (total < this.saltPosition) {
            this.digest.update(this.salt);
        }
        return this.digest.digest();
    }

    private byte[] doDigest(byte[] ... datas) {
        for (byte[] data : datas) {
            if (null == data) continue;
            this.digest.update(data);
        }
        return this.digest.digest();
    }

    private byte[] resetAndRepeatDigest(byte[] digestData) {
        int digestCount = Math.max(1, this.digestCount);
        this.reset();
        for (int i = 0; i < digestCount - 1; ++i) {
            digestData = this.doDigest(new byte[][]{digestData});
            this.reset();
        }
        return digestData;
    }
}

