/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.crypto.digest;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.aoju.bus.core.lang.exception.CommonException;
import org.aoju.bus.core.utils.FileUtils;
import org.aoju.bus.core.utils.HexUtils;
import org.aoju.bus.core.utils.IoUtils;
import org.aoju.bus.core.utils.StringUtils;
import org.aoju.bus.crypto.CryptoUtils;
import org.aoju.bus.crypto.Mode;

public class HMac {
    private Mac mac;
    private SecretKey secretKey;

    public HMac(Mode algorithm) {
        this(algorithm, (SecretKey)null);
    }

    public HMac(Mode algorithm, byte[] key) {
        this.init(algorithm.getValue(), key);
    }

    public HMac(Mode algorithm, SecretKey key) {
        this.init(algorithm.getValue(), key);
    }

    public HMac init(String algorithm, byte[] key) {
        return this.init(algorithm, null == key ? null : new SecretKeySpec(key, algorithm));
    }

    public HMac init(String algorithm, SecretKey key) {
        try {
            this.mac = Mac.getInstance(algorithm);
            this.secretKey = null != key ? key : CryptoUtils.generateKey(algorithm);
            this.mac.init(this.secretKey);
        }
        catch (Exception e) {
            throw new CommonException((Throwable)e);
        }
        return this;
    }

    public byte[] digest(String data, String charset) {
        return this.digest(StringUtils.bytes((CharSequence)data, (String)charset));
    }

    public byte[] digest(String data) {
        return this.digest(data, "UTF-8");
    }

    public String digestHex(String data, String charset) {
        return HexUtils.encodeHexStr((byte[])this.digest(data, charset));
    }

    public String digestHex(String data) {
        return this.digestHex(data, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] digest(File file) throws CommonException {
        BufferedInputStream in = null;
        try {
            in = FileUtils.getInputStream((File)file);
            byte[] byArray = this.digest(in);
            return byArray;
        }
        finally {
            IoUtils.close((Closeable)in);
        }
    }

    public String digestHex(File file) {
        return HexUtils.encodeHexStr((byte[])this.digest(file));
    }

    public byte[] digest(byte[] data) {
        byte[] result;
        try {
            result = this.mac.doFinal(data);
        }
        finally {
            this.mac.reset();
        }
        return result;
    }

    public String digestHex(byte[] data) {
        return HexUtils.encodeHexStr((byte[])this.digest(data));
    }

    public byte[] digest(InputStream data) {
        return this.digest(data, 1024);
    }

    public String digestHex(InputStream data) {
        return HexUtils.encodeHexStr((byte[])this.digest(data));
    }

    public byte[] digest(InputStream data, int bufferLength) {
        if (bufferLength < 1) {
            bufferLength = 1024;
        }
        byte[] buffer = new byte[bufferLength];
        byte[] result = null;
        try {
            int read = data.read(buffer, 0, bufferLength);
            while (read > -1) {
                this.mac.update(buffer, 0, read);
                read = data.read(buffer, 0, bufferLength);
            }
            result = this.mac.doFinal();
        }
        catch (IOException e) {
            throw new CommonException((Throwable)e);
        }
        finally {
            this.mac.reset();
        }
        return result;
    }

    public String digestHex(InputStream data, int bufferLength) {
        return HexUtils.encodeHexStr((byte[])this.digest(data, bufferLength));
    }

    public Mac getMac() {
        return this.mac;
    }

    public SecretKey getSecretKey() {
        return this.secretKey;
    }
}

