/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.crypto.factory;

import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import org.aoju.bus.core.consts.Charset;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.crypto.CryptoFactory;

public class DesCryptoFactory
implements CryptoFactory {
    private volatile Cipher encryptCipher = null;
    private volatile Cipher decryptCipher = null;

    @Override
    public byte[] encrypt(String key, byte[] content) {
        try {
            return this.encryptCipher(key).doFinal(content);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | InvalidKeySpecException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new InstrumentException((Throwable)e);
        }
    }

    @Override
    public byte[] decrypt(String key, byte[] content) throws RuntimeException {
        try {
            return this.decryptCipher(key).doFinal(content);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | InvalidKeySpecException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new InstrumentException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Cipher encryptCipher(String key) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidKeyException {
        if (this.encryptCipher != null) return this.encryptCipher;
        Class<DesCryptoFactory> clazz = DesCryptoFactory.class;
        synchronized (DesCryptoFactory.class) {
            if (this.encryptCipher != null) return this.encryptCipher;
            SecureRandom random = new SecureRandom();
            DESKeySpec desKey = new DESKeySpec(key.getBytes(Charset.UTF_8));
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DES");
            Cipher cipher = Cipher.getInstance("DES");
            cipher.init(1, (Key)keyFactory.generateSecret(desKey), random);
            this.encryptCipher = cipher;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.encryptCipher;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Cipher decryptCipher(String key) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidKeySpecException {
        if (this.decryptCipher != null) return this.decryptCipher;
        Class<DesCryptoFactory> clazz = DesCryptoFactory.class;
        synchronized (DesCryptoFactory.class) {
            if (this.decryptCipher != null) return this.decryptCipher;
            SecureRandom random = new SecureRandom();
            DESKeySpec desKey = new DESKeySpec(key.getBytes(Charset.UTF_8));
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DES");
            Cipher cipher = Cipher.getInstance("DES");
            cipher.init(2, (Key)keyFactory.generateSecret(desKey), random);
            this.decryptCipher = cipher;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.decryptCipher;
        }
    }
}

