/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.crypto.factory;

import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.crypto.CryptoFactory;

public class RsaCryptoFactory
implements CryptoFactory {
    private volatile Cipher encryptCipher = null;
    private volatile Cipher decryptCipher = null;

    @Override
    public byte[] encrypt(String key, byte[] content) throws RuntimeException {
        try {
            return this.encryptCipher(key).doFinal(content);
        }
        catch (IOException | InvalidKeyException | NoSuchAlgorithmException | InvalidKeySpecException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new InstrumentException((Throwable)e);
        }
    }

    @Override
    public byte[] decrypt(String key, byte[] content) throws RuntimeException {
        try {
            return this.decryptCipher(key).doFinal(content);
        }
        catch (IOException | InvalidKeyException | NoSuchAlgorithmException | InvalidKeySpecException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new InstrumentException((Throwable)e);
        }
    }

    private PublicKey getPublicKey(String key) throws NoSuchAlgorithmException, InvalidKeySpecException {
        byte[] keyBytes = Base64.getDecoder().decode(key);
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        return keyFactory.generatePublic(keySpec);
    }

    private PrivateKey getPrivateKey(String key) throws NoSuchAlgorithmException, InvalidKeySpecException {
        byte[] keyBytes = Base64.getDecoder().decode(key);
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        return keyFactory.generatePrivate(keySpec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Cipher encryptCipher(String key) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IOException, InvalidKeySpecException {
        if (this.encryptCipher != null) return this.encryptCipher;
        Class<RsaCryptoFactory> clazz = RsaCryptoFactory.class;
        synchronized (RsaCryptoFactory.class) {
            if (this.encryptCipher != null) return this.encryptCipher;
            Cipher cipher = Cipher.getInstance("RSA");
            cipher.init(1, this.getPublicKey(key));
            this.encryptCipher = cipher;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.encryptCipher;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Cipher decryptCipher(String key) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IOException, InvalidKeySpecException {
        if (this.decryptCipher != null) return this.decryptCipher;
        Class<RsaCryptoFactory> clazz = RsaCryptoFactory.class;
        synchronized (RsaCryptoFactory.class) {
            if (this.decryptCipher != null) return this.decryptCipher;
            Cipher cipher = Cipher.getInstance("RSA");
            cipher.init(2, this.getPrivateKey(key));
            this.decryptCipher = cipher;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.decryptCipher;
        }
    }
}

