/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.crypto.symmetric;

import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import org.aoju.bus.core.utils.StringUtils;
import org.aoju.bus.crypto.CryptoUtils;
import org.aoju.bus.crypto.Padding;
import org.aoju.bus.crypto.symmetric.Symmetric;

public class AES
extends Symmetric {
    public AES() {
        super("AES");
    }

    public AES(byte[] key) {
        super("AES", key);
    }

    public AES(String mode, Padding padding) {
        this(mode, padding.name());
    }

    public AES(String mode, Padding padding, byte[] key) {
        this(mode, padding, key, null);
    }

    public AES(String mode, Padding padding, byte[] key, byte[] iv) {
        this(mode, padding.name(), key, iv);
    }

    public AES(String mode, Padding padding, SecretKey key) {
        this(mode, padding, key, null);
    }

    public AES(String mode, Padding padding, SecretKey key, IvParameterSpec iv) {
        this(mode, padding.name(), key, iv);
    }

    public AES(String mode, String padding) {
        this(mode, padding, (byte[])null);
    }

    public AES(String mode, String padding, byte[] key) {
        this(mode, padding, key, null);
    }

    public AES(String mode, String padding, byte[] key, byte[] iv) {
        this(mode, padding, CryptoUtils.generateKey("AES", key), null == iv ? null : new IvParameterSpec(iv));
    }

    public AES(String mode, String padding, SecretKey key) {
        this(mode, padding, key, null);
    }

    public AES(String mode, String padding, SecretKey key, IvParameterSpec iv) {
        super(StringUtils.format((String)"AES/{}/{}", (Object[])new Object[]{mode, padding}), key, iv);
    }

    public AES setIv(IvParameterSpec iv) {
        super.setParams(iv);
        return this;
    }

    public AES setIv(byte[] iv) {
        this.setIv(new IvParameterSpec(iv));
        return this;
    }
}

