/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.crypto;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECFieldFp;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.EllipticCurve;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.aoju.bus.core.codec.Base64;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.lang.Validator;
import org.aoju.bus.core.lang.exception.CommonException;
import org.aoju.bus.core.utils.ArrayUtils;
import org.aoju.bus.core.utils.HexUtils;
import org.aoju.bus.core.utils.IoUtils;
import org.aoju.bus.core.utils.MapUtils;
import org.aoju.bus.core.utils.RandomUtils;
import org.aoju.bus.core.utils.StringUtils;
import org.aoju.bus.crypto.BouncyCastleProvider;
import org.aoju.bus.crypto.CryptoFactory;
import org.aoju.bus.crypto.asymmetric.RSA;
import org.aoju.bus.crypto.asymmetric.SM2;
import org.aoju.bus.crypto.asymmetric.Sign;
import org.aoju.bus.crypto.digest.BCrypt;
import org.aoju.bus.crypto.digest.Digester;
import org.aoju.bus.crypto.digest.HMac;
import org.aoju.bus.crypto.digest.MD5;
import org.aoju.bus.crypto.factory.AesCryptoFactory;
import org.aoju.bus.crypto.factory.DesCryptoFactory;
import org.aoju.bus.crypto.factory.RsaCryptoFactory;
import org.aoju.bus.crypto.symmetric.AES;
import org.aoju.bus.crypto.symmetric.DES;
import org.aoju.bus.crypto.symmetric.DESede;
import org.aoju.bus.crypto.symmetric.RC4;
import org.aoju.bus.crypto.symmetric.Symmetric;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.ECPointUtil;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.jce.spec.ECNamedCurveSpec;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemReader;

public final class CryptoUtils {
    public static final String KEY_STORE = "JKS";
    public static final String X509 = "X.509";
    public static final int DEFAULT_KEY_SIZE = 1024;
    public static final String SM2_DEFAULT_CURVE = "sm2p256v1";
    private static final int RS_LEN = 32;
    private static final int[] DEC = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, -1, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15};
    private static final byte[] HEX = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};
    private static final char[] hex = "0123456789abcdef".toCharArray();
    private static String SM3 = "SM3";
    private static String SM4 = "SM4";

    public static SecretKey generateKey(String mode) {
        return CryptoUtils.generateKey(mode, -1);
    }

    public static SecretKey generateKey(String mode, int keySize) {
        mode = CryptoUtils.getMainAlgorithm(mode);
        KeyGenerator keyGenerator = CryptoUtils.getKeyGenerator(mode);
        if (keySize > 0) {
            keyGenerator.init(keySize);
        } else if ("AES".equals(mode)) {
            keyGenerator.init(128);
        }
        return keyGenerator.generateKey();
    }

    public static SecretKey generateKey(String mode, byte[] key) {
        Assert.notBlank((String)mode, (String)"mode is blank!", (Object[])new Object[0]);
        SecretKey secretKey = mode.startsWith("PBE") ? CryptoUtils.generatePBEKey(mode, null == key ? null : StringUtils.str((byte[])key, (String)"/").toCharArray()) : (mode.startsWith("DES") ? CryptoUtils.generateDESKey(mode, key) : (null == key ? CryptoUtils.generateKey(mode) : new SecretKeySpec(key, mode)));
        return secretKey;
    }

    public static SecretKey generateDESKey(String mode, byte[] key) {
        if (StringUtils.isBlank((CharSequence)mode) || !mode.startsWith("DES")) {
            throw new CommonException("mode [{}] is not a DES mode!");
        }
        SecretKey secretKey = null;
        if (null == key) {
            secretKey = CryptoUtils.generateKey(mode);
        } else {
            KeySpec keySpec;
            try {
                keySpec = mode.startsWith("DESede") ? new DESedeKeySpec(key) : new DESKeySpec(key);
            }
            catch (InvalidKeyException e) {
                throw new CommonException((Throwable)e);
            }
            secretKey = CryptoUtils.generateKey(mode, keySpec);
        }
        return secretKey;
    }

    public static SecretKey generatePBEKey(String mode, char[] key) {
        if (StringUtils.isBlank((CharSequence)mode) || !mode.startsWith("PBE")) {
            throw new CommonException("mode [{}] is not a PBE mode!");
        }
        if (null == key) {
            key = RandomUtils.randomString((int)32).toCharArray();
        }
        PBEKeySpec keySpec = new PBEKeySpec(key);
        return CryptoUtils.generateKey(mode, keySpec);
    }

    public static SecretKey generateKey(String mode, KeySpec keySpec) {
        SecretKeyFactory keyFactory = CryptoUtils.getSecretKeyFactory(mode);
        try {
            return keyFactory.generateSecret(keySpec);
        }
        catch (InvalidKeySpecException e) {
            throw new CommonException((Throwable)e);
        }
    }

    public static PrivateKey generateRSAPrivateKey(byte[] key) {
        return CryptoUtils.generatePrivateKey("RSA", key);
    }

    public static PrivateKey generatePrivateKey(String mode, byte[] key) {
        if (null == key) {
            return null;
        }
        return CryptoUtils.generatePrivateKey(mode, new PKCS8EncodedKeySpec(key));
    }

    public static PrivateKey generatePrivateKey(String mode, KeySpec keySpec) {
        if (null == keySpec) {
            return null;
        }
        mode = CryptoUtils.getAlgorithmAfterWith(mode);
        try {
            return CryptoUtils.getKeyFactory(mode).generatePrivate(keySpec);
        }
        catch (Exception e) {
            throw new CommonException((Throwable)e);
        }
    }

    public static PrivateKey generatePrivateKey(KeyStore keyStore, String alias, char[] password) {
        try {
            return (PrivateKey)keyStore.getKey(alias, password);
        }
        catch (Exception e) {
            throw new CommonException((Throwable)e);
        }
    }

    public static PublicKey generateRSAPublicKey(byte[] key) {
        return CryptoUtils.generatePublicKey("RSA", key);
    }

    public static PublicKey generatePublicKey(String mode, byte[] key) {
        if (null == key) {
            return null;
        }
        return CryptoUtils.generatePublicKey(mode, new X509EncodedKeySpec(key));
    }

    public static PublicKey generatePublicKey(String mode, KeySpec keySpec) {
        if (null == keySpec) {
            return null;
        }
        mode = CryptoUtils.getAlgorithmAfterWith(mode);
        try {
            return CryptoUtils.getKeyFactory(mode).generatePublic(keySpec);
        }
        catch (Exception e) {
            throw new CommonException((Throwable)e);
        }
    }

    public static KeyPair generateKeyPair(String mode) {
        return CryptoUtils.generateKeyPair(mode, 1024);
    }

    public static KeyPair generateKeyPair(String mode, int keySize) {
        return CryptoUtils.generateKeyPair(mode, keySize, null);
    }

    public static KeyPair generateKeyPair(String mode, int keySize, byte[] seed) {
        if ("SM2".equalsIgnoreCase(mode)) {
            ECGenParameterSpec sm2p256v1 = new ECGenParameterSpec(SM2_DEFAULT_CURVE);
            return CryptoUtils.generateKeyPair(mode, keySize, seed, sm2p256v1);
        }
        return CryptoUtils.generateKeyPair(mode, keySize, seed, null);
    }

    public static KeyPair generateKeyPair(String mode, AlgorithmParameterSpec params) {
        return CryptoUtils.generateKeyPair(mode, null, params);
    }

    public static KeyPair generateKeyPair(String mode, byte[] seed, AlgorithmParameterSpec param) {
        return CryptoUtils.generateKeyPair(mode, 1024, seed, param);
    }

    public static KeyPair generateKeyPair(String mode, int keySize, byte[] seed, AlgorithmParameterSpec ... params) {
        mode = CryptoUtils.getAlgorithmAfterWith(mode);
        KeyPairGenerator keyPairGen = CryptoUtils.getKeyPairGenerator(mode);
        if (keySize > 0) {
            if ("EC".equalsIgnoreCase(mode) && keySize > 256) {
                keySize = 256;
            }
            if (null != seed) {
                keyPairGen.initialize(keySize, new SecureRandom(seed));
            } else {
                keyPairGen.initialize(keySize);
            }
        }
        if (ArrayUtils.isNotEmpty((Object[])params)) {
            for (AlgorithmParameterSpec param : params) {
                if (null == param) continue;
                try {
                    if (null != seed) {
                        keyPairGen.initialize(param, new SecureRandom(seed));
                        continue;
                    }
                    keyPairGen.initialize(param);
                }
                catch (InvalidAlgorithmParameterException e) {
                    throw new CommonException((Throwable)e);
                }
            }
        }
        return keyPairGen.generateKeyPair();
    }

    public static KeyPairGenerator getKeyPairGenerator(String mode) {
        KeyPairGenerator keyPairGen;
        Provider provider = BouncyCastleProvider.INSTANCE.getProvider();
        try {
            keyPairGen = null == provider ? KeyPairGenerator.getInstance(CryptoUtils.getMainAlgorithm(mode)) : KeyPairGenerator.getInstance(CryptoUtils.getMainAlgorithm(mode), provider);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CommonException((Throwable)e);
        }
        return keyPairGen;
    }

    public static KeyFactory getKeyFactory(String mode) {
        KeyFactory keyFactory;
        Provider provider = BouncyCastleProvider.INSTANCE.getProvider();
        try {
            keyFactory = null == provider ? KeyFactory.getInstance(CryptoUtils.getMainAlgorithm(mode)) : KeyFactory.getInstance(CryptoUtils.getMainAlgorithm(mode), provider);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CommonException((Throwable)e);
        }
        return keyFactory;
    }

    public static SecretKeyFactory getSecretKeyFactory(String mode) {
        SecretKeyFactory keyFactory;
        Provider provider = BouncyCastleProvider.INSTANCE.getProvider();
        try {
            keyFactory = null == provider ? SecretKeyFactory.getInstance(CryptoUtils.getMainAlgorithm(mode)) : SecretKeyFactory.getInstance(CryptoUtils.getMainAlgorithm(mode), provider);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CommonException((Throwable)e);
        }
        return keyFactory;
    }

    public static KeyGenerator getKeyGenerator(String mode) {
        KeyGenerator generator;
        Provider provider = BouncyCastleProvider.INSTANCE.getProvider();
        try {
            generator = null == provider ? KeyGenerator.getInstance(CryptoUtils.getMainAlgorithm(mode)) : KeyGenerator.getInstance(CryptoUtils.getMainAlgorithm(mode), provider);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CommonException((Throwable)e);
        }
        return generator;
    }

    public static String getAlgorithmAfterWith(String mode) {
        Assert.notNull((Object)mode, (String)"mode must be not null !", (Object[])new Object[0]);
        int indexOfWith = StringUtils.lastIndexOfIgnoreCase((CharSequence)mode, (CharSequence)"with");
        if (indexOfWith > 0) {
            mode = StringUtils.subSuf((CharSequence)mode, (int)(indexOfWith + "with".length()));
        }
        if ("ECDSA".equalsIgnoreCase(mode) || "SM2".equalsIgnoreCase(mode)) {
            mode = "EC";
        }
        return mode;
    }

    public static KeyStore readJKSKeyStore(InputStream in, char[] password) {
        return CryptoUtils.readKeyStore(KEY_STORE, in, password);
    }

    public static KeyStore readKeyStore(String type, InputStream in, char[] password) {
        KeyStore keyStore = null;
        try {
            keyStore = KeyStore.getInstance(type);
            keyStore.load(in, password);
        }
        catch (Exception e) {
            throw new CommonException((Throwable)e);
        }
        return keyStore;
    }

    public static KeyPair getKeyPair(String type, InputStream in, char[] password, String alias) {
        KeyStore keyStore = CryptoUtils.readKeyStore(type, in, password);
        return CryptoUtils.getKeyPair(keyStore, password, alias);
    }

    public static KeyPair getKeyPair(KeyStore keyStore, char[] password, String alias) {
        PrivateKey privateKey;
        PublicKey publicKey;
        try {
            publicKey = keyStore.getCertificate(alias).getPublicKey();
            privateKey = (PrivateKey)keyStore.getKey(alias, password);
        }
        catch (Exception e) {
            throw new CommonException((Throwable)e);
        }
        return new KeyPair(publicKey, privateKey);
    }

    public static Certificate readX509Certificate(InputStream in, char[] password, String alias) {
        return CryptoUtils.readCertificate(X509, in, password, alias);
    }

    public static PublicKey readPublicKeyFromCert(InputStream in) {
        Certificate certificate = CryptoUtils.readX509Certificate(in);
        if (null != certificate) {
            return certificate.getPublicKey();
        }
        return null;
    }

    public static Certificate readX509Certificate(InputStream in) {
        return CryptoUtils.readCertificate(X509, in);
    }

    public static Certificate readCertificate(String type, InputStream in, char[] password, String alias) {
        KeyStore keyStore = CryptoUtils.readKeyStore(type, in, password);
        try {
            return keyStore.getCertificate(alias);
        }
        catch (KeyStoreException e) {
            throw new CommonException((Throwable)e);
        }
    }

    public static Certificate readCertificate(String type, InputStream in) {
        try {
            return CryptoUtils.getCertificateFactory(type).generateCertificate(in);
        }
        catch (CertificateException e) {
            throw new CommonException((Throwable)e);
        }
    }

    public static Certificate getCertificate(KeyStore keyStore, String alias) {
        try {
            return keyStore.getCertificate(alias);
        }
        catch (Exception e) {
            throw new CommonException((Throwable)e);
        }
    }

    public static CertificateFactory getCertificateFactory(String type) {
        CertificateFactory factory;
        Provider provider = BouncyCastleProvider.INSTANCE.getProvider();
        try {
            factory = null == provider ? CertificateFactory.getInstance(type) : CertificateFactory.getInstance(type, provider);
        }
        catch (CertificateException e) {
            throw new CommonException((Throwable)e);
        }
        return factory;
    }

    public static String getMainAlgorithm(String mode) {
        int slashIndex = mode.indexOf(47);
        if (slashIndex > 0) {
            return mode.substring(0, slashIndex);
        }
        return mode;
    }

    public static AES aes() {
        return new AES();
    }

    public static AES aes(byte[] key) {
        return new AES(key);
    }

    public static DES des() {
        return new DES();
    }

    public static DES des(byte[] key) {
        return new DES(key);
    }

    public static DESede desede() {
        return new DESede();
    }

    public static DESede desede(byte[] key) {
        return new DESede(key);
    }

    public static MD5 md5() {
        return new MD5();
    }

    public static String md5(String data) {
        return new MD5().digestHex(data);
    }

    public static String md5(InputStream data) {
        return new MD5().digestHex(data);
    }

    public static String md5(File dataFile) {
        return new MD5().digestHex(dataFile);
    }

    public static Digester sha1() {
        return new Digester("SHA-1");
    }

    public static String sha1(String data) {
        return new Digester("SHA-1").digestHex(data);
    }

    public static String sha1(InputStream data) {
        return new Digester("SHA-1").digestHex(data);
    }

    public static String sha1(File dataFile) {
        return new Digester("SHA-1").digestHex(dataFile);
    }

    public static Digester sha256() {
        return new Digester("SHA-256");
    }

    public static String sha256(String data) {
        return new Digester("SHA-256").digestHex(data);
    }

    public static String sha256(InputStream data) {
        return new Digester("SHA-256").digestHex(data);
    }

    public static String sha256(File dataFile) {
        return new Digester("SHA-256").digestHex(dataFile);
    }

    public static HMac hmac(String mode, String key) {
        return new HMac(mode, StringUtils.bytes((CharSequence)key));
    }

    public static HMac hmac(String mode, byte[] key) {
        return new HMac(mode, key);
    }

    public static HMac hmac(String mode, SecretKey key) {
        return new HMac(mode, key);
    }

    public static HMac hmacMd5(String key) {
        return CryptoUtils.hmacMd5(StringUtils.bytes((CharSequence)key));
    }

    public static HMac hmacMd5(byte[] key) {
        return new HMac("HmacMD5", key);
    }

    public static HMac hmacMd5() {
        return new HMac("HmacMD5");
    }

    public static HMac hmacSha1(String key) {
        return CryptoUtils.hmacSha1(StringUtils.bytes((CharSequence)key));
    }

    public static HMac hmacSha1(byte[] key) {
        return new HMac("HmacSHA1", key);
    }

    public static HMac hmacSha1() {
        return new HMac("HmacSHA1");
    }

    public static RSA rsa() {
        return new RSA();
    }

    public static RSA rsa(String privateKeyBase64, String publicKeyBase64) {
        return new RSA(privateKeyBase64, publicKeyBase64);
    }

    public static RSA rsa(byte[] privateKey, byte[] publicKey) {
        return new RSA(privateKey, publicKey);
    }

    public static Sign sign(String mode) {
        return new Sign(mode);
    }

    public static Sign sign(String mode, String privateKeyBase64, String publicKeyBase64) {
        return new Sign(mode, privateKeyBase64, publicKeyBase64);
    }

    public static Sign sign(String mode, byte[] privateKey, byte[] publicKey) {
        return new Sign(mode, privateKey, publicKey);
    }

    public static String signParams(Symmetric crypto, Map<?, ?> params) {
        return CryptoUtils.signParams(crypto, params, "", "", true);
    }

    public static String signParams(Symmetric crypto, Map<?, ?> params, String separator, String keyValueSeparator, boolean isIgnoreNull) {
        if (MapUtils.isEmpty(params)) {
            return null;
        }
        String paramsStr = MapUtils.join((Map)MapUtils.sort(params), (String)separator, (String)keyValueSeparator, (boolean)isIgnoreNull);
        return crypto.encryptHex(paramsStr);
    }

    public static String signParamsMd5(Map<?, ?> params) {
        return CryptoUtils.signParams("MD5", params);
    }

    public static String signParamsSha1(Map<?, ?> params) {
        return CryptoUtils.signParams("SHA-1", params);
    }

    public static String signParamsSha256(Map<?, ?> params) {
        return CryptoUtils.signParams("SHA-256", params);
    }

    public static String signParams(String Mode, Map<?, ?> params) {
        return CryptoUtils.signParams(Mode, params, "", "", true);
    }

    public static String signParams(String Mode, Map<?, ?> params, String separator, String keyValueSeparator, boolean isIgnoreNull) {
        if (MapUtils.isEmpty(params)) {
            return null;
        }
        String paramsStr = MapUtils.join((Map)MapUtils.sort(params), (String)separator, (String)keyValueSeparator, (boolean)isIgnoreNull);
        return new Digester(Mode).digestHex(paramsStr);
    }

    public static void addProvider(Provider provider) {
        Security.insertProviderAt(provider, 0);
    }

    public static byte[] decode(String key) {
        return Validator.isHex((CharSequence)key) ? HexUtils.decodeHex((String)key) : Base64.decode((String)key);
    }

    public static Cipher createCipher(String mode) {
        Cipher cipher;
        Provider provider = BouncyCastleProvider.INSTANCE.getProvider();
        try {
            cipher = null == provider ? Cipher.getInstance(mode) : Cipher.getInstance(mode, provider);
        }
        catch (Exception e) {
            throw new CommonException((Throwable)e);
        }
        return cipher;
    }

    public static MessageDigest createMessageDigest(String mode) {
        MessageDigest messageDigest;
        Provider provider = BouncyCastleProvider.INSTANCE.getProvider();
        try {
            messageDigest = null == provider ? MessageDigest.getInstance(mode) : MessageDigest.getInstance(mode, provider);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CommonException((Throwable)e);
        }
        return messageDigest;
    }

    public static RC4 rc4(String key) {
        return new RC4(key);
    }

    public static void disableBouncyCastle() {
        BouncyCastleProvider.setUseBouncyCastle(false);
    }

    public static byte[] encodeECPublicKey(PublicKey publicKey) {
        return ((BCECPublicKey)publicKey).getQ().getEncoded(true);
    }

    public static PublicKey decodeECPoint(String encode, String curveName) {
        return CryptoUtils.decodeECPoint(CryptoUtils.decode(encode), curveName);
    }

    public static PublicKey decodeECPoint(byte[] encodeByte, String curveName) {
        ECNamedCurveParameterSpec namedSpec = ECNamedCurveTable.getParameterSpec((String)curveName);
        ECCurve curve = namedSpec.getCurve();
        EllipticCurve ecCurve = new EllipticCurve(new ECFieldFp(curve.getField().getCharacteristic()), curve.getA().toBigInteger(), curve.getB().toBigInteger());
        ECPoint point = ECPointUtil.decodePoint((EllipticCurve)ecCurve, (byte[])encodeByte);
        ECNamedCurveSpec ecSpec = new ECNamedCurveSpec(curveName, curve, namedSpec.getG(), namedSpec.getN());
        KeyFactory PubKeyGen = CryptoUtils.getKeyFactory("EC");
        try {
            return PubKeyGen.generatePublic(new ECPublicKeySpec(point, (ECParameterSpec)ecSpec));
        }
        catch (GeneralSecurityException e) {
            throw new CommonException((Throwable)e);
        }
    }

    public static PrivateKey readPrivateKey(InputStream pemStream) {
        return CryptoUtils.generateRSAPrivateKey(CryptoUtils.readKeyBytes(pemStream));
    }

    public static PublicKey readPublicKey(InputStream pemStream) {
        Certificate certificate = CryptoUtils.readX509Certificate(pemStream);
        if (null == certificate) {
            return null;
        }
        return certificate.getPublicKey();
    }

    public static Key readKey(InputStream keyStream) {
        PemObject object = CryptoUtils.readPemObject(keyStream);
        String type = object.getType();
        if (StringUtils.isNotBlank((CharSequence)type) && type.endsWith("PRIVATE KEY")) {
            return CryptoUtils.generateRSAPrivateKey(object.getContent());
        }
        return CryptoUtils.readX509Certificate(keyStream).getPublicKey();
    }

    public static byte[] readKeyBytes(InputStream keyStream) {
        PemObject pemObject = CryptoUtils.readPemObject(keyStream);
        if (null != pemObject) {
            return pemObject.getContent();
        }
        return null;
    }

    public static PemObject readPemObject(InputStream keyStream) {
        PemObject pemObject;
        PemReader pemReader = null;
        try {
            pemReader = new PemReader((Reader)IoUtils.getReader((InputStream)keyStream, (String)"/"));
            pemObject = pemReader.readPemObject();
        }
        catch (IOException e) {
            try {
                throw new CommonException((Throwable)e);
            }
            catch (Throwable throwable) {
                IoUtils.close(pemReader);
                throw throwable;
            }
        }
        IoUtils.close((Closeable)pemReader);
        return pemObject;
    }

    public static SM2 sm2() {
        return new SM2();
    }

    public static SM2 sm2(String privateKeyStr, String publicKeyStr) {
        return new SM2(privateKeyStr, publicKeyStr);
    }

    public static SM2 sm2(byte[] privateKey, byte[] publicKey) {
        return new SM2(privateKey, publicKey);
    }

    public static Digester sm3() {
        return new Digester(SM3);
    }

    public static String sm3(String data) {
        return new Digester(SM3).digestHex(data);
    }

    public static String sm3(InputStream data) {
        return new Digester(SM3).digestHex(data);
    }

    public static String sm3(File dataFile) {
        return new Digester(SM3).digestHex(dataFile);
    }

    public static Symmetric sm4() {
        return new Symmetric(SM4);
    }

    public static Symmetric sm4(byte[] key) {
        return new Symmetric(SM4, key);
    }

    public static byte[] changeC1C2C3ToC1C3C2(byte[] c1c2c3, ECDomainParameters ecDomainParameters) {
        int c1Len = (ecDomainParameters.getCurve().getFieldSize() + 7) / 8 * 2 + 1;
        int c3Len = 32;
        byte[] result = new byte[c1c2c3.length];
        System.arraycopy(c1c2c3, 0, result, 0, c1Len);
        System.arraycopy(c1c2c3, c1c2c3.length - 32, result, c1Len, 32);
        System.arraycopy(c1c2c3, c1Len, result, c1Len + 32, c1c2c3.length - c1Len - 32);
        return result;
    }

    public static byte[] changeC1C3C2ToC1C2C3(byte[] c1c3c2, ECDomainParameters ecDomainParameters) {
        int c1Len = (ecDomainParameters.getCurve().getFieldSize() + 7) / 8 * 2 + 1;
        int c3Len = 32;
        byte[] result = new byte[c1c3c2.length];
        System.arraycopy(c1c3c2, 0, result, 0, c1Len);
        System.arraycopy(c1c3c2, c1Len + 32, result, c1Len, c1c3c2.length - c1Len - 32);
        System.arraycopy(c1c3c2, c1Len, result, c1c3c2.length - 32, 32);
        return result;
    }

    public static byte[] rsAsn1ToPlain(byte[] rsDer) {
        ASN1Sequence seq = ASN1Sequence.getInstance((Object)rsDer);
        byte[] r = CryptoUtils.bigIntToFixexLengthBytes(ASN1Integer.getInstance((Object)seq.getObjectAt(0)).getValue());
        byte[] s = CryptoUtils.bigIntToFixexLengthBytes(ASN1Integer.getInstance((Object)seq.getObjectAt(1)).getValue());
        byte[] result = new byte[64];
        System.arraycopy(r, 0, result, 0, r.length);
        System.arraycopy(s, 0, result, 32, s.length);
        return result;
    }

    public static byte[] rsPlainToAsn1(byte[] sign) {
        if (sign.length != 64) {
            throw new CommonException("err rs. ");
        }
        BigInteger r = new BigInteger(1, Arrays.copyOfRange((byte[])sign, (int)0, (int)32));
        BigInteger s = new BigInteger(1, Arrays.copyOfRange((byte[])sign, (int)32, (int)64));
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((ASN1Encodable)new ASN1Integer(r));
        v.add((ASN1Encodable)new ASN1Integer(s));
        try {
            return new DERSequence(v).getEncoded("DER");
        }
        catch (IOException e) {
            throw new CommonException((Throwable)e);
        }
    }

    private static byte[] bigIntToFixexLengthBytes(BigInteger rOrS) {
        byte[] rs = rOrS.toByteArray();
        if (rs.length == 32) {
            return rs;
        }
        if (rs.length == 33 && rs[0] == 0) {
            return Arrays.copyOfRange((byte[])rs, (int)1, (int)33);
        }
        if (rs.length < 32) {
            byte[] result = new byte[32];
            Arrays.fill((byte[])result, (byte)0);
            System.arraycopy(rs, 0, result, 32 - rs.length, rs.length);
            return result;
        }
        throw new CommonException("Error rs: {}", Hex.toHexString((byte[])rs));
    }

    public static byte[] md5(byte[] data) {
        return new MD5().digest(data);
    }

    public static byte[] md5(String data, String charset) {
        return new MD5().digest(data, charset);
    }

    public static String md5Hex(byte[] data) {
        return new MD5().digestHex(data);
    }

    public static String md5Hex(String data, String charset) {
        return new MD5().digestHex(data, charset);
    }

    public static String md5Hex(String data) {
        return CryptoUtils.md5Hex(data, "UTF-8");
    }

    public static String md5Hex(InputStream data) {
        return new MD5().digestHex(data);
    }

    public static String md5Hex(File file) {
        return new MD5().digestHex(file);
    }

    public static String md5HexTo16(String md5Hex) {
        return md5Hex.substring(8, 24);
    }

    public static byte[] sha1(byte[] data) {
        return new Digester("SHA-1").digest(data);
    }

    public static byte[] sha1(String data, String charset) {
        return new Digester("SHA-1").digest(data, charset);
    }

    public static String sha1Hex(byte[] data) {
        return new Digester("SHA-1").digestHex(data);
    }

    public static String sha1Hex(String data, String charset) {
        return new Digester("SHA-1").digestHex(data, charset);
    }

    public static String sha1Hex(String data) {
        return CryptoUtils.sha1Hex(data, "UTF-8");
    }

    public static String sha1Hex(InputStream data) {
        return new Digester("SHA-1").digestHex(data);
    }

    public static String sha1Hex(File file) {
        return new Digester("SHA-1").digestHex(file);
    }

    public static byte[] sha256(byte[] data) {
        return new Digester("SHA-256").digest(data);
    }

    public static byte[] sha256(String data, String charset) {
        return new Digester("SHA-256").digest(data, charset);
    }

    public static String sha256Hex(byte[] data) {
        return new Digester("SHA-256").digestHex(data);
    }

    public static String sha256Hex(String data, String charset) {
        return new Digester("SHA-256").digestHex(data, charset);
    }

    public static String sha256Hex(String data) {
        return CryptoUtils.sha256Hex(data, "UTF-8");
    }

    public static String sha256Hex(InputStream data) {
        return new Digester("SHA-256").digestHex(data);
    }

    public static String sha256Hex(File file) {
        return new Digester("SHA-256").digestHex(file);
    }

    public static Digester digester(String mode) {
        return new Digester(mode);
    }

    public static String bcrypt(String password) {
        return BCrypt.hashpw(password);
    }

    public static boolean bcryptCheck(String password, String hashed) {
        return BCrypt.checkpw(password, hashed);
    }

    private static CryptoFactory getFactory(String type) {
        if ("AES".equals(type)) {
            return LazyCryptoHolder.AES_CRYPTO_FACTORY;
        }
        if ("DES".equals(type)) {
            return LazyCryptoHolder.DES_CRYPTO_FACTORY;
        }
        if ("RSA".equals(type)) {
            return LazyCryptoHolder.RSA_CRYPTO_FACTORY;
        }
        throw new NullPointerException("\u672a\u68c0\u6d4b\u5230\u52a0\u5bc6");
    }

    public static InputStream encrypt(String type, String key, InputStream inputStream) {
        CryptoFactory factory = CryptoUtils.getFactory(type);
        byte[] bytes = IoUtils.readBytes((InputStream)inputStream);
        return new ByteArrayInputStream(factory.encrypt(key, bytes));
    }

    public static InputStream decrypt(String type, String key, InputStream inputStream) {
        CryptoFactory factory = CryptoUtils.getFactory(type);
        byte[] bytes = IoUtils.readBytes((InputStream)inputStream);
        byte[] decrypt = factory.decrypt(key, bytes);
        return new ByteArrayInputStream(decrypt);
    }

    public static byte[] encrypt(String type, String key, byte[] content) {
        CryptoFactory factory = CryptoUtils.getFactory(type);
        return factory.encrypt(key, content);
    }

    public static byte[] decrypt(String type, String key, byte[] content) {
        CryptoFactory factory = CryptoUtils.getFactory(type);
        return factory.decrypt(key, content);
    }

    public static String encrypt(String type, String key, String content, Charset charset) {
        return CryptoUtils.toHexString(CryptoUtils.encrypt(type, key, content.getBytes(charset)));
    }

    public static String decrypt(String type, String key, String content, Charset charset) {
        byte[] bytes = CryptoUtils.fromHexString(content);
        byte[] decrypt = CryptoUtils.decrypt(type, key, bytes);
        return new String(decrypt, charset);
    }

    public static int getDec(int index) {
        try {
            return DEC[index - 48];
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            return -1;
        }
    }

    public static byte getHex(int index) {
        return HEX[index];
    }

    public static String toHexString(byte[] bytes) {
        if (null == bytes) {
            return null;
        }
        StringBuilder sb = new StringBuilder(bytes.length << 1);
        for (int i = 0; i < bytes.length; ++i) {
            sb.append(hex[(bytes[i] & 0xF0) >> 4]).append(hex[bytes[i] & 0xF]);
        }
        return sb.toString();
    }

    public static byte[] fromHexString(String input) {
        if (input == null) {
            return null;
        }
        if ((input.length() & 1) == 1) {
            throw new IllegalArgumentException("The input must consist of an even number of hex digits");
        }
        char[] inputChars = input.toCharArray();
        byte[] result = new byte[input.length() >> 1];
        for (int i = 0; i < result.length; ++i) {
            int upperNibble = CryptoUtils.getDec(inputChars[2 * i]);
            int lowerNibble = CryptoUtils.getDec(inputChars[2 * i + 1]);
            if (upperNibble < 0 || lowerNibble < 0) {
                throw new IllegalArgumentException("The input must consist only of hex digits");
            }
            result[i] = (byte)((upperNibble << 4) + lowerNibble);
        }
        return result;
    }

    private static class LazyCryptoHolder {
        private static final CryptoFactory AES_CRYPTO_FACTORY = new AesCryptoFactory();
        private static final CryptoFactory DES_CRYPTO_FACTORY = new DesCryptoFactory();
        private static final CryptoFactory RSA_CRYPTO_FACTORY = new RsaCryptoFactory();

        private LazyCryptoHolder() {
        }
    }
}

