/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.crypto;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.utils.ObjectUtils;
import org.aoju.bus.crypto.Provider;
import org.aoju.bus.crypto.provider.AESProvider;
import org.aoju.bus.crypto.provider.DESProvider;
import org.aoju.bus.crypto.provider.RC4Provider;
import org.aoju.bus.crypto.provider.RSAProvider;
import org.aoju.bus.crypto.provider.SM2Provider;
import org.aoju.bus.crypto.provider.SM4Provider;

public final class Registry {
    private static Map<String, Provider> ALGORITHM_CACHE = new ConcurrentHashMap<String, Provider>();

    public static void register(String name, Provider object) {
        if (ALGORITHM_CACHE.containsKey(name)) {
            throw new InstrumentException("\u91cd\u590d\u6ce8\u518c\u540c\u540d\u79f0\u7684\u7ec4\u4ef6\uff1a" + name);
        }
        Class<?> clazz = object.getClass();
        if (ALGORITHM_CACHE.containsKey(clazz.getSimpleName())) {
            throw new InstrumentException("\u91cd\u590d\u6ce8\u518c\u540c\u7c7b\u578b\u7684\u7ec4\u4ef6\uff1a" + clazz);
        }
        ALGORITHM_CACHE.putIfAbsent(name, object);
    }

    public static Provider require(String name) {
        Provider object = ALGORITHM_CACHE.get(name);
        if (ObjectUtils.isEmpty((Object[])new Object[]{object})) {
            throw new IllegalArgumentException("none provider be found!, type:" + name);
        }
        return object;
    }

    public boolean contains(String name) {
        return ALGORITHM_CACHE.containsKey(name);
    }

    static {
        Registry.register("AES", new AESProvider());
        Registry.register("DES", new DESProvider());
        Registry.register("RC4", new RC4Provider());
        Registry.register("RSA", new RSAProvider());
        Registry.register("SM2", new SM2Provider());
        Registry.register("SM4", new SM4Provider());
    }
}

